/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.spi.swt.table;

import java.util.List;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.databinding.EMFDataBindingContext;
import org.eclipse.emfforms.spi.swt.table.AbstractTableViewerComposite;
import org.eclipse.emfforms.spi.swt.table.ColumnConfiguration;
import org.eclipse.emfforms.spi.swt.table.DefaultTableViewerColumnBuilder;
import org.eclipse.emfforms.spi.swt.table.TableControl;
import org.eclipse.emfforms.spi.swt.table.TableViewerComparator;
import org.eclipse.emfforms.spi.swt.table.TableViewerSWTCustomization;
import org.eclipse.jface.layout.AbstractColumnLayout;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerColumn;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;

public class TableViewerComposite
extends AbstractTableViewerComposite<TableViewer> {
    private TableViewer tableViewer;
    private TableViewerComparator comparator;

    TableViewerComposite(Composite parent, int style, Object inputObject, TableViewerSWTCustomization customization, IObservableValue title, IObservableValue tooltip) {
        super(parent, style, inputObject, customization, title, tooltip);
    }

    @Override
    public TableViewer getTableViewer() {
        return this.tableViewer;
    }

    @Override
    protected TableViewer createTableViewer(TableViewerSWTCustomization<TableViewer> customization, Composite viewerComposite) {
        this.tableViewer = (TableViewer)customization.createTableViewer(viewerComposite);
        return this.tableViewer;
    }

    @Override
    protected AbstractColumnLayout createLayout(Composite viewerComposite) {
        TableColumnLayout layout = new TableColumnLayout();
        viewerComposite.setLayout((Layout)layout);
        return layout;
    }

    @Override
    public Widget[] getColumns() {
        return this.tableViewer.getTable().getColumns();
    }

    @Override
    public void addColumnListener(ControlListener columnlistener) {
        int i = 0;
        while (i < this.tableViewer.getTable().getColumns().length) {
            TableColumn tableColumn = this.tableViewer.getTable().getColumns()[i];
            tableColumn.addControlListener(columnlistener);
            ++i;
        }
    }

    @Override
    public TableControl getTableControl() {
        return new TableControl(){

            @Override
            public boolean isDisposed() {
                return TableViewerComposite.this.getTableViewer().getTable().isDisposed();
            }

            @Override
            public int getItemHeight() {
                return TableViewerComposite.this.getTableViewer().getTable().getItemHeight();
            }

            @Override
            public boolean getHeaderVisible() {
                return TableViewerComposite.this.getTableViewer().getTable().getHeaderVisible();
            }

            @Override
            public int getHeaderHeight() {
                return TableViewerComposite.this.getTableViewer().getTable().getHeaderHeight();
            }

            @Override
            public int getItemCount() {
                return TableViewerComposite.this.getTableViewer().getTable().getItemCount();
            }
        };
    }

    @Override
    protected ViewerColumn createColumn(ColumnConfiguration config, EMFDataBindingContext emfDataBindingContext, TableViewer tableViewer) {
        return new DefaultTableViewerColumnBuilder(config).withDatabinding(emfDataBindingContext).build(tableViewer);
    }

    @Override
    public void setComparator(TableViewerComparator comparator, List<Integer> sortableColumns) {
        this.comparator = comparator;
        int i = 0;
        while (i < this.getTableViewer().getTable().getColumns().length) {
            if (sortableColumns.contains(i)) {
                final int j = i;
                TableColumn tableColumn = this.getTableViewer().getTable().getColumns()[i];
                SelectionAdapter selectionAdapter = new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        TableViewerComposite.this.setCompareColumn(j);
                    }
                };
                tableColumn.addSelectionListener((SelectionListener)selectionAdapter);
            }
            ++i;
        }
    }

    @Override
    public void dispose() {
        this.tableViewer.getControl().dispose();
        this.tableViewer = null;
        super.dispose();
    }

    @Override
    public void setCompareColumn(int column) {
        TableColumn tableColumn = this.getTableViewer().getTable().getColumns()[column];
        this.comparator.setColumn(column);
        this.tableViewer.getTable().setSortDirection(this.comparator.getDirection());
        this.tableViewer.getTable().setSortColumn(tableColumn);
        this.tableViewer.refresh();
    }
}

