/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.core.services.domainexpander.index;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecp.common.spi.asserts.Assert;
import org.eclipse.emf.ecp.view.spi.indexdmr.model.VIndexDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VFeaturePathDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VViewFactory;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;
import org.eclipse.emfforms.spi.core.services.domainexpander.EMFFormsDMRExpander;
import org.eclipse.emfforms.spi.core.services.domainexpander.EMFFormsDomainExpander;
import org.eclipse.emfforms.spi.core.services.domainexpander.EMFFormsExpandingFailedException;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(name="EMFFormsIndexDMRExpander")
public class EMFFormsIndexDMRExpander
implements EMFFormsDMRExpander {
    private ReportService reportService;
    private EMFFormsDomainExpander domainExpander;
    private EMFFormsDatabinding databindingService;
    private BundleContext bundleContext;
    private ServiceReference<EMFFormsDomainExpander> eMFFormsDomainExpanderServiceReference;

    @Reference(unbind="-")
    protected void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    @Deactivate
    protected void deactivate(BundleContext bundleContext) {
        if (this.eMFFormsDomainExpanderServiceReference != null) {
            bundleContext.ungetService(this.eMFFormsDomainExpanderServiceReference);
            this.domainExpander = null;
        }
    }

    private EMFFormsDomainExpander getEMFFormsDomainExpander() {
        if (this.domainExpander == null) {
            this.eMFFormsDomainExpanderServiceReference = this.bundleContext.getServiceReference(EMFFormsDomainExpander.class);
            if (this.eMFFormsDomainExpanderServiceReference == null) {
                throw new IllegalStateException("No EMFFormsDomainExpander available!");
            }
            this.domainExpander = (EMFFormsDomainExpander)this.bundleContext.getService(this.eMFFormsDomainExpanderServiceReference);
        }
        return this.domainExpander;
    }

    void setEMFFormsDomainExpander(EMFFormsDomainExpander domainExpander) {
        this.domainExpander = domainExpander;
    }

    @Reference(unbind="-")
    protected void setEMFFormsDatabinding(EMFFormsDatabinding emfFormsDatabinding) {
        this.databindingService = emfFormsDatabinding;
    }

    public void prepareDomainObject(VDomainModelReference domainModelReference, EObject domainObject) throws EMFFormsExpandingFailedException {
        IValueProperty valueProperty;
        VDomainModelReference prefixDMR;
        Assert.create((Object)domainModelReference).notNull();
        Assert.create((Object)domainObject).notNull();
        Assert.create((Object)domainModelReference).ofClass(VIndexDomainModelReference.class);
        VIndexDomainModelReference indexReference = (VIndexDomainModelReference)VIndexDomainModelReference.class.cast(domainModelReference);
        VDomainModelReference targetDMR = indexReference.getTargetDMR();
        if (indexReference.getPrefixDMR() != null) {
            prefixDMR = indexReference.getPrefixDMR();
        } else {
            if (indexReference.getDomainModelEFeature() == null) {
                throw new EMFFormsExpandingFailedException("The index domain model reference's domain model e feature must not be null when the reference's prefix dmr is null.");
            }
            VFeaturePathDomainModelReference prefixFeatureDMR = VViewFactory.eINSTANCE.createFeaturePathDomainModelReference();
            prefixFeatureDMR.setDomainModelEFeature(indexReference.getDomainModelEFeature());
            prefixFeatureDMR.getDomainModelEReferencePath().addAll((Collection)indexReference.getDomainModelEReferencePath());
            prefixDMR = prefixFeatureDMR;
        }
        try {
            valueProperty = this.databindingService.getValueProperty(prefixDMR, domainObject);
        }
        catch (DatabindingFailedException ex) {
            throw new EMFFormsExpandingFailedException("Domain Expansion failed due to a failed databinding: " + ex.getMessage());
        }
        EStructuralFeature listEStructuralFeature = (EStructuralFeature)valueProperty.getValueType();
        this.checkListType(listEStructuralFeature);
        this.getEMFFormsDomainExpander().prepareDomainObject(prefixDMR, domainObject);
        EClass featureEClass = (EClass)EClass.class.cast(listEStructuralFeature.getEType());
        List list = (List)valueProperty.getValue((Object)domainObject);
        if (!featureEClass.isAbstract() && !featureEClass.isInterface()) {
            int i = 0;
            while (i <= indexReference.getIndex()) {
                if (list.size() <= i) {
                    list.add(EcoreUtil.create((EClass)featureEClass));
                } else if (list.get(i) == null) {
                    list.set(i, EcoreUtil.create((EClass)featureEClass));
                }
                ++i;
            }
        } else {
            throw new EMFFormsExpandingFailedException("Could not expand the VIndexDomainModelReference because the type of the prefix DMR's domain model e feature is either abstract or an interface. Hence, no new instances of this type can be created.");
        }
        EObject targetDomainObject = (EObject)list.get(indexReference.getIndex());
        this.getEMFFormsDomainExpander().prepareDomainObject(targetDMR, targetDomainObject);
    }

    public double isApplicable(VDomainModelReference domainModelReference) {
        if (domainModelReference == null) {
            this.reportService.report(new AbstractReport("Warning: The given domain model reference was null."));
            return NOT_APPLICABLE;
        }
        if (VIndexDomainModelReference.class.isInstance(domainModelReference)) {
            return 5.0;
        }
        return NOT_APPLICABLE;
    }

    private void checkListType(EStructuralFeature structuralFeature) throws EMFFormsExpandingFailedException {
        if (!structuralFeature.isMany()) {
            throw new EMFFormsExpandingFailedException("The VIndexDomainModelReference's domainModelEFeature must reference a list.");
        }
        if (!EReference.class.isInstance(structuralFeature)) {
            throw new EMFFormsExpandingFailedException("The VIndexDomainModelReference's domainModelEFeature must reference a list of EObjects.");
        }
    }
}

