/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.core.services.reveal;

import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Optional;
import org.eclipse.e4.core.contexts.ContextFunction;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.InjectionException;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.common.spi.BidirectionalMap;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emfforms.bazaar.Bazaar;
import org.eclipse.emfforms.bazaar.BazaarContext;
import org.eclipse.emfforms.bazaar.Vendor;
import org.eclipse.emfforms.common.TriConsumer;
import org.eclipse.emfforms.internal.core.services.reveal.RevealHelperImpl;
import org.eclipse.emfforms.spi.bazaar.BazaarUtil;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.reveal.EMFFormsRevealProvider;
import org.eclipse.emfforms.spi.core.services.reveal.EMFFormsRevealService;
import org.eclipse.emfforms.spi.core.services.reveal.RevealHelper;
import org.eclipse.emfforms.spi.core.services.reveal.RevealStep;
import org.eclipse.emfforms.spi.core.services.view.EMFFormsContextTracker;
import org.eclipse.emfforms.spi.core.services.view.EMFFormsViewContext;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public class EMFFormsRevealServiceImpl
implements EMFFormsRevealService {
    private final Bazaar<RevealStep> stepBazaar = BazaarUtil.createBazaar((Object)RevealStep.FAILED);
    private final BidirectionalMap<VElement, EMFFormsViewContext> detailContexts = new BidirectionalMap();
    private final EMFFormsViewContext viewContext;
    private IEclipseContext e4Context;

    public EMFFormsRevealServiceImpl(EMFFormsViewContext viewContext) {
        this.viewContext = viewContext;
        new EMFFormsContextTracker(viewContext).onChildContextAdded((TriConsumer<? super EMFFormsViewContext, ? super VElement, ? super EMFFormsViewContext>)((TriConsumer)this::childContextAdded)).onChildContextRemoved((TriConsumer<? super EMFFormsViewContext, ? super VElement, ? super EMFFormsViewContext>)((TriConsumer)this::childContextRemoved)).onContextDisposed(this::contextDisposed).open();
    }

    private void contextDisposed(EMFFormsViewContext ctx) {
        if (ctx == this.viewContext && this.e4Context != null) {
            IEclipseContext toDispose = this.e4Context;
            this.e4Context = null;
            toDispose.dispose();
        }
    }

    @Override
    public boolean reveal(EObject object) {
        RevealStep step = this.reveal(object, null, this.viewContext.getViewModel());
        return this.perform(step);
    }

    @Override
    public boolean reveal(EObject object, EStructuralFeature feature) {
        RevealStep step = this.reveal(object, feature, this.viewContext.getViewModel());
        if (step.isFailed() && feature != null) {
            step = this.reveal(object, this.viewContext.getViewModel());
        }
        return this.perform(step);
    }

    boolean perform(RevealStep revealStep) {
        boolean result;
        RevealStep step = revealStep;
        while (!step.isDone()) {
            step = step.drillDown();
        }
        boolean bl = result = !step.isFailed();
        if (result) {
            step.reveal();
        }
        return result;
    }

    @Override
    public RevealStep reveal(EObject object, VElement scope) {
        return this.reveal(object, null, scope);
    }

    @Override
    public RevealStep reveal(EObject object, EStructuralFeature feature, VElement scope) {
        IEclipseContext e4Context = this.createLocalContext("Reveal Service Bazaar", scope, object, feature, null);
        try {
            BazaarContext context = BazaarContext.Builder.empty().put(IEclipseContext.class, (Object)e4Context).build();
            RevealStep revealStep = Optional.ofNullable((RevealStep)this.stepBazaar.createProduct(context)).orElse(RevealStep.fail());
            return revealStep;
        }
        finally {
            e4Context.dispose();
        }
    }

    private IEclipseContext getEclipseContext() {
        if (this.e4Context == null) {
            this.e4Context = this.viewContext.getService(IEclipseContext.class);
            if (this.e4Context == null) {
                Bundle bundle = FrameworkUtil.getBundle(EMFFormsRevealServiceImpl.class);
                this.e4Context = EclipseContextFactory.createServiceContext((BundleContext)bundle.getBundleContext());
            } else {
                this.e4Context = this.e4Context.createChild("Reveal Service");
            }
            this.e4Context.set(EMFFormsRevealService.class, (Object)this);
            this.e4Context.set(EMFFormsRevealServiceImpl.class, (Object)this);
            this.e4Context.set(EMFFormsViewContext.class, (Object)this.viewContext);
            this.e4Context.set(RevealHelper.class.getName(), (Object)new ContextFunction(){

                public Object compute(IEclipseContext context, String contextKey) {
                    return ContextInjectionFactory.make(RevealHelperImpl.class, (IEclipseContext)context);
                }
            });
        }
        return this.e4Context;
    }

    final <T> Optional<T> evaluate(Class<? extends Annotation> annotation, Class<T> resultType, VElement element, EObject object, EStructuralFeature feature, Object computation) {
        return this.evaluate(annotation, resultType, element, object, feature, null, computation);
    }

    final <T> Optional<T> evaluate(Class<? extends Annotation> annotation, Class<T> resultType, VElement element, EObject object, EStructuralFeature feature, Map<Class<?>, ?> parameters, Object computation) {
        IEclipseContext localContext = this.createLocalContext("invocation", element, object, feature, parameters);
        try {
            Optional<T> optional = this.evaluate(annotation, resultType, localContext, computation);
            return optional;
        }
        finally {
            localContext.dispose();
        }
    }

    final <T> Optional<T> evaluate(Class<? extends Annotation> annotation, Class<T> resultType, IEclipseContext context, Object computation) {
        Object result;
        try {
            result = ContextInjectionFactory.invoke((Object)computation, annotation, (IEclipseContext)context, null);
        }
        catch (InjectionException e) {
            this.report(new AbstractReport(e.getCause(), e.getMessage()));
            result = null;
        }
        return Optional.ofNullable(result).filter(resultType::isInstance).map(resultType::cast);
    }

    private IEclipseContext createLocalContext(String debugLabel, VElement viewModel, EObject domainModel, EStructuralFeature feature, Map<Class<?>, ?> parameters) {
        IEclipseContext result = this.getEclipseContext().createChild(debugLabel);
        this.fill(result, viewModel, domainModel, feature);
        if (parameters != null) {
            for (Map.Entry<Class<?>, ?> entry : parameters.entrySet()) {
                String key = entry.getKey().getName();
                if (result.containsKey(key)) continue;
                result.set(key, entry.getValue());
            }
        }
        return result;
    }

    private void fill(IEclipseContext context, VElement viewModel, EObject domainModel, EStructuralFeature feature) {
        String eObjectClassName = EObject.class.getName();
        context.set(eObjectClassName, (Object)domainModel);
        if (feature != null) {
            context.set(EStructuralFeature.class, (Object)feature);
        }
        context.set(viewModel.eClass().getInstanceClassName(), (Object)viewModel);
        for (EClass next : viewModel.eClass().getEAllSuperTypes()) {
            String superclassName = next.getInstanceClassName();
            if (eObjectClassName.equals(superclassName)) continue;
            context.set(superclassName, (Object)viewModel);
        }
        EMFFormsViewContext viewContext = this.getViewContext(viewModel);
        if (viewContext != null) {
            context.set(EMFFormsViewContext.class, (Object)viewContext);
        }
    }

    private void report(AbstractReport report) {
        ReportService service = this.viewContext.getService(ReportService.class);
        if (service != null) {
            service.report(report);
        } else if (report.hasException()) {
            report.getException().printStackTrace();
        }
    }

    protected EMFFormsViewContext getViewContext(VElement element) {
        EMFFormsViewContext result = null;
        VElement parent = element;
        while (result == null && parent != null) {
            if (parent instanceof VElement) {
                result = (EMFFormsViewContext)this.detailContexts.getValue((Object)parent);
            }
            parent = parent.eContainer();
        }
        if (result == null) {
            result = this.viewContext;
        }
        return result;
    }

    @Override
    public void addRevealProvider(EMFFormsRevealProvider provider) {
        this.stepBazaar.addVendor((Vendor)provider);
    }

    @Override
    public void removeRevealProvider(EMFFormsRevealProvider provider) {
        this.stepBazaar.removeVendor((Vendor)provider);
    }

    private void childContextAdded(EMFFormsViewContext parentContext, VElement parentElement, EMFFormsViewContext childContext) {
        this.detailContexts.put((Object)childContext.getViewModel(), (Object)childContext);
    }

    private void childContextRemoved(EMFFormsViewContext parentContext, VElement parentElement, EMFFormsViewContext childContext) {
        this.detailContexts.removeByValue((Object)childContext);
    }

    EMFFormsViewContext getDetailContext(EObject masterSelection) {
        return this.detailContexts.values().stream().filter(ctx -> ctx.getDomainModel() == masterSelection).findAny().orElse(null);
    }
}

