/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.swt.table.util;

import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emfforms.common.ServiceObjectTracker;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public class DMRCellLabelProvider
extends CellLabelProvider {
    private final VDomainModelReference dmr;
    private final EMFFormsDatabinding databindingService;
    private ServiceObjectTracker<EMFFormsDatabinding> databindingTracker;

    public DMRCellLabelProvider(VDomainModelReference dmr) {
        this(dmr, null);
    }

    public DMRCellLabelProvider(VDomainModelReference dmr, EMFFormsDatabinding databindingService) {
        this.dmr = dmr;
        this.databindingService = databindingService == null ? this.getService() : databindingService;
    }

    public String getToolTipText(Object element) {
        IObservableValue observableValue;
        EObject domainObject = (EObject)element;
        try {
            observableValue = this.databindingService.getObservableValue(this.dmr, domainObject);
        }
        catch (DatabindingFailedException ex) {
            return null;
        }
        Object value = observableValue.getValue();
        observableValue.dispose();
        if (value == null) {
            return null;
        }
        return String.valueOf(value);
    }

    public void update(ViewerCell cell) {
        EObject element = (EObject)cell.getElement();
        try {
            IObservableValue observableValue = this.databindingService.getObservableValue(this.dmr, element);
            Object value = observableValue.getValue();
            observableValue.dispose();
            if (value == null) {
                cell.setText("");
            }
            cell.setText(String.valueOf(value));
        }
        catch (DatabindingFailedException ex) {
            cell.setText("");
        }
    }

    private EMFFormsDatabinding getService() {
        Bundle bundle = FrameworkUtil.getBundle(DMRCellLabelProvider.class);
        BundleContext bundleContext = bundle.getBundleContext();
        this.databindingTracker = new ServiceObjectTracker(bundleContext, EMFFormsDatabinding.class);
        return (EMFFormsDatabinding)this.databindingTracker.getService();
    }

    public void dispose() {
        this.databindingTracker.dispose();
        super.dispose();
    }
}

