/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.core.services.segments.multi;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.common.spi.UniqueSetting;
import org.eclipse.emf.ecp.common.spi.asserts.Assert;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedReport;
import org.eclipse.emfforms.spi.core.services.databinding.emf.EMFFormsDatabindingEMF;
import org.eclipse.emfforms.spi.core.services.mappingprovider.EMFFormsMappingProvider;
import org.eclipse.emfforms.view.spi.multisegment.model.MultiSegmentUtil;
import org.eclipse.emfforms.view.spi.multisegment.model.VMultiDomainModelReferenceSegment;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(name="EMFFormsMappingProviderMulti")
public class EMFFormsMappingProviderMulti
implements EMFFormsMappingProvider {
    private EMFFormsDatabindingEMF emfFormsDatabinding;
    private ReportService reportService;

    @Reference(unbind="-")
    protected void setEMFFormsDatabinding(EMFFormsDatabindingEMF emfFormsDatabinding) {
        this.emfFormsDatabinding = emfFormsDatabinding;
    }

    @Reference(unbind="-")
    protected void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    public Set<UniqueSetting> getMappingFor(VDomainModelReference domainModelReference, EObject domainObject) {
        EStructuralFeature.Setting multiSetting;
        Assert.create((Object)domainModelReference).notNull();
        Assert.create((Object)domainObject).notNull();
        EList segments = domainModelReference.getSegments();
        if (segments.isEmpty()) {
            throw new IllegalArgumentException("The DMR does not contain any segments.");
        }
        if (!VMultiDomainModelReferenceSegment.class.isInstance(segments.get(segments.size() - 1))) {
            throw new IllegalArgumentException("The last segment of the DMR must be a VMultiDomainModelReferenceSegment.");
        }
        VMultiDomainModelReferenceSegment multiSegment = (VMultiDomainModelReferenceSegment)segments.get(segments.size() - 1);
        try {
            multiSetting = this.emfFormsDatabinding.getSetting(domainModelReference, domainObject);
        }
        catch (DatabindingFailedException ex) {
            this.reportService.report((AbstractReport)new DatabindingFailedReport((Throwable)ex));
            return Collections.emptySet();
        }
        LinkedHashSet<UniqueSetting> settings = new LinkedHashSet<UniqueSetting>();
        settings.add(UniqueSetting.createSetting((EStructuralFeature.Setting)multiSetting));
        for (EObject eObject : (List)multiSetting.get(true)) {
            for (VDomainModelReference childDMR : multiSegment.getChildDomainModelReferences()) {
                try {
                    EStructuralFeature.Setting childSetting = this.emfFormsDatabinding.getSetting(childDMR, eObject);
                    settings.add(UniqueSetting.createSetting((EStructuralFeature.Setting)childSetting));
                }
                catch (DatabindingFailedException ex) {
                    this.reportService.report((AbstractReport)new DatabindingFailedReport((Throwable)ex));
                }
            }
        }
        return settings;
    }

    public double isApplicable(VDomainModelReference domainModelReference, EObject domainObject) {
        if (domainModelReference == null) {
            this.reportService.report(new AbstractReport("The given VDomainModelReference was null.", 2));
            return Double.NEGATIVE_INFINITY;
        }
        if (domainObject == null) {
            this.reportService.report(new AbstractReport("The given domain object was null.", 2));
            return Double.NEGATIVE_INFINITY;
        }
        EList segments = domainModelReference.getSegments();
        if (segments.isEmpty()) {
            return Double.NEGATIVE_INFINITY;
        }
        return MultiSegmentUtil.getMultiSegment((VDomainModelReference)domainModelReference).map(m -> 6.0).orElse(Double.NEGATIVE_INFINITY);
    }
}

