/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.spreadsheet.core.converter;

import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EDataType;

public final class NumberFormatHelper {
    private static final String EMF_META_DATA = "http:///org/eclipse/emf/ecore/util/ExtendedMetaData";
    private static final String FRACTION_DIGITS = "fractionDigits";
    private static final String TOTAL_DIGITS = "totalDigits";

    private NumberFormatHelper() {
    }

    public static String getNumberFormat(EAttribute eAttribute) {
        EDataType eDataType = eAttribute.getEAttributeType();
        if (!Number.class.isAssignableFrom(eDataType.getInstanceClass())) {
            return null;
        }
        EAnnotation eAnnotation = eDataType.getEAnnotation(EMF_META_DATA);
        if (eAnnotation == null) {
            return null;
        }
        EMap details = eAnnotation.getDetails();
        if (details == null) {
            return null;
        }
        int numTotalDigits = -1;
        if (details.containsKey((Object)TOTAL_DIGITS)) {
            numTotalDigits = Integer.parseInt((String)details.get((Object)TOTAL_DIGITS));
        }
        int numFractionDigits = -1;
        if (details.containsKey((Object)FRACTION_DIGITS)) {
            numFractionDigits = Integer.parseInt((String)details.get((Object)FRACTION_DIGITS));
        }
        if (numTotalDigits > 0 && numFractionDigits > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("0");
            sb.append(".");
            int i = 0;
            while (i < numFractionDigits) {
                sb.append("0");
                ++i;
            }
            return sb.toString();
        }
        return null;
    }
}

