/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.core.services.segments.multi;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReferenceSegment;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emfforms.internal.core.services.segments.featurepath.FeatureSegmentConverter;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.emf.DomainModelReferenceSegmentConverterEMF;
import org.eclipse.emfforms.spi.core.services.databinding.emf.SegmentConverterListResultEMF;
import org.eclipse.emfforms.spi.core.services.databinding.emf.SegmentConverterValueResultEMF;
import org.eclipse.emfforms.view.spi.multisegment.model.VMultiDomainModelReferenceSegment;
import org.osgi.service.component.annotations.Component;

@Component(name="MultiSegmentConverter", service={DomainModelReferenceSegmentConverterEMF.class})
public class MultiSegmentConverter
extends FeatureSegmentConverter {
    public double isApplicable(VDomainModelReferenceSegment segment) {
        if (VMultiDomainModelReferenceSegment.class.isInstance(segment)) {
            return 10.0;
        }
        return Double.NEGATIVE_INFINITY;
    }

    public SegmentConverterValueResultEMF convertToValueProperty(VDomainModelReferenceSegment segment, EClass segmentRoot, EditingDomain editingDomain) throws DatabindingFailedException {
        SegmentConverterValueResultEMF result = super.convertToValueProperty(segment, segmentRoot, editingDomain);
        this.checkForMultiReference(result.getValueProperty().getStructuralFeature());
        return result;
    }

    public SegmentConverterListResultEMF convertToListProperty(VDomainModelReferenceSegment segment, EClass segmentRoot, EditingDomain editingDomain) throws DatabindingFailedException {
        SegmentConverterListResultEMF result = super.convertToListProperty(segment, segmentRoot, editingDomain);
        this.checkForMultiReference(result.getListProperty().getStructuralFeature());
        return result;
    }

    public EStructuralFeature.Setting getSetting(VDomainModelReferenceSegment segment, EObject eObject) throws DatabindingFailedException {
        EStructuralFeature.Setting setting = super.getSetting(segment, eObject);
        this.checkForMultiReference(setting.getEStructuralFeature());
        return setting;
    }

    private void checkForMultiReference(EStructuralFeature feature) throws DatabindingFailedException {
        if (!feature.isMany() || !EReference.class.isInstance(feature)) {
            throw new DatabindingFailedException("The multi segment's domain model feature must be a multi reference.");
        }
    }
}

