/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.core.services.mappingprovider.defaultheuristic;

import java.util.Collections;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.common.spi.UniqueSetting;
import org.eclipse.emf.ecp.common.spi.asserts.Assert;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedReport;
import org.eclipse.emfforms.spi.core.services.databinding.emf.EMFFormsDatabindingEMF;
import org.eclipse.emfforms.spi.core.services.mappingprovider.EMFFormsMappingProvider;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(name="EMFFormsMappingProviderDefaultHeuristic")
public class EMFFormsMappingProviderDefaultHeuristic
implements EMFFormsMappingProvider {
    private EMFFormsDatabindingEMF emfFormsDatabinding;
    private ReportService reportService;

    @Reference(unbind="-")
    protected void setEMFFormsDatabinding(EMFFormsDatabindingEMF emfFormsDatabinding) {
        this.emfFormsDatabinding = emfFormsDatabinding;
    }

    @Reference(unbind="-")
    protected void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    public Set<UniqueSetting> getMappingFor(VDomainModelReference domainModelReference, EObject domainObject) {
        EStructuralFeature.Setting setting;
        Assert.create((Object)domainModelReference).notNull();
        Assert.create((Object)domainObject).notNull();
        try {
            setting = this.emfFormsDatabinding.getSetting(domainModelReference, domainObject);
        }
        catch (DatabindingFailedException ex) {
            this.reportService.report((AbstractReport)new DatabindingFailedReport((Throwable)ex));
            return Collections.emptySet();
        }
        UniqueSetting uniqueSetting = UniqueSetting.createSetting((EStructuralFeature.Setting)setting);
        return Collections.singleton(uniqueSetting);
    }

    public double isApplicable(VDomainModelReference domainModelReference, EObject domainObject) {
        if (domainModelReference == null) {
            this.reportService.report(new AbstractReport("Warning: The given VDomainModelReference was null."));
            return Double.NEGATIVE_INFINITY;
        }
        if (domainObject == null) {
            this.reportService.report(new AbstractReport("Warning: The given domain object was null."));
            return Double.NEGATIVE_INFINITY;
        }
        return 1.0;
    }
}

