/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.internal.core.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecp.internal.core.Activator;
import org.eclipse.emf.ecp.spi.core.util.DisposeException;
import org.eclipse.emf.ecp.spi.core.util.ECPDisposable;

public class Disposable
implements ECPDisposable {
    private final List<ECPDisposable.DisposeListener> listeners = new ArrayList<ECPDisposable.DisposeListener>();
    private final ECPDisposable delegate;
    private boolean disposed;

    public Disposable(ECPDisposable delegate) {
        this.delegate = delegate;
    }

    @Override
    public final synchronized boolean isDisposed() {
        return this.disposed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void dispose() {
        ECPDisposable.DisposeListener[] array = null;
        Disposable disposable = this;
        synchronized (disposable) {
            if (!this.disposed) {
                this.doDispose();
                this.disposed = true;
                array = this.listeners.toArray(new ECPDisposable.DisposeListener[this.listeners.size()]);
            }
        }
        if (array != null) {
            int i = 0;
            while (i < array.length) {
                ECPDisposable.DisposeListener listener = array[i];
                try {
                    listener.disposed(this.delegate);
                }
                catch (DisposeException ex) {
                    Activator.log(ex);
                }
                ++i;
            }
        }
    }

    @Override
    public final synchronized void addDisposeListener(ECPDisposable.DisposeListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public final synchronized void removeDisposeListener(ECPDisposable.DisposeListener listener) {
        this.listeners.remove(listener);
    }

    protected void doDispose() {
    }
}

