/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.emf2web.json.util;

import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecp.emf2web.util.AbstractReferenceHelper;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VFeaturePathDomainModelReference;
import org.eclipse.emf.ecp.view.spi.table.model.VTableDomainModelReference;

public class ReferenceHelperImpl
extends AbstractReferenceHelper {
    private static final String ROOT = "#";
    private static final String SEPARATOR = "/";
    private static final String PROPERTIES = "properties";
    private static final String ITEMS = "items";
    private String ecorePath;

    public String getStringRepresentation(VDomainModelReference reference) {
        if (VTableDomainModelReference.class.isInstance(reference)) {
            return this.buildSchemaPath((VTableDomainModelReference)reference);
        }
        return this.buildSchemaPath((VFeaturePathDomainModelReference)reference);
    }

    private String buildSchemaPath(VTableDomainModelReference reference) {
        if (reference.getDomainModelReference() == null) {
            return this.buildSchemaPath((VFeaturePathDomainModelReference)reference);
        }
        return this.getStringRepresentation(reference.getDomainModelReference());
    }

    private String buildSchemaPath(VFeaturePathDomainModelReference reference) {
        StringBuilder fragments = new StringBuilder(ROOT);
        for (EReference ref : reference.getDomainModelEReferencePath()) {
            fragments.append(SEPARATOR);
            if (ReferenceHelperImpl.isArray(ref)) {
                fragments.append(ITEMS);
            } else {
                fragments.append(PROPERTIES);
            }
            fragments.append(SEPARATOR);
            fragments.append(ref.getName());
        }
        fragments.append(SEPARATOR);
        fragments.append(PROPERTIES);
        fragments.append(SEPARATOR);
        fragments.append(reference.getDomainModelEFeature().getName());
        return fragments.toString();
    }

    private static boolean isArray(EReference ref) {
        return ref.getUpperBound() > 1;
    }

    public void setEcorePath(String ecorePath) {
        this.ecorePath = ecorePath;
    }

    protected String getEcorePath() {
        return this.ecorePath;
    }
}

