/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.spreadsheet.core.converter;

import java.text.MessageFormat;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emfforms.spi.spreadsheet.core.converter.EMFFormsConverterException;
import org.eclipse.emfforms.spi.spreadsheet.core.converter.EMFFormsSpreadsheetValueConverter;
import org.eclipse.emfforms.spi.spreadsheet.core.converter.EMFFormsSpreadsheetValueConverterRegistry;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(name="EMFFormsSpreadsheetValueConverterRegistryImpl")
public class EMFFormsSpreadsheetValueConverterRegistryImpl
implements EMFFormsSpreadsheetValueConverterRegistry {
    private final Set<EMFFormsSpreadsheetValueConverter> allConverter = new CopyOnWriteArraySet<EMFFormsSpreadsheetValueConverter>();

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void addConverter(EMFFormsSpreadsheetValueConverter converter) {
        this.allConverter.add(converter);
    }

    public void removeConverter(EMFFormsSpreadsheetValueConverter converter) {
        this.allConverter.remove(converter);
    }

    @Override
    public EMFFormsSpreadsheetValueConverter getConverter(EObject domainObject, VDomainModelReference dmr) throws EMFFormsConverterException {
        double highestPrio = -4.9E-324;
        LinkedHashSet<EMFFormsSpreadsheetValueConverter> applicableConverters = new LinkedHashSet<EMFFormsSpreadsheetValueConverter>();
        for (EMFFormsSpreadsheetValueConverter current : this.allConverter) {
            double currentPrio = current.isApplicable(domainObject, dmr);
            if (Double.isNaN(currentPrio) || highestPrio > currentPrio) continue;
            if (highestPrio < currentPrio) {
                applicableConverters.clear();
            }
            highestPrio = currentPrio;
            applicableConverters.add(current);
        }
        if (applicableConverters.isEmpty()) {
            throw new EMFFormsConverterException(MessageFormat.format("No converter found for domain model reference: {0}.", dmr));
        }
        if (applicableConverters.size() > 1) {
            throw new EMFFormsConverterException(MessageFormat.format("Multiple converters with same priority registered for domain model reference: {0}.", dmr));
        }
        return (EMFFormsSpreadsheetValueConverter)applicableConverters.iterator().next();
    }
}

