/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.spreadsheet.core.renderer.categorization;

import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.WorkbookUtil;
import org.eclipse.emf.ecp.view.spi.categorization.model.VCategory;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.VAttachment;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.emfforms.spi.view.annotation.model.VAnnotation;
import org.eclipse.emf.emfforms.spi.view.annotation.model.VAnnotationFactory;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.spreadsheet.core.EMFFormsAbstractSpreadsheetRenderer;
import org.eclipse.emfforms.spi.spreadsheet.core.EMFFormsNoRendererException;
import org.eclipse.emfforms.spi.spreadsheet.core.EMFFormsSpreadsheetRenderTarget;
import org.eclipse.emfforms.spi.spreadsheet.core.EMFFormsSpreadsheetRendererFactory;
import org.eclipse.emfforms.spi.spreadsheet.core.EMFFormsSpreadsheetReport;

public class EMFFormsCategoryRenderer
extends EMFFormsAbstractSpreadsheetRenderer<VCategory> {
    private static final String SHEET_NAME_KEY = "SheetNameKey";
    private final EMFFormsSpreadsheetRendererFactory rendererFactory;
    private final ReportService reportService;

    public EMFFormsCategoryRenderer(EMFFormsSpreadsheetRendererFactory rendererFactory, ReportService reportService) {
        this.rendererFactory = rendererFactory;
        this.reportService = reportService;
    }

    public int render(Workbook workbook, VCategory vElement, ViewModelContext viewModelContext, EMFFormsSpreadsheetRenderTarget renderTarget) {
        int numberRenderedColumns = 0;
        try {
            EMFFormsAbstractSpreadsheetRenderer renderer = this.rendererFactory.getRendererInstance((VElement)vElement.getComposite(), viewModelContext);
            String sheetName = this.getSheetName(workbook, vElement);
            numberRenderedColumns += renderer.render(workbook, (VElement)vElement.getComposite(), viewModelContext, new EMFFormsSpreadsheetRenderTarget(sheetName, renderTarget.getRow(), 0));
        }
        catch (EMFFormsNoRendererException ex) {
            this.reportService.report((AbstractReport)new EMFFormsSpreadsheetReport((Throwable)ex, 4));
        }
        return numberRenderedColumns;
    }

    private String getSheetName(Workbook workbook, VCategory vElement) {
        for (VAttachment vAttachment : vElement.getAttachments()) {
            if (!VAnnotation.class.isInstance(vAttachment) || !SHEET_NAME_KEY.equals(((VAnnotation)VAnnotation.class.cast(vAttachment)).getKey())) continue;
            return ((VAnnotation)VAnnotation.class.cast(vAttachment)).getValue();
        }
        VAnnotation annotation = VAnnotationFactory.eINSTANCE.createAnnotation();
        annotation.setKey(SHEET_NAME_KEY);
        String sheetName = WorkbookUtil.createSafeSheetName((String)(String.valueOf(workbook.getNumberOfSheets() + 1) + " " + vElement.getLabel()));
        annotation.setValue(sheetName);
        vElement.getAttachments().add((Object)annotation);
        return annotation.getValue();
    }
}

