/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.edapt;

import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public final class CustomMigrationHelper {
    private static final String MIGRATION = "migration";
    private static final String POINT_ID = "org.eclipse.emf.ecp.view.edapt.customMigrations";
    private static CustomMigrationHelper customMigrationHelper;
    private final Map<String, String> classToBundleMap = new LinkedHashMap<String, String>();

    private CustomMigrationHelper() {
        this.loadExtensionPoint();
    }

    public static CustomMigrationHelper getInstance() {
        if (customMigrationHelper == null) {
            customMigrationHelper = new CustomMigrationHelper();
        }
        return customMigrationHelper;
    }

    private void loadExtensionPoint() {
        IConfigurationElement[] configurationElements;
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = configurationElements = extensionRegistry.getConfigurationElementsFor(POINT_ID);
        int n = configurationElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            this.registerMigration(configurationElement);
            ++n2;
        }
    }

    private void registerMigration(IConfigurationElement configurationElement) {
        String contributor = configurationElement.getContributor().getName();
        String clazz = configurationElement.getAttribute(MIGRATION);
        this.classToBundleMap.put(clazz, contributor);
    }

    public String getBundleNameForClass(String clazz) {
        return this.classToBundleMap.get(clazz);
    }
}

