/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.spi.common.sort;

import java.math.BigInteger;
import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class NumberAwareStringComparator
implements Comparator<String> {
    private static final Pattern PATTERN = Pattern.compile("(\\D*)(\\d*)");
    private static NumberAwareStringComparator instance;

    public static NumberAwareStringComparator getInstance() {
        if (instance == null) {
            instance = new NumberAwareStringComparator();
        }
        return instance;
    }

    private NumberAwareStringComparator() {
    }

    @Override
    public int compare(String o1, String o2) {
        Matcher matcher1 = PATTERN.matcher(o1);
        Matcher matcher2 = PATTERN.matcher(o2);
        while (matcher1.find() && matcher2.find()) {
            int wordCompare = matcher1.group(1).compareToIgnoreCase(matcher2.group(1));
            if (wordCompare != 0) {
                return wordCompare;
            }
            String numberString1 = matcher1.group(2);
            String numberString2 = matcher2.group(2);
            if (numberString1.isEmpty()) {
                return numberString2.isEmpty() ? 0 : -1;
            }
            if (numberString2.isEmpty()) {
                return 1;
            }
            BigInteger number1 = new BigInteger(numberString1);
            BigInteger number2 = new BigInteger(numberString2);
            int numberCompare = number1.compareTo(number2);
            if (numberCompare == 0) continue;
            return numberCompare;
        }
        if (matcher1.hitEnd() && matcher2.hitEnd()) {
            return 0;
        }
        return matcher1.hitEnd() ? -1 : 1;
    }
}

