/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.spi.provider;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecp.view.spi.model.VView;
import org.eclipse.emf.ecp.view.spi.model.VViewModelProperties;
import org.eclipse.emf.ecp.view.spi.provider.EMFFormsFilteredViewService;
import org.eclipse.emf.ecp.view.spi.provider.EMFFormsViewService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public final class ViewProviderHelper {
    private static BundleContext bundleContext;

    static {
        Bundle bundle = FrameworkUtil.getBundle(ViewProviderHelper.class);
        if (bundle != null) {
            bundleContext = bundle.getBundleContext();
        }
    }

    private ViewProviderHelper() {
    }

    public static VView getView(EObject eObject, VViewModelProperties properties) {
        if (bundleContext == null) {
            return null;
        }
        ServiceReference serviceReference = bundleContext.getServiceReference(EMFFormsViewService.class);
        if (serviceReference == null) {
            return null;
        }
        EMFFormsViewService viewService = (EMFFormsViewService)bundleContext.getService(serviceReference);
        VView view = viewService.getView(eObject, properties);
        bundleContext.ungetService(serviceReference);
        return view;
    }

    public static VView getView(EObject object, VViewModelProperties properties, Collection<String> requiredKeys) {
        VView result = null;
        if (bundleContext == null) {
            return result;
        }
        ServiceReference serviceReference = bundleContext.getServiceReference(EMFFormsFilteredViewService.class);
        if (serviceReference == null) {
            return result;
        }
        EMFFormsFilteredViewService viewService = (EMFFormsFilteredViewService)bundleContext.getService(serviceReference);
        try {
            if (requiredKeys == null) {
                requiredKeys = Collections.emptySet();
            }
            result = viewService.getView(object, properties, requiredKeys);
        }
        finally {
            bundleContext.ungetService(serviceReference);
        }
        return result;
    }
}

