/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.core.services.reveal;

import java.util.Optional;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emfforms.internal.core.services.reveal.EMFFormsRevealServiceImpl;
import org.eclipse.emfforms.spi.core.services.reveal.DrillUp;
import org.eclipse.emfforms.spi.core.services.reveal.Reveal;
import org.eclipse.emfforms.spi.core.services.reveal.RevealStep;
import org.eclipse.emfforms.spi.core.services.reveal.RevealStepKind;
import org.eclipse.emfforms.spi.core.services.view.EMFFormsViewContext;

final class MasterDetailRevealStep
implements RevealStep {
    private final EMFFormsRevealServiceImpl owner;
    private final VElement element;
    private final EObject object;
    private final EStructuralFeature feature;
    private final Object masterFunction;
    private final Object masterStep;
    private RevealStep resolvedMasterStep;
    private RevealStep resolvedDetailStep;

    MasterDetailRevealStep(EMFFormsRevealServiceImpl owner, VElement element, EObject object, EStructuralFeature feature, Object masterFunction, Object masterStep) {
        this.owner = owner;
        this.element = element;
        this.object = object;
        this.feature = feature;
        this.masterFunction = masterFunction;
        this.masterStep = masterStep;
    }

    @Override
    public RevealStepKind getType() {
        return RevealStepKind.INTERMEDIATE;
    }

    @Override
    public VElement getViewModel() {
        return this.element;
    }

    @Override
    public EObject getDomainModel() {
        return this.object;
    }

    @Override
    public EStructuralFeature getFeature() {
        return null;
    }

    @Override
    public RevealStep drillDown() {
        if (this.resolvedMasterStep == null) {
            EObject master = this.computeMaster(this.object);
            if (master != null) {
                this.resolvedMasterStep = this.owner.evaluate(Reveal.class, RevealStep.class, this.element, master, null, this.masterStep).orElse(FAILED);
                this.reveal();
                if (master != this.object || this.feature != null) {
                    EMFFormsViewContext detailContext = this.owner.getDetailContext(master);
                    this.resolvedDetailStep = Optional.ofNullable(detailContext).map(ctx -> this.owner.reveal(this.object, this.feature, ctx.getViewModel())).orElse(FAILED);
                } else {
                    this.resolvedDetailStep = FAILED;
                }
            } else {
                this.resolvedMasterStep = FAILED;
                this.resolvedDetailStep = FAILED;
            }
        }
        return this.resolvedDetailStep;
    }

    private EObject computeMaster(EObject object) {
        return this.owner.evaluate(DrillUp.class, EObject.class, this.element, object, null, this.masterFunction).orElse(null);
    }

    @Override
    public void reveal() {
        this.resolvedMasterStep.ifPresent(this.owner::perform);
    }
}

