/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.spi.swt.masterdetail;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecp.ui.view.swt.ECPSWTView;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContextDisposeListener;
import org.eclipse.emf.ecp.view.spi.swt.masterdetail.DetailViewCache;

public class BasicDetailViewCache
implements DetailViewCache {
    private final Map<EClass, Record> cache;

    public BasicDetailViewCache() {
        this(5);
    }

    public BasicDetailViewCache(final int maxEntries) {
        this.cache = new LinkedHashMap<EClass, Record>(maxEntries + 1, 0.75f, true){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean removeEldestEntry(Map.Entry<EClass, Record> eldest) {
                boolean result;
                boolean bl = result = this.size() > maxEntries;
                if (result) {
                    eldest.getValue().dispose();
                }
                return result;
            }
        };
    }

    @Override
    public boolean isCached(EObject selection) {
        return selection != null && this.cache.containsKey(selection.eClass());
    }

    @Override
    public ECPSWTView getCachedView(EObject selection) {
        return this.getRecord(selection).map(Supplier::get).orElse(null);
    }

    private Optional<Record> getRecord(EObject selection) {
        return Optional.ofNullable(selection).map(EObject::eClass).map(this.cache::get);
    }

    @Override
    public boolean cacheView(ECPSWTView ecpView) {
        if (ecpView == null || ecpView.getSWTControl().isDisposed()) {
            return false;
        }
        EClass key = ecpView.getViewModelContext().getDomainModel().eClass();
        Record existing = this.cache.get(key);
        if (existing == null) {
            this.cache.put(key, new Record(key, ecpView));
        } else if (existing.get() != ecpView) {
            existing.dispose();
            this.cache.put(key, new Record(key, ecpView));
        }
        return true;
    }

    @Override
    public void clear() {
        ArrayList<Record> records = new ArrayList<Record>(this.cache.values());
        this.cache.clear();
        records.forEach(Record::dispose);
    }

    private final class Record
    implements ViewModelContextDisposeListener,
    Supplier<ECPSWTView> {
        private final EClass eClass;
        private final ECPSWTView ecpView;

        Record(EClass eClass, ECPSWTView ecpView) {
            this.eClass = eClass;
            this.ecpView = ecpView;
            ecpView.getViewModelContext().registerDisposeListener((ViewModelContextDisposeListener)this);
        }

        void dispose() {
            this.ecpView.dispose();
        }

        @Override
        public ECPSWTView get() {
            return this.ecpView;
        }

        public void contextDisposed(ViewModelContext viewModelContext) {
            this.dispose();
            BasicDetailViewCache.this.cache.remove(this.eClass, this);
        }
    }
}

