/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.views.shell.dropins.modules;

import org.eclipse.ease.IReplEngine;
import org.eclipse.ease.modules.ModuleDefinition;
import org.eclipse.ease.ui.Messages;
import org.eclipse.ease.ui.modules.ui.ModulesDragListener;
import org.eclipse.ease.ui.views.shell.dropins.AbstractDropin;
import org.eclipse.ease.ui.views.shell.dropins.modules.ModulesStackContentProvider;
import org.eclipse.ease.ui.views.shell.dropins.modules.ModulesStackLabelProvider;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPartSite;

public class ModulesStackDropin
extends AbstractDropin {
    private TableViewer fModulesTable = null;

    @Override
    public void setScriptEngine(IReplEngine engine) {
        super.setScriptEngine(engine);
        if (this.fModulesTable != null) {
            this.fModulesTable.setInput((Object)engine);
            this.update();
        }
    }

    @Override
    public Composite createComposite(IWorkbenchPartSite site, Composite parent) {
        Composite composite = new Composite(parent, 0);
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        composite.setLayout((Layout)tableColumnLayout);
        this.fModulesTable = new TableViewer(composite, 2048);
        Table table = this.fModulesTable.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.fModulesTable.setContentProvider((IContentProvider)new ModulesStackContentProvider());
        TableViewerColumn tableViewerColumn = new TableViewerColumn(this.fModulesTable, 0);
        TableColumn column = tableViewerColumn.getColumn();
        tableColumnLayout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(1));
        column.setText(Messages.ModuleStackDropin_module);
        tableViewerColumn.setLabelProvider((CellLabelProvider)new ModulesStackLabelProvider());
        this.fModulesTable.addDragSupport(3, new Transfer[]{LocalSelectionTransfer.getTransfer(), TextTransfer.getInstance()}, (DragSourceListener)new ModulesDragListener(this.fModulesTable){

            @Override
            public void dragStart(DragSourceEvent event) {
                super.dragStart(event);
                Object firstElement = this.getSelection().getFirstElement();
                event.doit = firstElement instanceof ModuleDefinition;
            }
        });
        return composite;
    }

    @Override
    public String getTitle() {
        return Messages.ModuleStackDropin_moduleStack;
    }

    @Override
    protected void updateUI() {
        this.fModulesTable.refresh();
    }
}

