/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.completions.java.provider;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import org.eclipse.ease.ICompletionContext;
import org.eclipse.ease.ui.Activator;
import org.eclipse.ease.ui.completion.AbstractCompletionProvider;
import org.eclipse.ease.ui.completion.IImageResolver;
import org.eclipse.ease.ui.completions.java.help.handlers.JavaClassHelpResolver;
import org.eclipse.ease.ui.completions.java.help.handlers.JavaFieldHelpResolver;
import org.eclipse.ease.ui.completions.java.help.handlers.JavaMethodHelpResolver;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.StyledString;

public class JavaMethodCompletionProvider
extends AbstractCompletionProvider {
    public boolean isActive(ICompletionContext context) {
        return context.getReferredClazz() != null;
    }

    protected void prepareProposals(ICompletionContext context) {
        AbstractCompletionProvider.DescriptorImageResolver imageResolver;
        StyledString styledString;
        JavaClassHelpResolver helpResolver;
        Class clazz = context.getReferredClazz();
        AccessibleObject[] accessibleObjectArray = clazz.getMethods();
        int n = accessibleObjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = accessibleObjectArray[n2];
            if ((context.getType() != ICompletionContext.Type.STATIC_CLASS || Modifier.isStatic(method.getModifiers())) && this.matchesFilterIgnoreCase(method.getName())) {
                helpResolver = new JavaMethodHelpResolver(method);
                styledString = new StyledString(String.valueOf(method.getName()) + "(" + JavaMethodCompletionProvider.getMethodSignature(method) + ") : " + JavaMethodCompletionProvider.getMethodReturnType(method));
                styledString.append(" - " + method.getDeclaringClass().getSimpleName(), StyledString.QUALIFIER_STYLER);
                Object object = imageResolver = Modifier.isStatic(method.getModifiers()) ? new AbstractCompletionProvider.DescriptorImageResolver(Activator.getImageDescriptor((String)"org.eclipse.ease.ui", (String)"/icons/eobj16/static_function.png")) : new JDTImageResolver("org.eclipse.jdt.ui.methpub_obj.gif");
                if (method.getParameterTypes().length > 0) {
                    this.addProposal(styledString, String.valueOf(method.getName()) + "(", (IImageResolver)imageResolver, 40, helpResolver);
                } else {
                    this.addProposal(styledString, String.valueOf(method.getName()) + "()", (IImageResolver)imageResolver, 40, helpResolver);
                }
            }
            ++n2;
        }
        accessibleObjectArray = clazz.getFields();
        n = accessibleObjectArray.length;
        n2 = 0;
        while (n2 < n) {
            AccessibleObject field = accessibleObjectArray[n2];
            if ((context.getType() != ICompletionContext.Type.STATIC_CLASS || Modifier.isStatic(((Field)field).getModifiers())) && this.matchesFilterIgnoreCase(((Field)field).getName())) {
                helpResolver = new JavaFieldHelpResolver((Field)field);
                styledString = new StyledString(String.valueOf(((Field)field).getName()) + " : " + ((Field)field).getType().getSimpleName());
                styledString.append(" - " + ((Field)field).getDeclaringClass().getSimpleName(), StyledString.QUALIFIER_STYLER);
                imageResolver = Modifier.isStatic(((Field)field).getModifiers()) ? new AbstractCompletionProvider.DescriptorImageResolver(Activator.getImageDescriptor((String)"org.eclipse.ease.ui", (String)"/icons/eobj16/static_field.png")) : new JDTImageResolver("org.eclipse.jdt.ui.field_public_obj.gif");
                this.addProposal(styledString, ((Field)field).getName(), (IImageResolver)imageResolver, 20, helpResolver);
            }
            ++n2;
        }
    }

    public static String getMethodReturnType(Method method) {
        Class<?> returnType = method.getReturnType();
        return returnType != null ? returnType.getSimpleName() : "void";
    }

    public static String getMethodSignature(Method method) {
        StringBuilder result = new StringBuilder();
        Parameter[] parameterArray = method.getParameters();
        int n = parameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            Parameter parameter = parameterArray[n2];
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append(parameter.getType().getSimpleName());
            result.append(' ').append(parameter.getName());
            ++n2;
        }
        return result.toString();
    }

    public static class JDTImageResolver
    extends AbstractCompletionProvider.DescriptorImageResolver {
        private final String fImageIdentifier;

        public JDTImageResolver(String imageIdentifier) {
            this.fImageIdentifier = imageIdentifier;
        }

        protected ImageDescriptor getDescriptor() {
            return JDTImageResolver.getDescriptor(this.fImageIdentifier);
        }

        public static ImageDescriptor getDescriptor(String imageIdentifier) {
            return JavaUI.getSharedImages().getImageDescriptor(imageIdentifier);
        }
    }
}

