/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease;

public class ScriptResult {
    public static final Object VOID = new Object(){

        public final String toString() {
            return "<void>";
        }
    };
    private Object fResult = null;
    private Throwable fException = null;
    private boolean fIsDone = false;

    public ScriptResult() {
    }

    public ScriptResult(Object result) {
        this.setResult(result);
    }

    public final synchronized boolean isReady() {
        return this.fIsDone;
    }

    public final synchronized void waitForResult() {
        while (!this.isReady()) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public final synchronized void waitForResult(long timeout) {
        long stopTimestamp = System.currentTimeMillis() + timeout;
        while (!this.isReady() && System.currentTimeMillis() < stopTimestamp) {
            try {
                this.wait(Math.max(0L, System.currentTimeMillis() - stopTimestamp));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public final synchronized Object getResult() {
        return this.fResult;
    }

    public final synchronized void setResult(Object result) {
        this.fResult = result;
        this.fIsDone = true;
        this.notifyAll();
    }

    public final synchronized void setException(Throwable e) {
        this.fException = e;
        this.fIsDone = true;
        this.notifyAll();
    }

    public final synchronized Throwable getException() {
        return this.fException;
    }

    public final String toString() {
        if (this.fException != null) {
            return "Exception: " + this.fException.getLocalizedMessage();
        }
        return this.fResult != null ? this.fResult.toString() : "[null]";
    }

    public final boolean hasException() {
        return this.fException != null;
    }
}

