/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.lang.scriptarchive.ui.export;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.eclipse.osgi.util.ManifestElement;

public class ManifestOutputStream
extends OutputStream {
    public static final String MANIFEST_VERSION = "Manifest-Version";
    public static final String MANIFEST_LIST_SEPARATOR = ",\n ";
    public static final String MANIFEST_LINE_SEPARATOR = "\n ";
    private static int MANIFEST_MAXLINE = 511;
    private final OutputStream fBaseStream;

    public ManifestOutputStream(OutputStream baseStream) {
        this.fBaseStream = baseStream;
    }

    public void writeManifest(Set<Map.Entry<Object, Object>> entries) throws IOException {
        Hashtable<String, String> manifestToWrite = new Hashtable<String, String>();
        for (Map.Entry<Object, Object> entry : entries) {
            manifestToWrite.put(entry.getKey().toString(), entry.getValue().toString());
        }
        if (!manifestToWrite.containsKey(MANIFEST_VERSION)) {
            manifestToWrite.put(MANIFEST_VERSION, "1.0");
        }
        this.writeEntry(MANIFEST_VERSION, (String)manifestToWrite.remove(MANIFEST_VERSION));
        for (String key : manifestToWrite.keySet()) {
            this.writeEntry(key, (String)manifestToWrite.get(key));
        }
        this.flush();
    }

    private void writeEntry(String key, String value) throws IOException {
        if (value != null && value.length() > 0) {
            this.write(ManifestOutputStream.splitOnComma(String.valueOf(key) + ": " + value).getBytes());
            this.write(10);
        }
    }

    private static String splitOnComma(String value) {
        if (value.length() < MANIFEST_MAXLINE || value.indexOf(MANIFEST_LINE_SEPARATOR) >= 0) {
            return value;
        }
        String[] values = ManifestElement.getArrayFromList((String)value);
        if (values == null || values.length == 0) {
            return value;
        }
        StringBuffer sb = new StringBuffer(value.length() + (values.length - 1) * MANIFEST_LIST_SEPARATOR.length());
        int i = 0;
        while (i < values.length - 1) {
            sb.append(values[i]).append(MANIFEST_LIST_SEPARATOR);
            ++i;
        }
        sb.append(values[values.length - 1]);
        return sb.toString();
    }

    @Override
    public void write(int b) throws IOException {
        this.fBaseStream.write(b);
    }

    @Override
    public void flush() throws IOException {
        super.flush();
        this.fBaseStream.flush();
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.fBaseStream.close();
    }
}

