/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.lang.python.debugger;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.ease.ExitException;
import org.eclipse.ease.IDebugEngine;
import org.eclipse.ease.IExecutionListener;
import org.eclipse.ease.Script;
import org.eclipse.ease.debugging.AbstractEaseDebugger;
import org.eclipse.ease.debugging.EaseDebugFrame;
import org.eclipse.ease.debugging.IScriptDebugFrame;
import org.eclipse.ease.debugging.ScriptStackTrace;
import org.eclipse.ease.debugging.dispatcher.IEventProcessor;
import org.eclipse.ease.debugging.events.IDebugEvent;
import org.eclipse.ease.debugging.events.model.TerminateRequest;
import org.eclipse.ease.lang.python.debugger.ICodeTracer;
import org.eclipse.ease.lang.python.debugger.IPyFrame;

public class PythonDebugger
extends AbstractEaseDebugger
implements IEventProcessor,
IExecutionListener {
    public static final String PYTHON_DEBUGGER_VARIABLE = "_pyease_debugger";
    private ICodeTracer fCodeTracer;
    private final Map<String, Script> fScriptRegistry = new HashMap<String, Script>();

    public PythonDebugger(IDebugEngine engine, boolean showDynamicCode) {
        super(engine, showDynamicCode);
    }

    public void setCodeTracer(ICodeTracer tracer) {
        this.fCodeTracer = tracer;
    }

    public void handleEvent(IDebugEvent event) {
        if (event instanceof TerminateRequest) {
            this.resume(8);
        } else {
            super.handleEvent(event);
        }
    }

    private static boolean isUserCode(IPyFrame frame) {
        return frame.getFilename().startsWith("__ref_");
    }

    private ScriptStackTrace getStacktrace(IPyFrame origin) {
        ScriptStackTrace trace = new ScriptStackTrace();
        IPyFrame frame = origin;
        while (frame != null) {
            if (PythonDebugger.isUserCode(frame) && this.isTrackedScript(this.fScriptRegistry.get(frame.getFilename()))) {
                trace.add((Object)new PythonDebugFrame(frame));
            }
            frame = frame.getParent();
        }
        return trace;
    }

    public void traceDispatch(IPyFrame frame, String type) {
        Script script;
        if (this.getResumeType() == 8) {
            throw new ExitException((Object)"Debug aborted by user");
        }
        if (PythonDebugger.isUserCode(frame) && this.isTrackedScript(script = this.fScriptRegistry.get(frame.getFilename()))) {
            this.setStacktrace(this.getStacktrace(frame));
            if (frame.getLineNumber() != 0) {
                this.processLine(script, frame.getLineNumber());
            }
        }
    }

    public Object execute(Script script) {
        try {
            this.fCodeTracer.run(script, this.registerScript(script));
        }
        catch (Exception e) {
            if (this.getResumeType() == 8) {
                throw new ExitException((Object)"Debug aborted by user");
            }
            throw e;
        }
        return null;
    }

    private String registerScript(Script script) {
        String reference = PythonDebugger.getHash(script, this.fScriptRegistry.keySet());
        this.fScriptRegistry.put(reference, script);
        return reference;
    }

    private static String getHash(Script script, Set<String> existingKeys) {
        StringBuilder buffer = new StringBuilder("__ref_");
        buffer.append(script.isDynamic() ? "dyn" : script.getCommand().toString());
        buffer.append("_");
        int index = 0;
        while (index < 10) {
            buffer.append((char)(97 + new Random().nextInt(26)));
            ++index;
        }
        if (existingKeys.contains(buffer.toString())) {
            return PythonDebugger.getHash(script, existingKeys);
        }
        return buffer.toString();
    }

    public class PythonDebugFrame
    extends EaseDebugFrame
    implements IScriptDebugFrame {
        public PythonDebugFrame(IPyFrame frame) {
            super((Script)PythonDebugger.this.fScriptRegistry.get(frame.getFilename()), frame.getLineNumber(), 1);
        }

        public String getName() {
            Script script = this.getScript();
            if (script.isDynamic()) {
                String title = this.getScript().getTitle();
                return title != null ? "Dynamic: " + title : "(Dynamic)";
            }
            Object command = this.getScript().getCommand();
            if (command != null) {
                if (command instanceof IFile) {
                    return ((IFile)command).getName();
                }
                if (command instanceof File) {
                    return ((File)command).getName();
                }
                return command.toString();
            }
            return "(unknown source)";
        }
    }
}

