/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.debugging.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.ease.Script;
import org.eclipse.ease.debugging.DebugTracer;
import org.eclipse.ease.debugging.IScriptDebugFrame;
import org.eclipse.ease.debugging.dispatcher.EventDispatchJob;
import org.eclipse.ease.debugging.dispatcher.IEventProcessor;
import org.eclipse.ease.debugging.events.IDebugEvent;
import org.eclipse.ease.debugging.events.debugger.EngineStartedEvent;
import org.eclipse.ease.debugging.events.debugger.EngineTerminatedEvent;
import org.eclipse.ease.debugging.events.debugger.EvaluateExpressionEvent;
import org.eclipse.ease.debugging.events.debugger.ResumedEvent;
import org.eclipse.ease.debugging.events.debugger.ScriptReadyEvent;
import org.eclipse.ease.debugging.events.debugger.StackFramesEvent;
import org.eclipse.ease.debugging.events.debugger.SuspendedEvent;
import org.eclipse.ease.debugging.events.debugger.VariablesEvent;
import org.eclipse.ease.debugging.events.model.BreakpointRequest;
import org.eclipse.ease.debugging.events.model.IModelRequest;
import org.eclipse.ease.debugging.events.model.ResumeRequest;
import org.eclipse.ease.debugging.events.model.SuspendRequest;
import org.eclipse.ease.debugging.events.model.TerminateRequest;
import org.eclipse.ease.debugging.model.EaseDebugElement;
import org.eclipse.ease.debugging.model.EaseDebugProcess;
import org.eclipse.ease.debugging.model.EaseDebugStackFrame;
import org.eclipse.ease.debugging.model.EaseDebugThread;

public abstract class EaseDebugTarget
extends EaseDebugElement
implements IDebugTarget,
IEventProcessor {
    private EventDispatchJob fDispatcher;
    private EaseDebugProcess fProcess = null;
    private final List<EaseDebugThread> fThreads = new ArrayList<EaseDebugThread>();
    private final ILaunch fLaunch;
    private State fState = State.NOT_STARTED;
    private final boolean fSuspendOnStartup;
    private final boolean fSuspendOnScriptLoad;
    private final boolean fShowDynamicCode;
    private final List<Integer> fUniqueVariableIds = new ArrayList<Integer>();

    public EaseDebugTarget(ILaunch launch, boolean suspendOnStartup, boolean suspendOnScriptLoad, boolean showDynamicCode) {
        super(null);
        this.fLaunch = launch;
        this.fSuspendOnStartup = suspendOnStartup;
        this.fSuspendOnScriptLoad = suspendOnScriptLoad;
        this.fShowDynamicCode = showDynamicCode;
        DebugPlugin.getDefault().getBreakpointManager().addBreakpointListener((IBreakpointListener)this);
        this.fireCreationEvent();
    }

    public String getName() {
        return "EASE Debugger";
    }

    @Override
    public EaseDebugTarget getDebugTarget() {
        return this;
    }

    public ILaunch getLaunch() {
        return this.fLaunch;
    }

    public IProcess getProcess() {
        return this.fProcess;
    }

    public EaseDebugThread[] getThreads() {
        return this.fThreads.toArray(new EaseDebugThread[this.fThreads.size()]);
    }

    public boolean hasThreads() {
        return !this.fThreads.isEmpty();
    }

    public void fireDispatchEvent(IModelRequest event) {
        if (this.fDispatcher != null) {
            this.fDispatcher.addEvent(event);
        }
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public void setDispatcher(EventDispatchJob dispatcher) {
        this.fDispatcher = dispatcher;
    }

    @Override
    public synchronized void handleEvent(IDebugEvent event) {
        if (this.fDispatcher != null) {
            DebugTracer.debug("Model", "process " + event);
            if (event instanceof EngineStartedEvent) {
                this.fProcess = new EaseDebugProcess(this);
                this.fProcess.fireCreationEvent();
            } else if (event instanceof ScriptReadyEvent) {
                EaseDebugThread debugThread = this.findDebugThread(((ScriptReadyEvent)event).getThread());
                if (debugThread == null) {
                    debugThread = new EaseDebugThread(this.getDebugTarget(), ((ScriptReadyEvent)event).getThread());
                    this.fThreads.add(debugThread);
                    debugThread.fireCreationEvent();
                } else {
                    debugThread.fireChangeEvent(512);
                }
                this.setDeferredBreakpoints(((ScriptReadyEvent)event).getScript());
                this.fState = State.SUSPENDED;
                debugThread.fireSuspendEvent(32);
                int stepType = 0;
                if (this.fSuspendOnScriptLoad) {
                    stepType = 1;
                } else if (((ScriptReadyEvent)event).isRoot() && this.fSuspendOnStartup) {
                    stepType = 1;
                }
                this.fireDispatchEvent(new ResumeRequest(stepType, debugThread.getThread()));
            } else if (event instanceof SuspendedEvent) {
                EaseDebugThread debugThread = this.findDebugThread(((SuspendedEvent)event).getThread());
                debugThread.setStackFrames(this.filterFrames(((SuspendedEvent)event).getDebugFrames()));
                this.fState = State.SUSPENDED;
                debugThread.fireSuspendEvent(((SuspendedEvent)event).getType());
            } else if (event instanceof StackFramesEvent) {
                EaseDebugThread debugThread = this.findDebugThread(((StackFramesEvent)event).getThread());
                debugThread.setStackFrames(this.filterFrames(((StackFramesEvent)event).getDebugFrames()));
                debugThread.fireChangeEvent(512);
            } else if (event instanceof VariablesEvent) {
                EaseDebugStackFrame requestor = ((VariablesEvent)event).getRequestor();
                requestor.setVariables(((VariablesEvent)event).getVariables());
            } else if (event instanceof EvaluateExpressionEvent) {
                if (this.getThreads().length > 0) {
                    ((EvaluateExpressionEvent)event).getListener().watchEvaluationFinished(((EvaluateExpressionEvent)event).getWatchExpressionResult(this));
                }
            } else if (event instanceof ResumedEvent) {
                this.fState = State.RESUMED;
                EaseDebugThread debugThread = this.findDebugThread(((ResumedEvent)event).getThread());
                debugThread.fireResumeEvent(((ResumedEvent)event).getType());
            } else if (event instanceof EngineTerminatedEvent) {
                this.cleanupOnTermination();
            }
        }
    }

    private void cleanupOnTermination() {
        this.fDispatcher = null;
        DebugPlugin debugPlugin = DebugPlugin.getDefault();
        if (debugPlugin != null) {
            debugPlugin.getBreakpointManager().removeBreakpointListener((IBreakpointListener)this);
        }
        this.fState = State.TERMINATED;
        this.getThreads()[0].setStackFrames(Collections.emptyList());
        this.fireTerminateEvent();
    }

    private List<IScriptDebugFrame> filterFrames(List<IScriptDebugFrame> frames) {
        if (this.fShowDynamicCode) {
            return frames;
        }
        return frames.stream().filter(frame -> frame.getScript() != null && !frame.getScript().isDynamic()).collect(Collectors.toList());
    }

    private EaseDebugThread findDebugThread(Thread thread) {
        EaseDebugThread[] easeDebugThreadArray = this.getThreads();
        int n = easeDebugThreadArray.length;
        int n2 = 0;
        while (n2 < n) {
            EaseDebugThread debugThread = easeDebugThreadArray[n2];
            if (thread.equals(debugThread.getThread())) {
                return debugThread;
            }
            ++n2;
        }
        return null;
    }

    public int getUniqueVariableId(Object value) {
        int hashCode = System.identityHashCode(value);
        int index = this.fUniqueVariableIds.indexOf(hashCode);
        if (index == -1) {
            this.fUniqueVariableIds.add(hashCode);
            index = this.fUniqueVariableIds.indexOf(hashCode);
        }
        return index;
    }

    private void setDeferredBreakpoints(Script script) {
        Object file = script.getFile();
        if (file instanceof IResource) {
            IBreakpoint[] breakpoints;
            IBreakpoint[] iBreakpointArray = breakpoints = this.getBreakpoints(script);
            int n = breakpoints.length;
            int n2 = 0;
            while (n2 < n) {
                IBreakpoint breakpoint = iBreakpointArray[n2];
                if (file.equals(breakpoint.getMarker().getResource())) {
                    this.fireDispatchEvent(new BreakpointRequest(script, breakpoint, BreakpointRequest.Mode.ADD));
                }
                ++n2;
            }
        }
    }

    protected abstract IBreakpoint[] getBreakpoints(Script var1);

    public void breakpointAdded(IBreakpoint breakpoint) {
        this.handleBreakpointChange(breakpoint, BreakpointRequest.Mode.ADD);
    }

    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
        this.handleBreakpointChange(breakpoint, BreakpointRequest.Mode.REMOVE);
    }

    public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
        this.breakpointRemoved(breakpoint, delta);
        this.breakpointAdded(breakpoint);
    }

    private synchronized void handleBreakpointChange(IBreakpoint breakpoint, BreakpointRequest.Mode mode) {
        IResource affectedResource = breakpoint.getMarker().getResource();
        EaseDebugThread[] easeDebugThreadArray = this.getThreads();
        int n = easeDebugThreadArray.length;
        int n2 = 0;
        while (n2 < n) {
            EaseDebugThread thread = easeDebugThreadArray[n2];
            IStackFrame[] iStackFrameArray = thread.getStackFrames();
            int n3 = iStackFrameArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Script script;
                IStackFrame frame = iStackFrameArray[n4];
                if (frame instanceof EaseDebugStackFrame && affectedResource.equals((script = ((EaseDebugStackFrame)frame).getScript()).getFile())) {
                    this.fireDispatchEvent(new BreakpointRequest(script, breakpoint, mode));
                }
                ++n4;
            }
            ++n2;
        }
    }

    public boolean supportsStorageRetrieval() {
        return false;
    }

    public IMemoryBlock getMemoryBlock(long startAddress, long length) throws DebugException {
        throw new DebugException((IStatus)new Status(4, "Activator.PLUGIN_ID", "getMemoryBlock() not supported by " + this.getName()));
    }

    @Override
    public boolean canTerminate() {
        return !this.isTerminated();
    }

    @Override
    public synchronized void terminate() {
        this.fireDispatchEvent(new TerminateRequest());
    }

    @Override
    public boolean isTerminated() {
        return State.TERMINATED == this.fState;
    }

    @Override
    public boolean canResume() {
        return this.isSuspended();
    }

    @Override
    public boolean canSuspend() {
        return !this.isSuspended();
    }

    @Override
    public synchronized void resume() {
        EaseDebugThread[] threads = this.getThreads();
        if (threads.length == 1) {
            this.fireDispatchEvent(new ResumeRequest(32, threads[0].getThread()));
        }
    }

    @Override
    public synchronized void suspend() {
        this.fireDispatchEvent(new SuspendRequest());
    }

    @Override
    public boolean isSuspended() {
        return State.SUSPENDED == this.fState;
    }

    @Override
    public boolean canDisconnect() {
        return this.canTerminate();
    }

    @Override
    public synchronized void disconnect() {
        this.fireDispatchEvent(new BreakpointRequest(BreakpointRequest.Mode.REMOVE));
        this.fireDispatchEvent(new ResumeRequest(32, null));
        this.cleanupOnTermination();
    }

    @Override
    public boolean isDisconnected() {
        return this.isTerminated();
    }

    @Override
    public boolean canStepInto() {
        return this.isSuspended();
    }

    @Override
    public boolean canStepOver() {
        return this.isSuspended();
    }

    @Override
    public boolean canStepReturn() {
        return this.isSuspended();
    }

    @Override
    public synchronized void stepInto() {
        EaseDebugThread[] threads = this.getDebugTarget().getThreads();
        if (threads.length == 1) {
            this.fireDispatchEvent(new ResumeRequest(1, threads[0].getThread()));
        }
    }

    @Override
    public synchronized void stepOver() {
        EaseDebugThread[] threads = this.getDebugTarget().getThreads();
        if (threads.length == 1) {
            this.fireDispatchEvent(new ResumeRequest(2, threads[0].getThread()));
        }
    }

    @Override
    public synchronized void stepReturn() {
        EaseDebugThread[] threads = this.getDebugTarget().getThreads();
        if (threads.length == 1) {
            this.fireDispatchEvent(new ResumeRequest(4, threads[0].getThread()));
        }
    }

    @Override
    public boolean isStepping() {
        return State.STEPPING == this.fState;
    }

    private static enum State {
        NOT_STARTED,
        SUSPENDED,
        RESUMED,
        STEPPING,
        TERMINATED,
        DISCONNECTED;

    }
}

