/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.help.hovers.internal;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import org.eclipse.ease.Logger;
import org.eclipse.ease.tools.StringTools;
import org.eclipse.ease.ui.help.hovers.IHoverContentProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.internal.text.html.BrowserInformationControl;
import org.eclipse.jface.internal.text.html.BrowserInformationControlInput;
import org.eclipse.jface.internal.text.html.HTMLPrinter;
import org.eclipse.jface.internal.text.html.HTMLTextPresenter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.AbstractReusableInformationControlCreator;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IInformationControlExtension4;
import org.eclipse.jface.text.IInputChangedListener;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;

public class JavaDocLikeHover {
    public static final String APPEARANCE_MODULEDOC_FONT = "org.eclipse.ease.ui.moduledocfont";
    public static final String CONSTANT_VALUE_SEPARATOR = " : ";
    private static String fgStyleSheet;
    private IInformationControlCreator fHoverControlCreator;
    private IInformationControlCreator fPresenterControlCreator;
    private final IHoverContentProvider fHoverContent;

    public JavaDocLikeHover(IHoverContentProvider hoverContent) {
        this.fHoverContent = hoverContent;
    }

    public IInformationControlCreator getInformationPresenterControlCreator() {
        if (this.fPresenterControlCreator == null) {
            this.fPresenterControlCreator = new PresenterControlCreator();
        }
        return this.fPresenterControlCreator;
    }

    public IInformationControlCreator getHoverControlCreator() {
        if (this.fHoverControlCreator == null) {
            this.fHoverControlCreator = new HoverControlCreator(this.getInformationPresenterControlCreator());
        }
        return this.fHoverControlCreator;
    }

    public static BrowserInformationControlInput getHoverInfo(String content, BrowserInformationControlInput previousInput) {
        final StringBuffer buffer = new StringBuffer(content);
        if (buffer.length() > 0) {
            HTMLPrinter.insertPageProlog((StringBuffer)buffer, (int)0, (String)JavaDocLikeHover.getStyleSheet());
            HTMLPrinter.addPageEpilog((StringBuffer)buffer);
            return new BrowserInformationControlInput(previousInput){

                public String getHtml() {
                    return buffer.toString();
                }

                public Object getInputElement() {
                    return this.getHtml();
                }

                public String getInputName() {
                    return "";
                }
            };
        }
        return null;
    }

    private static String getStyleSheet() {
        String css;
        if (fgStyleSheet == null) {
            try {
                URL url = new URL("platform:/plugin/org.eclipse.ease.ui/resources/EASEHoverStylesheet.css");
                InputStream inputStream = url.openConnection().getInputStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
                fgStyleSheet = StringTools.toString((Reader)reader);
                reader.close();
            }
            catch (IOException e) {
                Logger.error((String)"org.eclipse.ease.ui", (String)"Cannot read style sheet for hover presentation", (Throwable)e);
            }
        }
        if ((css = fgStyleSheet) != null) {
            FontData fontData = JFaceResources.getFontRegistry().getFontData(APPEARANCE_MODULEDOC_FONT)[0];
            css = HTMLPrinter.convertTopLevelFont((String)css, (FontData)fontData);
        }
        return css;
    }

    private static final class BackAction
    extends Action {
        private final BrowserInformationControl fInfoControl;

        public BackAction(BrowserInformationControl infoControl) {
            this.fInfoControl = infoControl;
            this.setText("Back");
            ISharedImages images = PlatformUI.getWorkbench().getSharedImages();
            this.setImageDescriptor(images.getImageDescriptor("IMG_TOOL_BACK"));
            this.setDisabledImageDescriptor(images.getImageDescriptor("IMG_TOOL_BACK_DISABLED"));
            this.update();
        }

        public void run() {
            BrowserInformationControlInput previous = (BrowserInformationControlInput)this.fInfoControl.getInput().getPrevious();
            if (previous != null) {
                this.fInfoControl.setInput((Object)previous);
            }
        }

        public void update() {
            BrowserInformationControlInput current = this.fInfoControl.getInput();
            if (current != null && current.getPrevious() != null) {
                this.setToolTipText("back to previous");
                this.setEnabled(true);
            } else {
                this.setToolTipText("JavaHoverMessages.JavadocHover_back");
                this.setEnabled(false);
            }
        }
    }

    public static class FallbackInformationPresenter
    extends HTMLTextPresenter {
        public FallbackInformationPresenter() {
            super(false);
        }

        public String updatePresentation(Drawable drawable, String hoverInfo, TextPresentation presentation, int maxWidth, int maxHeight) {
            String warningInfo = "NOTE: The SWT Browser widget could not be created. This fallback mode doesn't show links and misses other functionality.";
            String warning = super.updatePresentation(drawable, "NOTE: The SWT Browser widget could not be created. This fallback mode doesn't show links and misses other functionality.", presentation, maxWidth, maxHeight);
            presentation.clear();
            String content = super.updatePresentation(drawable, hoverInfo, presentation, maxWidth, maxHeight);
            return String.valueOf(content) + "\n\n" + warning;
        }
    }

    private static final class ForwardAction
    extends Action {
        private final BrowserInformationControl fInfoControl;

        public ForwardAction(BrowserInformationControl infoControl) {
            this.fInfoControl = infoControl;
            this.setText("Forward");
            ISharedImages images = PlatformUI.getWorkbench().getSharedImages();
            this.setImageDescriptor(images.getImageDescriptor("IMG_TOOL_FORWARD"));
            this.setDisabledImageDescriptor(images.getImageDescriptor("IMG_TOOL_FORWARD_DISABLED"));
            this.update();
        }

        public void run() {
            BrowserInformationControlInput next = (BrowserInformationControlInput)this.fInfoControl.getInput().getNext();
            if (next != null) {
                this.fInfoControl.setInput((Object)next);
            }
        }

        public void update() {
            BrowserInformationControlInput current = this.fInfoControl.getInput();
            if (current != null && current.getNext() != null) {
                this.setToolTipText("forward");
                this.setEnabled(true);
            } else {
                this.setToolTipText("JavaHoverMessages.JavadocHover_forward_toolTip");
                this.setEnabled(false);
            }
        }
    }

    public static final class HoverControlCreator
    extends AbstractReusableInformationControlCreator {
        private final IInformationControlCreator fInformationPresenterControlCreator;

        public HoverControlCreator(IInformationControlCreator informationPresenterControlCreator) {
            this.fInformationPresenterControlCreator = informationPresenterControlCreator;
        }

        public IInformationControl doCreateInformationControl(Shell parent) {
            String tooltipAffordanceString = "Press 'F2' for focus";
            if (BrowserInformationControl.isAvailable((Composite)parent)) {
                String font = JavaDocLikeHover.APPEARANCE_MODULEDOC_FONT;
                return new BrowserInformationControl(parent, JavaDocLikeHover.APPEARANCE_MODULEDOC_FONT, "Press 'F2' for focus"){

                    public IInformationControlCreator getInformationPresenterControlCreator() {
                        return fInformationPresenterControlCreator;
                    }
                };
            }
            return new DefaultInformationControl(parent, "Press 'F2' for focus"){

                public IInformationControlCreator getInformationPresenterControlCreator() {
                    return parentShell -> new DefaultInformationControl(parentShell, null, (DefaultInformationControl.IInformationPresenter)new FallbackInformationPresenter());
                }
            };
        }

        public boolean canReuse(IInformationControl control) {
            if (!super.canReuse(control)) {
                return false;
            }
            if (control instanceof IInformationControlExtension4) {
                String tooltipAffordanceString = "Press 'F2' for focus";
                ((IInformationControlExtension4)control).setStatusText("Press 'F2' for focus");
            }
            return true;
        }
    }

    public final class PresenterControlCreator
    extends AbstractReusableInformationControlCreator {
        public IInformationControl doCreateInformationControl(Shell parent) {
            if (BrowserInformationControl.isAvailable((Composite)parent)) {
                ToolBarManager tbm = new ToolBarManager(0x800000);
                String font = JavaDocLikeHover.APPEARANCE_MODULEDOC_FONT;
                BrowserInformationControl iControl = new BrowserInformationControl(parent, JavaDocLikeHover.APPEARANCE_MODULEDOC_FONT, tbm);
                JavaDocLikeHover.this.fHoverContent.populateToolbar(iControl, tbm);
                BackAction backAction = new BackAction(iControl);
                backAction.setEnabled(false);
                tbm.add((IAction)backAction);
                ForwardAction forwardAction = new ForwardAction(iControl);
                tbm.add((IAction)forwardAction);
                forwardAction.setEnabled(false);
                IInputChangedListener inputChangeListener = newInput -> {
                    backAction.update();
                    forwardAction.update();
                };
                iControl.addInputChangeListener(inputChangeListener);
                tbm.update(true);
                return iControl;
            }
            return new DefaultInformationControl(parent, true);
        }
    }
}

