/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.lang.unittest.execution;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.ease.IScriptEngine;
import org.eclipse.ease.lang.unittest.TestSuiteScriptEngine;
import org.eclipse.ease.lang.unittest.definition.Flag;
import org.eclipse.ease.lang.unittest.definition.ITestSuiteDefinition;
import org.eclipse.ease.lang.unittest.execution.ITestExecutionStrategy;
import org.eclipse.ease.lang.unittest.runtime.ITestContainer;
import org.eclipse.ease.lang.unittest.runtime.ITestEntity;
import org.eclipse.ease.lang.unittest.runtime.ITestSuite;

public class DefaultTestExecutionStrategy
implements ITestExecutionStrategy {
    private TestSuiteScriptEngine fEngine;
    private Collection<ITestEntity> fActiveEntities;
    private boolean fStopSuiteOnError = false;

    private static Collection<ITestEntity> getEntries(ITestEntity root) {
        HashSet<ITestEntity> entries = new HashSet<ITestEntity>();
        entries.add(root);
        if (root instanceof ITestContainer) {
            for (ITestEntity child : ((ITestContainer)root).getChildren()) {
                entries.addAll(DefaultTestExecutionStrategy.getEntries(child));
            }
        }
        return entries;
    }

    @Override
    public void prepareExecution(TestSuiteScriptEngine engine, ITestEntity root) {
        this.prepareExecution(engine, root, DefaultTestExecutionStrategy.getEntries(root));
    }

    @Override
    public void prepareExecution(TestSuiteScriptEngine engine, ITestEntity root, Collection<ITestEntity> activeEntities) {
        this.fEngine = engine;
        this.fActiveEntities = activeEntities;
        for (ITestEntity entry : activeEntities) {
            entry.reset();
        }
        ITestSuite testSuite = root.getTestSuite();
        if (testSuite != null) {
            testSuite.setMasterEngine((IScriptEngine)engine);
            ITestSuiteDefinition definition = testSuite.getDefinition();
            if (definition != null) {
                this.fStopSuiteOnError = definition.getFlag(Flag.STOP_SUITE_ON_ERROR, false);
            }
        }
    }

    @Override
    public void execute(ITestEntity testEntity) {
        if (!(testEntity.getRoot().hasError() && this.fStopSuiteOnError || !this.fActiveEntities.contains(testEntity))) {
            testEntity.run(this);
        }
    }

    @Override
    public IScriptEngine createScriptEngine(ITestSuite testSuite, Object resource) {
        return this.fEngine.createScriptEngine(testSuite, resource);
    }
}

