/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.lang.unittest.ui.views;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ease.Logger;
import org.eclipse.ease.debugging.IScriptDebugFrame;
import org.eclipse.ease.debugging.ScriptStackTrace;
import org.eclipse.ease.lang.unittest.TestSuiteScriptEngine;
import org.eclipse.ease.lang.unittest.runtime.IMetadata;
import org.eclipse.ease.lang.unittest.runtime.IRuntimePackage;
import org.eclipse.ease.lang.unittest.runtime.ITest;
import org.eclipse.ease.lang.unittest.runtime.ITestClass;
import org.eclipse.ease.lang.unittest.runtime.ITestContainer;
import org.eclipse.ease.lang.unittest.runtime.ITestEntity;
import org.eclipse.ease.lang.unittest.runtime.ITestFile;
import org.eclipse.ease.lang.unittest.runtime.ITestResult;
import org.eclipse.ease.lang.unittest.runtime.ITestSuite;
import org.eclipse.ease.lang.unittest.runtime.TestStatus;
import org.eclipse.ease.lang.unittest.ui.Activator;
import org.eclipse.ease.lang.unittest.ui.sourceprovider.TestSuiteSource;
import org.eclipse.ease.lang.unittest.ui.views.MultiSelectionProvider;
import org.eclipse.ease.lang.unittest.ui.views.SuiteRuntimeInformation;
import org.eclipse.ease.lang.unittest.ui.views.TestSuiteContentProvider;
import org.eclipse.ease.lang.unittest.ui.views.TestSuiteLabelProvider;
import org.eclipse.ease.ui.tools.DecoratedLabelProvider;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.CollapseAllHandler;
import org.eclipse.ui.handlers.ExpandAllHandler;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.texteditor.ITextEditor;

public class UnitTestView
extends ViewPart {
    public static final String VIEW_ID = "org.eclipse.ease.views.unittest";
    public static final String TEST_STATUS_PROPERTY = "test status";
    private ProgressBar fProgressBar;
    private TreeViewer fFileTreeViewer;
    private TreeViewer fTestTreeViewer;
    private SashForm sashForm;
    private int[] fSashWeights = new int[]{70, 30};
    private CollapseAllHandler fCollapseAllHandler;
    private ExpandAllHandler fExpandAllHandler;
    private LocalResourceManager fResourceManager;
    private Label lblErrorCount;
    private Label lblFailureCount;
    private SuiteRuntimeInformation fRuntimeInformation = null;
    private TestSuiteScriptEngine fCurrentEngine;
    private int fErrorCount = 0;
    private int fFailureCount = 0;
    private int fFinishedFileCount = 0;
    private final ContentAdapter fContentAdapter = new ContentAdapter();
    private final UIUpdateJob fUIJob = new UIUpdateJob();
    private Label fLblDuration;

    private static void openEditor(Object resource, int lineNumber) {
        if (resource instanceof IFile) {
            IEditorDescriptor descriptor = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(((IFile)resource).getName());
            if (descriptor == null) {
                descriptor = PlatformUI.getWorkbench().getEditorRegistry().findEditor("org.eclipse.ui.DefaultTextEditor");
            }
            if (descriptor != null) {
                IEditorDescriptor editorDescriptor = descriptor;
                try {
                    IEditorPart editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)new FileEditorInput((IFile)resource), editorDescriptor.getId());
                    if (lineNumber > 0 && editor instanceof ITextEditor) {
                        IDocument document = ((ITextEditor)editor).getDocumentProvider().getDocument((Object)editor.getEditorInput());
                        try {
                            ((ITextEditor)editor).selectAndReveal(document.getLineOffset(lineNumber - 1), document.getLineLength(lineNumber - 1));
                        }
                        catch (BadLocationException badLocationException) {}
                    }
                }
                catch (PartInitException e) {
                    Logger.error((String)"org.eclipse.ease.lang.unittest.ui", (String)("Could not open editor for <" + resource + ">"), (Throwable)e);
                }
            }
        }
    }

    private static int getTestFileCount(ITestContainer testContainer) {
        if (testContainer instanceof ITestFile) {
            return 1;
        }
        int files = 0;
        for (ITestContainer child : testContainer.getChildContainers()) {
            files += UnitTestView.getTestFileCount(child);
        }
        return files;
    }

    private static boolean openEditor(ScriptStackTrace stackTrace) {
        if (stackTrace != null) {
            for (IScriptDebugFrame trace : stackTrace) {
                if (trace.getScript().getCommand() instanceof IFile) {
                    UnitTestView.openEditor(trace.getScript().getCommand(), trace.getLineNumber());
                    return true;
                }
                if (!(trace.getScript().getCommand() instanceof File)) continue;
                UnitTestView.openEditor(trace.getScript().getCommand(), trace.getLineNumber());
                return true;
            }
        }
        return false;
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
        Composite composite = new Composite(parent, 0);
        GridLayout gl_composite = new GridLayout(6, false);
        gl_composite.verticalSpacing = 0;
        composite.setLayout((Layout)gl_composite);
        composite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.fResourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)composite);
        this.fLblDuration = new Label(composite, 0);
        this.fLblDuration.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 6, 1));
        this.fLblDuration.setText("");
        Label label = new Label(composite, 258);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 6, 1));
        Label lblErrorIcon = new Label(composite, 0);
        GridData gdLblErrorIcon = new GridData(16384, 0x1000000, false, false, 1, 1);
        gdLblErrorIcon.verticalIndent = 10;
        gdLblErrorIcon.horizontalIndent = 50;
        lblErrorIcon.setLayoutData((Object)gdLblErrorIcon);
        lblErrorIcon.setImage(this.fResourceManager.createImage(Activator.getImageDescriptor("org.eclipse.ease.lang.unittest.ui", "/icons/eobj16/status_error.png")));
        lblErrorIcon.setToolTipText("Exceptions and fatal execution errors.");
        Label lblErrors = new Label(composite, 0);
        GridData gd_lblErrors = new GridData(131072, 0x1000000, false, false, 1, 1);
        gd_lblErrors.verticalIndent = 10;
        lblErrors.setLayoutData((Object)gd_lblErrors);
        lblErrors.setAlignment(0x1000000);
        lblErrors.setText("Errors:");
        lblErrors.setToolTipText("Exceptions and fatal execution errors.");
        this.lblErrorCount = new Label(composite, 0);
        GridData gd_lblErrorCount = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblErrorCount.verticalIndent = 10;
        gd_lblErrorCount.horizontalIndent = 20;
        this.lblErrorCount.setLayoutData((Object)gd_lblErrorCount);
        Label lblFailureIcon = new Label(composite, 0);
        GridData gdLblFailureIcon = new GridData(16384, 0x1000000, false, false, 1, 1);
        gdLblFailureIcon.verticalIndent = 10;
        gdLblFailureIcon.horizontalIndent = 50;
        lblFailureIcon.setLayoutData((Object)gdLblFailureIcon);
        lblFailureIcon.setImage(this.fResourceManager.createImage(Activator.getImageDescriptor("org.eclipse.ease.lang.unittest.ui", "/icons/eobj16/status_failure.png")));
        lblFailureIcon.setToolTipText("Failed test assertions.");
        Label lblFailures = new Label(composite, 0);
        GridData gd_lblFailures = new GridData(131072, 0x1000000, false, false, 1, 1);
        gd_lblFailures.verticalIndent = 10;
        lblFailures.setLayoutData((Object)gd_lblFailures);
        lblFailures.setAlignment(0x1000000);
        lblFailures.setText("Failures:");
        lblFailures.setToolTipText("Failed test assertions.");
        this.lblFailureCount = new Label(composite, 0);
        GridData gdLblFailureCount = new GridData(16384, 0x1000000, false, false, 1, 1);
        gdLblFailureCount.verticalIndent = 10;
        gdLblFailureCount.horizontalIndent = 20;
        this.lblFailureCount.setLayoutData((Object)gdLblFailureCount);
        this.fProgressBar = new ProgressBar(parent, 0);
        this.fProgressBar.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.sashForm = new SashForm(parent, 0);
        this.sashForm.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.sashForm.setOrientation(512);
        this.fFileTreeViewer = new TreeViewer((Composite)this.sashForm, 2050);
        this.fFileTreeViewer.setContentProvider((IContentProvider)new TestSuiteContentProvider());
        this.fFileTreeViewer.setFilters(new ViewerFilter[]{new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return element instanceof ITestContainer;
            }
        }});
        this.fFileTreeViewer.setComparator(new ViewerComparator(){

            public int category(Object element) {
                return element instanceof ITestFile ? 1 : 0;
            }
        });
        TestSuiteLabelProvider provider = new TestSuiteLabelProvider(this.fResourceManager);
        this.fFileTreeViewer.setLabelProvider((IBaseLabelProvider)new DecoratedLabelProvider((ILabelProvider)provider));
        this.fFileTreeViewer.addDoubleClickListener(event -> {
            Object element = ((IStructuredSelection)event.getSelection()).getFirstElement();
            if (element instanceof ITestSuite) {
                UnitTestView.openEditor(((ITestSuite)element).getResource(), 0);
            }
            if (element instanceof ITestFile) {
                UnitTestView.openEditor(((ITestFile)element).getResource(), 0);
            }
            if (element instanceof ITestClass) {
                UnitTestView.openEditor(((ITestClass)element).getStackTrace());
            }
        });
        this.fFileTreeViewer.addSelectionChangedListener(event -> {
            ITreeSelection selection = (ITreeSelection)event.getSelection();
            Object element = selection.getFirstElement();
            if (element instanceof ITestFile || element instanceof ITestClass || element instanceof ITestSuite) {
                this.fTestTreeViewer.setInput(element);
                if (this.sashForm.getWeights()[1] == 0) {
                    this.sashForm.setWeights(this.fSashWeights);
                }
                this.fTestTreeViewer.refresh();
            } else {
                this.fTestTreeViewer.setInput(null);
                if (this.sashForm.getWeights()[1] != 0) {
                    this.fSashWeights = this.sashForm.getWeights();
                }
                int[] nArray = new int[2];
                nArray[0] = 100;
                this.sashForm.setWeights(nArray);
            }
        });
        this.fTestTreeViewer = this.createTestArea((Composite)this.sashForm);
        this.sashForm.setWeights(new int[]{1, 1});
        MenuManager menuManager = new MenuManager();
        Menu menu = menuManager.createContextMenu((Control)this.fFileTreeViewer.getTree());
        this.fFileTreeViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.fFileTreeViewer);
        MenuManager menuManager2 = new MenuManager();
        Menu menu2 = menuManager2.createContextMenu((Control)this.fFileTreeViewer.getTree());
        this.fTestTreeViewer.getControl().setMenu(menu2);
        this.getSite().registerContextMenu(menuManager2, (ISelectionProvider)this.fTestTreeViewer);
        IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
        this.fCollapseAllHandler = new CollapseAllHandler((AbstractTreeViewer)this.fFileTreeViewer);
        handlerService.activateHandler("org.eclipse.ui.navigate.collapseAll", (IHandler)this.fCollapseAllHandler);
        this.fExpandAllHandler = new ExpandAllHandler((AbstractTreeViewer)this.fFileTreeViewer);
        handlerService.activateHandler("org.eclipse.ui.navigate.expandAll", (IHandler)this.fExpandAllHandler);
        MultiSelectionProvider selectionProvider = new MultiSelectionProvider();
        selectionProvider.addSelectionProvider((ISelectionProvider)this.fFileTreeViewer);
        selectionProvider.addSelectionProvider((ISelectionProvider)this.fTestTreeViewer);
        this.getSite().setSelectionProvider((ISelectionProvider)selectionProvider);
    }

    private TreeViewer createTestArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        TreeColumnLayout layout = new TreeColumnLayout();
        composite.setLayout((Layout)layout);
        TreeViewer viewer = new TreeViewer(composite, 67584);
        viewer.addDoubleClickListener(event -> {
            Object element = ((IStructuredSelection)event.getSelection()).getFirstElement();
            if (element instanceof ITest) {
                ITestResult result;
                boolean editorOpen = false;
                if ((TestStatus.ERROR.equals((Object)((ITest)element).getStatus()) || TestStatus.FAILURE.equals((Object)((ITest)element).getStatus())) && (result = ((ITest)element).getWorstResult()) != null) {
                    editorOpen = UnitTestView.openEditor(result.getStackTrace());
                }
                if (!editorOpen) {
                    boolean bl = UnitTestView.openEditor(((ITest)element).getStackTrace());
                }
            }
        });
        viewer.getTree().setHeaderVisible(true);
        viewer.getTree().setLinesVisible(true);
        viewer.setContentProvider((IContentProvider)new TestEntityContentProvider());
        TreeViewerColumn testColumn = new TreeViewerColumn(viewer, 0);
        testColumn.getColumn().setWidth(100);
        testColumn.getColumn().setText("Test");
        layout.setColumnData((Widget)testColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(30, 50, true));
        testColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof ITestEntity) {
                    return super.getText((Object)((ITestEntity)element).getName());
                }
                if (element instanceof IMetadata) {
                    return super.getText((Object)((IMetadata)element).getKey());
                }
                if (element instanceof ITestResult) {
                    return ((ITestResult)element).getStatus().toString();
                }
                return super.getText(element);
            }

            public Image getImage(Object element) {
                if (element instanceof ITestEntity) {
                    element = ((ITestEntity)element).getStatus();
                } else if (element instanceof ITestResult) {
                    element = ((ITestResult)element).getStatus();
                } else if (element instanceof IMetadata) {
                    return UnitTestView.this.fResourceManager.createImage(Activator.getImageDescriptor("org.eclipse.ease.lang.unittest.ui", "/icons/eobj16/metadata.png"));
                }
                if (element instanceof TestStatus) {
                    switch ((TestStatus)element) {
                        case PASS: {
                            return UnitTestView.this.fResourceManager.createImage(Activator.getImageDescriptor("org.eclipse.ease.lang.unittest.ui", "/icons/eobj16/status_pass.png"));
                        }
                        case FAILURE: {
                            return UnitTestView.this.fResourceManager.createImage(Activator.getImageDescriptor("org.eclipse.ease.lang.unittest.ui", "/icons/eobj16/status_failure.png"));
                        }
                        case ERROR: {
                            return UnitTestView.this.fResourceManager.createImage(Activator.getImageDescriptor("org.eclipse.ease.lang.unittest.ui", "/icons/eobj16/status_error.png"));
                        }
                        case RUNNING: {
                            return UnitTestView.this.fResourceManager.createImage(Activator.getImageDescriptor("org.eclipse.ease.lang.unittest.ui", "/icons/eobj16/status_running.png"));
                        }
                        case DISABLED: {
                            return UnitTestView.this.fResourceManager.createImage(Activator.getImageDescriptor("org.eclipse.ease.lang.unittest.ui", "/icons/eobj16/status_ignore.png"));
                        }
                    }
                }
                return super.getImage(element);
            }

            public String getToolTipText(Object element) {
                if (element instanceof ITestEntity) {
                    return ((ITestEntity)element).getDescription();
                }
                return super.getToolTipText(element);
            }
        });
        TreeViewerColumn messageColumn = new TreeViewerColumn(viewer, 0);
        messageColumn.getColumn().setWidth(100);
        messageColumn.getColumn().setText("Description/Status");
        layout.setColumnData((Widget)messageColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(70, 50, true));
        messageColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof ITest) {
                    switch (((ITest)element).getStatus()) {
                        case RUNNING: {
                            return "executing ...";
                        }
                        case NOT_RUN: {
                            return "waiting for execution";
                        }
                        case DISABLED: 
                        case FAILURE: 
                        case ERROR: {
                            ITestResult result = ((ITest)element).getWorstResult();
                            if (result == null) break;
                            return result.getMessage();
                        }
                    }
                    return super.getText((Object)((ITestEntity)element).getDescription());
                }
                if (element instanceof IMetadata) {
                    return super.getText(((IMetadata)element).getValue());
                }
                if (element instanceof ITestResult) {
                    return super.getText((Object)((ITestResult)element).getMessage());
                }
                if (element instanceof ITestEntity) {
                    return ((ITestEntity)element).getDescription();
                }
                return super.getText(element);
            }
        });
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)viewer, (int)2);
        return viewer;
    }

    public void setFocus() {
    }

    public TreeViewer getFileTreeViewer() {
        return this.fFileTreeViewer;
    }

    public StructuredViewer getTableViewer() {
        return this.fTestTreeViewer;
    }

    public void notifyEngineCreation(TestSuiteScriptEngine engine) {
        if (this.fCurrentEngine == null || this.fCurrentEngine.isFinished()) {
            if (this.fCurrentEngine != null) {
                this.fCurrentEngine.getTestRoot().eAdapters().remove((Object)this.fContentAdapter);
            }
            this.fErrorCount = 0;
            this.fFailureCount = 0;
            this.fFinishedFileCount = 0;
            this.fFileTreeViewer.setInput(null);
            this.fProgressBar.setSelection(0);
            this.fProgressBar.setMaximum(1);
            this.lblErrorCount.setText(Integer.toString(this.fErrorCount));
            this.lblFailureCount.setText(Integer.toString(this.fFailureCount));
            this.lblErrorCount.getParent().layout(true, true);
            this.fCurrentEngine = engine;
            this.fCurrentEngine.getTestRoot().eAdapters().add((Object)this.fContentAdapter);
        }
    }

    public static String getDurationString(long duration) {
        if (duration >= 3600000L) {
            return new SimpleDateFormat("HH:mm:ss").format(duration);
        }
        if (duration >= 60000L) {
            return new SimpleDateFormat("mm:ss").format(duration);
        }
        return String.valueOf(duration / 1000L) + " s";
    }

    public void dispose() {
        if (this.fCurrentEngine != null) {
            this.fCurrentEngine.getTestRoot().eAdapters().remove((Object)this.fContentAdapter);
        }
        if (this.fCollapseAllHandler != null) {
            this.fCollapseAllHandler.dispose();
        }
        if (this.fExpandAllHandler != null) {
            this.fExpandAllHandler.dispose();
        }
        if (this.fResourceManager != null) {
            this.fResourceManager.dispose();
            this.fResourceManager = null;
        }
        super.dispose();
    }

    public void terminateSuite() {
        if (this.fCurrentEngine != null) {
            this.fCurrentEngine.terminate();
        }
    }

    public TestSuiteScriptEngine getCurrentEngine() {
        return this.fCurrentEngine;
    }

    public ITestSuite getCurrentTestSuite() {
        ITestEntity testSuite;
        Object input = this.getFileTreeViewer().getInput();
        if (input instanceof ITestContainer && !((ITestContainer)input).getChildren().isEmpty() && (testSuite = (ITestEntity)((ITestContainer)input).getChildren().get(0)) instanceof ITestSuite) {
            return (ITestSuite)testSuite;
        }
        return null;
    }

    private class ContentAdapter
    extends EContentAdapter {
        private ContentAdapter() {
        }

        public void notifyChanged(Notification notification) {
            UpdateUIType eventType;
            Object value;
            super.notifyChanged(notification);
            if (notification.getEventType() == 8) {
                return;
            }
            if (notification.getEventType() == 11) {
                return;
            }
            if (IRuntimePackage.Literals.TEST_ENTITY__END_TIMESTAMP.equals(notification.getFeature())) {
                return;
            }
            if (IRuntimePackage.Literals.TEST_ENTITY__START_TIMESTAMP.equals(notification.getFeature())) {
                return;
            }
            if (IRuntimePackage.Literals.TEST_ENTITY__ESTIMATED_DURATION.equals(notification.getFeature())) {
                return;
            }
            if (IRuntimePackage.Literals.STACK_TRACE_CONTAINER__STACK_TRACE.equals(notification.getFeature())) {
                return;
            }
            if (IRuntimePackage.Literals.TEST_ENTITY__TERMINATED.equals(notification.getFeature())) {
                return;
            }
            if (IRuntimePackage.Literals.TEST_ENTITY__DESCRIPTION.equals(notification.getFeature())) {
                return;
            }
            if (IRuntimePackage.Literals.TEST__DURATION_LIMIT.equals(notification.getFeature())) {
                return;
            }
            if (IRuntimePackage.Literals.TEST_SUITE__MASTER_ENGINE.equals(notification.getFeature())) {
                return;
            }
            if (IRuntimePackage.Literals.TEST_ENTITY__RESULTS.equals(notification.getFeature()) && notification.getEventType() == 3 && (value = notification.getNewValue()) instanceof ITestResult) {
                if (TestStatus.ERROR.equals((Object)((ITestResult)value).getStatus())) {
                    UnitTestView unitTestView = UnitTestView.this;
                    unitTestView.fErrorCount = unitTestView.fErrorCount + 1;
                }
                if (TestStatus.FAILURE.equals((Object)((ITestResult)value).getStatus())) {
                    UnitTestView unitTestView = UnitTestView.this;
                    unitTestView.fFailureCount = unitTestView.fFailureCount + 1;
                }
            }
            if (notification.getNotifier() instanceof ITestFile && IRuntimePackage.Literals.TEST_ENTITY__ENTITY_STATUS.equals(notification.getFeature()) && TestStatus.FINISHED.equals(notification.getNewValue())) {
                UnitTestView unitTestView = UnitTestView.this;
                unitTestView.fFinishedFileCount = unitTestView.fFinishedFileCount + 1;
            }
            UpdateUIType updateUIType = eventType = notification.getEventType() == 3 || notification.getEventType() == 4 ? UpdateUIType.STRUCTURE : UpdateUIType.DECORATOR;
            if (notification.getNotifier() instanceof ITestEntity) {
                UnitTestView.this.fUIJob.refresh((ITestEntity)notification.getNotifier(), eventType);
            }
        }

        public boolean isAdapterForType(Object type) {
            return type instanceof ITestEntity;
        }
    }

    private class TestEntityContentProvider
    implements ITreeContentProvider {
        private TestEntityContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public Object[] getChildren(Object parentElement) {
            ArrayList<Object> children = new ArrayList<Object>();
            if (parentElement instanceof ITestEntity) {
                children.addAll((Collection<Object>)((ITestEntity)parentElement).getMetadata());
                if (!(parentElement instanceof ITest) || ((ITestEntity)parentElement).getResults().size() > 1) {
                    children.addAll((Collection<Object>)((ITestEntity)parentElement).getResults());
                }
                if (parentElement instanceof ITestContainer) {
                    Object[] objectArray = ((ITestContainer)parentElement).getChildren().toArray();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object child = objectArray[n2];
                        if (child instanceof ITest) {
                            children.add(child);
                        }
                        ++n2;
                    }
                }
            }
            return children.toArray();
        }

        public Object getParent(Object element) {
            if (element instanceof ITestEntity) {
                return ((ITestEntity)element).getParent();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof ITestEntity) {
                if (!((ITestEntity)element).getMetadata().isEmpty()) {
                    return true;
                }
                if (((ITestEntity)element).getResults().size() > 1) {
                    return true;
                }
                if (!(element instanceof ITest) && !((ITestEntity)element).getResults().isEmpty()) {
                    return true;
                }
                if (element instanceof ITestContainer) {
                    Object[] objectArray = ((ITestContainer)element).getChildren().toArray();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object child = objectArray[n2];
                        if (child instanceof ITest) {
                            return true;
                        }
                        ++n2;
                    }
                }
            }
            return false;
        }
    }

    private class UIUpdateJob
    extends UIJob {
        private final Map<ITestEntity, UpdateUIType> fElements;

        public UIUpdateJob() {
            super("Script Unittest UI update");
            this.fElements = new HashMap<ITestEntity, UpdateUIType>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void refresh(ITestEntity entity, UpdateUIType type) {
            Map<ITestEntity, UpdateUIType> map = this.fElements;
            synchronized (map) {
                this.fElements.put(entity, UpdateUIType.STRUCTURE.equals((Object)this.fElements.get(entity)) ? UpdateUIType.STRUCTURE : type);
            }
            this.schedule(300L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus runInUIThread(IProgressMonitor monitor) {
            HashMap<ITestEntity, UpdateUIType> elements;
            if (UnitTestView.this.fFileTreeViewer.getTree().isDisposed()) {
                return Status.CANCEL_STATUS;
            }
            Map<ITestEntity, UpdateUIType> map = this.fElements;
            synchronized (map) {
                elements = new HashMap<ITestEntity, UpdateUIType>(this.fElements);
                this.fElements.clear();
            }
            if (UnitTestView.this.fFileTreeViewer.getInput() == null) {
                UnitTestView.this.fFileTreeViewer.setInput((Object)UnitTestView.this.fCurrentEngine.getTestRoot());
                UnitTestView.this.fFileTreeViewer.expandAll();
                TestSuiteSource.getActiveInstance().setActiveSuite(UnitTestView.this.getCurrentTestSuite());
            } else {
                for (Map.Entry entry : elements.entrySet()) {
                    if (UpdateUIType.STRUCTURE.equals(entry.getValue())) {
                        UnitTestView.this.fFileTreeViewer.refresh(entry.getKey());
                        continue;
                    }
                    UnitTestView.this.fFileTreeViewer.update(entry.getKey(), null);
                }
            }
            ITestSuite testSuite = UnitTestView.this.getCurrentTestSuite();
            if (testSuite.getStatus() != TestStatus.RUNNING) {
                UnitTestView.this.fLblDuration.setText("Finished after " + testSuite.getDuration() / 1000L + " s");
                if (UnitTestView.this.fRuntimeInformation != null) {
                    UnitTestView.this.fRuntimeInformation.save();
                    UnitTestView.this.fRuntimeInformation = null;
                }
                TestSuiteSource.getActiveInstance().setActiveSuite(UnitTestView.this.getCurrentTestSuite());
            } else {
                long estimatedDuration = testSuite.getEstimatedDuration();
                if (estimatedDuration < 0L && UnitTestView.this.fRuntimeInformation == null) {
                    UnitTestView.this.fRuntimeInformation = new SuiteRuntimeInformation(testSuite);
                    UnitTestView.this.fLblDuration.setText("running ...");
                    this.schedule(1000L);
                } else if (estimatedDuration >= 0L) {
                    long estimatedLeft = testSuite.getStartTimestamp() + estimatedDuration - System.currentTimeMillis();
                    if (estimatedLeft > 0L) {
                        UnitTestView.this.fLblDuration.setText("Finished in " + UnitTestView.getDurationString(estimatedLeft));
                        this.schedule(1000L);
                    } else {
                        UnitTestView.this.fLblDuration.setText("running ...");
                    }
                }
            }
            UnitTestView.this.lblErrorCount.setText(Integer.toString(UnitTestView.this.fErrorCount));
            UnitTestView.this.lblFailureCount.setText(Integer.toString(UnitTestView.this.fFailureCount));
            UnitTestView.this.lblErrorCount.getParent().layout(true, true);
            if (UnitTestView.this.fProgressBar.getMaximum() == 1) {
                UnitTestView.this.fProgressBar.setMaximum(UnitTestView.getTestFileCount((ITestContainer)testSuite));
                UnitTestView.this.fProgressBar.setForeground(null);
            }
            if (UnitTestView.this.fProgressBar.getSelection() != UnitTestView.this.fFinishedFileCount) {
                UnitTestView.this.fProgressBar.setSelection(UnitTestView.this.fFinishedFileCount);
                if (testSuite.hasError()) {
                    UnitTestView.this.fProgressBar.setForeground(UnitTestView.this.fResourceManager.createColor(new RGB(207, 36, 43)));
                }
            }
            if (testSuite.getStatus() != TestStatus.RUNNING) {
                UnitTestView.this.fProgressBar.setSelection(UnitTestView.this.fProgressBar.getMaximum());
                switch (testSuite.getStatus()) {
                    case ERROR: {
                        UnitTestView.this.fProgressBar.setForeground(UnitTestView.this.fResourceManager.createColor(new RGB(207, 36, 43)));
                        break;
                    }
                    case PASS: {
                        UnitTestView.this.fProgressBar.setForeground(UnitTestView.this.fResourceManager.createColor(new RGB(92, 167, 86)));
                    }
                }
            }
            return Status.OK_STATUS;
        }
    }

    private static enum UpdateUIType {
        STRUCTURE,
        DECORATOR;

    }
}

