/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.modules.modeling.ui.matchers;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.ease.modules.modeling.ui.Messages;
import org.eclipse.ease.modules.modeling.ui.exceptions.MatcherException;
import org.eclipse.ease.modules.modeling.ui.matchers.IMatcher;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;

public class TypeMatcher
implements IMatcher {
    @Override
    public Collection<EObject> getElements(final String string, IEditingDomainProvider currentEditor) throws MatcherException {
        Object filter = Iterators.emptyIterator();
        for (Resource r : currentEditor.getEditingDomain().getResourceSet().getResources()) {
            if (r == null) continue;
            filter = Iterators.concat((Iterator)filter, (Iterator)Iterators.filter((Iterator)r.getAllContents(), (Predicate)new Predicate<EObject>(){

                public boolean apply(EObject input) {
                    LinkedList<EClass> allClasses = new LinkedList<EClass>((Collection<EClass>)input.eClass().getEAllSuperTypes());
                    allClasses.add(input.eClass());
                    for (EClass e : allClasses) {
                        if (!e.getName().equalsIgnoreCase(string)) continue;
                        return true;
                    }
                    return false;
                }
            }));
        }
        return Lists.newArrayList((Iterator)filter);
    }

    @Override
    public String getText() {
        return Messages.TypeMatcher_COMBO_TEXT_TYPE;
    }

    @Override
    public String getHelp() {
        return Messages.TypeMatcher_HELP_TYPE;
    }
}

