/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.view;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.ease.IExecutionListener;
import org.eclipse.ease.IScriptEngine;
import org.eclipse.ease.IScriptEngineProvider;
import org.eclipse.ease.Logger;
import org.eclipse.ease.Script;
import org.eclipse.ease.service.EngineDescription;
import org.eclipse.ease.service.IScriptService;
import org.eclipse.ease.service.ScriptType;
import org.eclipse.ease.ui.Activator;
import org.eclipse.ease.ui.completion.ICompletionProvider;
import org.eclipse.ease.ui.completion.ModuleCompletionProvider;
import org.eclipse.ease.ui.console.ScriptConsole;
import org.eclipse.ease.ui.dnd.ShellDropTarget;
import org.eclipse.ease.ui.view.IShellDropin;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.ParseException;
import org.eclipse.jface.fieldassist.ComboContentAdapter;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.resource.ColorDescriptor;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.osgi.service.prefs.Preferences;

public class ScriptShell
extends ViewPart
implements IPropertyChangeListener,
IScriptEngineProvider,
IExecutionListener {
    public static final String VIEW_ID = "org.eclipse.ease.ui.views.scriptShell";
    private static final String XML_HISTORY_NODE = "history";
    private static final int TYPE_ERROR = 1;
    private static final int TYPE_OUTPUT = 2;
    private static final int TYPE_RESULT = 3;
    private static final int TYPE_COMMAND = 4;
    private SashForm fSashForm;
    private Combo fInputCombo;
    private StyledText fOutputText;
    private boolean fScrollLock = false;
    private boolean fPrintLock = false;
    private LocalResourceManager fResourceManager = null;
    private int[] fSashWeights = new int[]{70, 30};
    private IScriptEngine fScriptEngine;
    private IMemento fInitMemento;
    private int fHistoryLength;
    private boolean fAutoFocus;
    private boolean fKeepCommand;
    private AutoFocus fAutoFocusListener = null;
    private ContentProposalAdapter fContentAssistAdapter = null;
    private Collection<IShellDropin> fDropins = Collections.emptySet();
    private static final String EXTENSION_SHELL_ID = "org.eclipse.ease.ui.shell";
    private static final String EXTENSION_DROPIN_ID = "dropin";
    private static final String PROPERTY_DROPIN_CLASS = "class";

    public ScriptShell() {
        Collection engines;
        IScriptService scriptService = (IScriptService)PlatformUI.getWorkbench().getService(IScriptService.class);
        Preferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.ease.ui").node("shell");
        String engineID = prefs.get("shellDefaultEngine", "org.eclipse.ease.javascript.rhino");
        EngineDescription engineDescription = scriptService.getEngineByID(engineID);
        if (engineDescription == null && (engineDescription = scriptService.getEngine("JavaScript")) == null && !(engines = scriptService.getEngines()).isEmpty()) {
            engineDescription = (EngineDescription)engines.iterator().next();
        }
        if (engineDescription != null) {
            this.setEngine(engineDescription.getID());
        }
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public final void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.fInitMemento = memento;
    }

    public final void saveState(IMemento memento) {
        String[] stringArray = this.fInputCombo.getItems();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            memento.createChild(XML_HISTORY_NODE).putTextData(item);
            ++n2;
        }
        super.saveState(memento);
    }

    public final void createPartControl(Composite parent) {
        this.fResourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)parent);
        parent.setLayout((Layout)new GridLayout());
        this.fSashForm = new SashForm(parent, 0);
        this.fSashForm.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fOutputText = new StyledText((Composite)this.fSashForm, 2568);
        String os = Platform.getOS();
        if ("win32".equals(os)) {
            this.fOutputText.setFont(this.fResourceManager.createFont(FontDescriptor.createFrom((String)"Courier New", (int)10, (int)0)));
        } else if ("linux".equals(os)) {
            this.fOutputText.setFont(this.fResourceManager.createFont(FontDescriptor.createFrom((String)"Monospace", (int)10, (int)0)));
        }
        this.fOutputText.setEditable(false);
        this.fOutputText.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                String selected = ScriptShell.this.fOutputText.getLine(ScriptShell.this.fOutputText.getLineIndex(e.y));
                if (!selected.isEmpty()) {
                    ScriptShell.this.fInputCombo.setText(selected);
                    ScriptShell.this.fInputCombo.setFocus();
                    ScriptShell.this.fInputCombo.setSelection(new Point(0, selected.length()));
                }
            }
        });
        TabFolder tabFolder = new TabFolder((Composite)this.fSashForm, 1024);
        this.fDropins = ScriptShell.getAvailableDropins();
        for (IShellDropin dropin : this.fDropins) {
            dropin.setScriptEngine(this.fScriptEngine);
            TabItem tab = new TabItem(tabFolder, 0);
            tab.setText(dropin.getTitle());
            tab.setControl((Control)dropin.createPartControl(this.getSite(), (Composite)tabFolder));
        }
        this.fSashForm.setWeights(this.fSashWeights);
        this.fInputCombo = new Combo(parent, 0);
        this.fInputCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                String input = ScriptShell.this.fInputCombo.getText();
                ScriptShell.this.fInputCombo.setText("");
                ScriptShell.this.addToHistory(input);
                ScriptShell.this.fScriptEngine.executeAsync((Object)input);
            }
        });
        this.fInputCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        if (this.fInitMemento != null) {
            IMemento[] iMementoArray = this.fInitMemento.getChildren(XML_HISTORY_NODE);
            int n = iMementoArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMemento node = iMementoArray[n2];
                if (node.getTextData() != null) {
                    this.fInputCombo.add(node.getTextData());
                }
                ++n2;
            }
        }
        this.addAutoCompletion();
        this.fInitMemento = null;
        ShellDropTarget.addDropSupport((Control)this.fOutputText, this);
        this.setPartName(String.valueOf(this.fScriptEngine.getName()) + " " + super.getTitle());
        Preferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.ease.ui").node("shell");
        this.fHistoryLength = prefs.getInt("shellHistoryLength", 20);
        this.fAutoFocus = prefs.getBoolean("shellAutoFocus", true);
        this.fKeepCommand = prefs.getBoolean("shellKeepCommand", false);
        if (this.fAutoFocus) {
            if (this.fAutoFocusListener == null) {
                this.fAutoFocusListener = new AutoFocus();
            }
            this.fOutputText.addKeyListener((KeyListener)this.fAutoFocusListener);
        }
        this.runStartupCommands();
    }

    private void addAutoCompletion() {
        ICompletionProvider provider;
        if (this.fContentAssistAdapter != null) {
            this.fContentAssistAdapter.setEnabled(false);
        }
        if ((provider = ModuleCompletionProvider.getCompletionProvider(this.fScriptEngine.getDescription())) != null) {
            try {
                KeyStroke activationKey = KeyStroke.getInstance((String)"Ctrl+Space");
                ContentProposalAdapter adapter = new ContentProposalAdapter((Control)this.fInputCombo, (IControlContentAdapter)new ComboContentAdapter(), (IContentProposalProvider)provider, activationKey, provider.getActivationChars());
                adapter.setProposalAcceptanceStyle(1);
                this.fContentAssistAdapter = adapter;
            }
            catch (ParseException e) {
                Logger.logError((String)"Cannot create content assist", (Throwable)e);
            }
        }
    }

    public void runStartupCommands() {
        Preferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.ease.ui").node("shell");
        for (ScriptType scriptType : this.fScriptEngine.getDescription().getSupportedScriptTypes()) {
            String initCommands = prefs.get("shellStartup" + scriptType.getName(), "").trim();
            if (!initCommands.isEmpty()) {
                this.fScriptEngine.executeAsync((Object)initCommands);
                continue;
            }
            this.localPrint("// use help(\"<topic>\") to get more information", 4);
        }
    }

    private void addToHistory(String input) {
        if (this.fInputCombo.getSelectionIndex() != -1) {
            this.fInputCombo.remove(this.fInputCombo.getSelectionIndex());
        } else {
            int index = 0;
            while (index < this.fInputCombo.getItemCount()) {
                if (this.fInputCombo.getItem(index).equals(input)) {
                    this.fInputCombo.remove(index);
                    break;
                }
                ++index;
            }
        }
        while (this.fInputCombo.getItemCount() >= this.fHistoryLength) {
            this.fInputCombo.remove(this.fInputCombo.getItemCount() - 1);
        }
        this.fInputCombo.add(input, 0);
    }

    public final void dispose() {
        if (this.fScriptEngine != null) {
            this.fScriptEngine.removeExecutionListener((IExecutionListener)this);
            this.fScriptEngine.terminate();
        }
        this.fResourceManager.dispose();
        super.dispose();
    }

    public final void setFocus() {
        this.fInputCombo.setFocus();
    }

    public final void clearOutput() {
        this.fOutputText.setText("");
        this.fOutputText.setStyleRanges(new StyleRange[0]);
    }

    public final void setScrollLock(boolean lock) {
        this.fScrollLock = lock;
    }

    public final void setPrintLock(boolean lock) {
        this.fPrintLock = lock;
    }

    private void localPrint(final String message, final int style) {
        if (!(message == null || this.fPrintLock && style != 1)) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    String out = message;
                    if (style != 4) {
                        out = "\t" + message.replaceAll("\\r?\\n", "\n\t");
                    }
                    if (!ScriptShell.this.fOutputText.isDisposed()) {
                        ScriptShell.this.fOutputText.append("\n");
                        StyleRange styleRange = ScriptShell.this.getStyle(style, ScriptShell.this.fOutputText.getText().length(), out.length());
                        ScriptShell.this.fOutputText.append(out);
                        ScriptShell.this.fOutputText.setStyleRange(styleRange);
                        if (!ScriptShell.this.fScrollLock) {
                            ScriptShell.this.fOutputText.setHorizontalPixel(0);
                            ScriptShell.this.fOutputText.setTopPixel(ScriptShell.this.fOutputText.getLineHeight() * ScriptShell.this.fOutputText.getLineCount());
                        }
                    }
                }
            });
        }
    }

    private StyleRange getStyle(int style, int start, int length) {
        StyleRange styleRange = new StyleRange();
        styleRange.start = start;
        styleRange.length = length;
        switch (style) {
            case 3: {
                styleRange.foreground = this.fResourceManager.createColor(ColorDescriptor.createFrom((Color)this.getViewSite().getShell().getDisplay().getSystemColor(16)));
                break;
            }
            case 4: {
                styleRange.foreground = this.fResourceManager.createColor(ColorDescriptor.createFrom((Color)this.getViewSite().getShell().getDisplay().getSystemColor(9)));
                styleRange.fontStyle = 1;
                break;
            }
            case 1: {
                styleRange.foreground = this.fResourceManager.createColor(ColorDescriptor.createFrom((Color)this.getViewSite().getShell().getDisplay().getSystemColor(3)));
                styleRange.fontStyle = 2;
                break;
            }
            case 2: {
                styleRange.foreground = this.fResourceManager.createColor(ColorDescriptor.createFrom((Color)this.getViewSite().getShell().getDisplay().getSystemColor(2)));
                break;
            }
        }
        return styleRange;
    }

    public final String getSelectedText() {
        String text = this.fOutputText.getSelectionText();
        if (text.isEmpty()) {
            return this.fOutputText.getText();
        }
        return text;
    }

    public final void toggleDropinsPane() {
        if (this.fSashForm.getWeights()[1] == 0) {
            this.fSashForm.setWeights(this.fSashWeights);
        } else {
            this.fSashWeights = this.fSashForm.getWeights();
            int[] nArray = new int[2];
            nArray[0] = 100;
            this.fSashForm.setWeights(nArray);
        }
    }

    public final void propertyChange(PropertyChangeEvent event) {
        if ("shellAutoFocus".equals(event.getProperty())) {
            if (Boolean.parseBoolean(event.getNewValue().toString())) {
                if (this.fAutoFocusListener == null) {
                    this.fAutoFocusListener = new AutoFocus();
                }
                this.fOutputText.addKeyListener((KeyListener)this.fAutoFocusListener);
            } else {
                this.fOutputText.removeKeyListener((KeyListener)this.fAutoFocusListener);
            }
        } else if ("shellKeepCommand".equals(event.getProperty())) {
            this.fKeepCommand = Boolean.parseBoolean(event.getNewValue().toString());
        } else if ("shellHistoryLength".equals(event.getProperty())) {
            this.fHistoryLength = Integer.parseInt(event.getNewValue().toString());
        }
    }

    public StyledText getOutput() {
        return this.fOutputText;
    }

    public void stopScriptEngine() {
        this.fScriptEngine.terminateCurrent();
    }

    public IScriptEngine getScriptEngine() {
        return this.fScriptEngine;
    }

    public void notify(IScriptEngine engine, Script script, int status) {
        try {
            switch (status) {
                case 3: {
                    this.localPrint(script.getCode(), 4);
                    break;
                }
                case 4: {
                    if (script.getResult().hasException()) {
                        this.localPrint(script.getResult().getException().getLocalizedMessage(), 1);
                    } else {
                        Object result = script.getResult().getResult();
                        if (result != null) {
                            this.localPrint(script.getResult().getResult().toString(), 3);
                        } else {
                            this.localPrint("[null]", 3);
                        }
                        if (this.fContentAssistAdapter != null) {
                            ((ICompletionProvider)this.fContentAssistAdapter.getContentProposalProvider()).addCode(script.getCode());
                        }
                    }
                    if (this.fKeepCommand) {
                        final String code = script.getCode();
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (!ScriptShell.this.fInputCombo.isDisposed()) {
                                    ScriptShell.this.fInputCombo.setText(code);
                                    ScriptShell.this.fInputCombo.setSelection(new Point(0, code.length()));
                                }
                            }
                        });
                    }
                    break;
                }
            }
        }
        catch (Exception exception) {}
    }

    public final void setEngine(String id) {
        if (this.fScriptEngine != null) {
            this.fScriptEngine.removeExecutionListener((IExecutionListener)this);
            this.fScriptEngine.terminate();
        }
        IScriptService scriptService = (IScriptService)PlatformUI.getWorkbench().getService(IScriptService.class);
        this.fScriptEngine = scriptService.getEngineByID(id).createEngine();
        if (this.fScriptEngine != null) {
            this.fScriptEngine.setTerminateOnIdle(false);
            this.setPartName(String.valueOf(this.fScriptEngine.getName()) + " Script Shell");
            ScriptConsole console = ScriptConsole.create(String.valueOf(this.fScriptEngine.getName()) + "Script Shell", this.fScriptEngine);
            this.fScriptEngine.setOutputStream((OutputStream)console.getOutputStream());
            this.fScriptEngine.setErrorStream((OutputStream)console.getErrorStream());
            this.fScriptEngine.addExecutionListener((IExecutionListener)this);
            this.fScriptEngine.schedule();
            if (this.fInputCombo != null) {
                this.runStartupCommands();
            }
            for (IShellDropin dropin : this.fDropins) {
                dropin.setScriptEngine(this.fScriptEngine);
            }
        }
    }

    private static Collection<IShellDropin> getAvailableDropins() {
        IConfigurationElement[] config;
        ArrayList<IShellDropin> dropins = new ArrayList<IShellDropin>();
        IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_SHELL_ID);
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            if (e.getName().equals(EXTENSION_DROPIN_ID)) {
                try {
                    Object dropin = e.createExecutableExtension(PROPERTY_DROPIN_CLASS);
                    if (dropin instanceof IShellDropin) {
                        dropins.add((IShellDropin)dropin);
                    }
                }
                catch (CoreException e1) {
                    Logger.logError((String)("Invalid shell dropin detected: " + e.getAttribute(PROPERTY_DROPIN_CLASS)), (Throwable)e1);
                }
            }
            ++n2;
        }
        return dropins;
    }

    private class AutoFocus
    implements KeyListener {
        private AutoFocus() {
        }

        public void keyReleased(KeyEvent e) {
            if (e.keyCode == 118 && (e.stateMask & 0x40000) != 0) {
                Clipboard clipboard = new Clipboard(Display.getDefault());
                Object content = clipboard.getContents((Transfer)TextTransfer.getInstance());
                if (content != null) {
                    ScriptShell.this.fInputCombo.setText(String.valueOf(ScriptShell.this.fInputCombo.getText()) + content.toString());
                }
                ScriptShell.this.fInputCombo.setFocus();
                ScriptShell.this.fInputCombo.setSelection(new Point(ScriptShell.this.fInputCombo.getText().length(), ScriptShell.this.fInputCombo.getText().length()));
            }
        }

        public void keyPressed(KeyEvent e) {
            if ((e.keyCode != 99 || (e.stateMask & 0x40000) == 0) && e.keyCode != 262144) {
                ScriptShell.this.fInputCombo.setText(String.valueOf(ScriptShell.this.fInputCombo.getText()) + e.character);
                ScriptShell.this.fInputCombo.setFocus();
                ScriptShell.this.fInputCombo.setSelection(new Point(ScriptShell.this.fInputCombo.getText().length(), ScriptShell.this.fInputCombo.getText().length()));
            }
        }
    }
}

