/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.modules.unittest.ui.editor;

import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.ease.modules.unittest.components.TestSuiteModel;
import org.eclipse.ease.modules.unittest.ui.editor.AbstractEditorPage;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;

public class Variables
extends AbstractEditorPage {
    private static final Pattern VARIABLE_NAME_PATTERN = Pattern.compile("([a-zA-Z_$][0-9a-zA-Z_$]*)");
    private Table table_1;
    private TableViewer tableViewer;

    public Variables(String id, String title) {
        super(id, title);
    }

    public Variables(FormEditor editor, String id, String title) {
        super(editor, id, title);
    }

    @Override
    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        managedForm.getForm().getBody().setLayout((Layout)new GridLayout(2, false));
        Label lblDefineVariablesThat = new Label(managedForm.getForm().getBody(), 0);
        lblDefineVariablesThat.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        managedForm.getToolkit().adapt((Control)lblDefineVariablesThat, true, true);
        lblDefineVariablesThat.setText("Define variables that will be visible in your scripts. Ordering is important if variables depend on each other.");
        Composite composite = new Composite(managedForm.getForm().getBody(), 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 4));
        managedForm.getToolkit().adapt(composite);
        managedForm.getToolkit().paintBordersFor(composite);
        TableColumnLayout tcl_composite = new TableColumnLayout();
        composite.setLayout((Layout)tcl_composite);
        Table table = new Table(composite, 67584);
        this.tableViewer = new TableViewer(table);
        this.table_1 = this.tableViewer.getTable();
        this.table_1.setHeaderVisible(true);
        this.table_1.setLinesVisible(true);
        managedForm.getToolkit().paintBordersFor((Composite)this.table_1);
        this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        TableViewerColumn tableViewerColumn = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnVariable = tableViewerColumn.getColumn();
        tcl_composite.setColumnData((Widget)tblclmnVariable, (ColumnLayoutData)new ColumnWeightData(100, 100, true));
        tblclmnVariable.setText("Variable");
        tableViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((TestSuiteModel.Variable)element).getName();
            }
        });
        tableViewerColumn.setEditingSupport(new EditingSupport((ColumnViewer)this.tableViewer){

            protected void setValue(Object element, Object value) {
                if (Variables.this.checkName(value.toString())) {
                    ((TestSuiteModel.Variable)element).setName(value.toString());
                    Variables.this.setDirty();
                    Variables.this.tableViewer.update(element, null);
                }
            }

            protected Object getValue(Object element) {
                return ((TestSuiteModel.Variable)element).getName();
            }

            protected CellEditor getCellEditor(Object element) {
                return new TextCellEditor((Composite)Variables.this.table_1);
            }

            protected boolean canEdit(Object element) {
                return true;
            }
        });
        TableViewerColumn tableViewerColumn_1 = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnContent = tableViewerColumn_1.getColumn();
        tcl_composite.setColumnData((Widget)tblclmnContent, (ColumnLayoutData)new ColumnWeightData(100, 100, true));
        tblclmnContent.setText("Content");
        tableViewerColumn_1.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((TestSuiteModel.Variable)element).getContent();
            }
        });
        tableViewerColumn_1.setEditingSupport(new EditingSupport((ColumnViewer)this.tableViewer){

            protected void setValue(Object element, Object value) {
                ((TestSuiteModel.Variable)element).setContent(value.toString());
                Variables.this.setDirty();
                Variables.this.tableViewer.update(element, null);
            }

            protected Object getValue(Object element) {
                return ((TestSuiteModel.Variable)element).getContent();
            }

            protected CellEditor getCellEditor(Object element) {
                return new TextCellEditor((Composite)Variables.this.table_1);
            }

            protected boolean canEdit(Object element) {
                return true;
            }
        });
        TableViewerColumn tableViewerColumn_3 = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnDescription = tableViewerColumn_3.getColumn();
        tcl_composite.setColumnData((Widget)tblclmnDescription, (ColumnLayoutData)new ColumnWeightData(100, 20, true));
        tblclmnDescription.setText("Description");
        tableViewerColumn_3.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((TestSuiteModel.Variable)element).getDescription();
            }
        });
        tableViewerColumn_3.setEditingSupport(new EditingSupport((ColumnViewer)this.tableViewer){

            protected void setValue(Object element, Object value) {
                ((TestSuiteModel.Variable)element).setDescription(value.toString());
                Variables.this.setDirty();
                Variables.this.tableViewer.update(element, null);
            }

            protected Object getValue(Object element) {
                return ((TestSuiteModel.Variable)element).getDescription();
            }

            protected CellEditor getCellEditor(Object element) {
                return new TextCellEditor((Composite)Variables.this.table_1);
            }

            protected boolean canEdit(Object element) {
                return true;
            }
        });
        Button btnNewButton = new Button(managedForm.getForm().getBody(), 0x800000);
        btnNewButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Variables.this.getModel().addVariable(Variables.this.createVariable(), "my content", null);
                Variables.this.setDirty();
                Variables.this.tableViewer.refresh();
            }
        });
        btnNewButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        managedForm.getToolkit().adapt((Control)btnNewButton, true, true);
        btnNewButton.setText("Add");
        Button btnDelete = new Button(managedForm.getForm().getBody(), 0x800000);
        btnDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)Variables.this.tableViewer.getSelection();
                for (Object variable : selection.toList()) {
                    Variables.this.getModel().removeVariable((TestSuiteModel.Variable)variable);
                }
                Variables.this.tableViewer.refresh();
                Variables.this.setDirty();
            }
        });
        btnDelete.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        managedForm.getToolkit().adapt((Control)btnDelete, true, true);
        btnDelete.setText("Remove");
        Button btnUp = new Button(managedForm.getForm().getBody(), 0x800000);
        btnUp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)Variables.this.tableViewer.getSelection();
                if (!selection.isEmpty()) {
                    TestSuiteModel.Variable variable = (TestSuiteModel.Variable)selection.getFirstElement();
                    Variables.this.moveUp(variable);
                    Variables.this.tableViewer.refresh();
                    Variables.this.setDirty();
                }
            }
        });
        GridData gd_btnUp = new GridData(4, 0x1000000, false, false, 1, 1);
        gd_btnUp.verticalIndent = 30;
        btnUp.setLayoutData((Object)gd_btnUp);
        managedForm.getToolkit().adapt((Control)btnUp, true, true);
        btnUp.setText("Up");
        Button btnDown = new Button(managedForm.getForm().getBody(), 0x800000);
        btnDown.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)Variables.this.tableViewer.getSelection();
                if (!selection.isEmpty()) {
                    TestSuiteModel.Variable variable = (TestSuiteModel.Variable)selection.getFirstElement();
                    Variables.this.moveDown(variable);
                    Variables.this.tableViewer.refresh();
                    Variables.this.setDirty();
                }
            }
        });
        btnDown.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        managedForm.getToolkit().adapt((Control)btnDown, true, true);
        btnDown.setText("Down");
        this.update();
    }

    private void moveUp(TestSuiteModel.Variable element) {
        List input = (List)this.tableViewer.getInput();
        int index = input.indexOf(element);
        if (index > 0) {
            input.set(index, (TestSuiteModel.Variable)input.get(index - 1));
            input.set(index - 1, element);
        }
    }

    private void moveDown(TestSuiteModel.Variable element) {
        List input = (List)this.tableViewer.getInput();
        int index = input.indexOf(element);
        if (index < input.size() - 1) {
            input.set(index, (TestSuiteModel.Variable)input.get(index + 1));
            input.set(index + 1, element);
        }
    }

    private String createVariable() {
        String newName = "myVariable";
        int index = 1;
        while (!this.checkName(newName)) {
            newName = "myVariable_" + Integer.toString(index++);
        }
        return newName;
    }

    private boolean checkName(String newName) {
        if (VARIABLE_NAME_PATTERN.matcher(newName).matches()) {
            for (TestSuiteModel.Variable variable : this.getModel().getVariables()) {
                if (!newName.equals(variable.getName())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    protected String getPageTitle() {
        return "Variables";
    }

    @Override
    protected void update() {
        this.tableViewer.setInput((Object)this.getModel().getVariables());
        this.tableViewer.refresh();
    }
}

