/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.tools;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public abstract class AbstractVirtualTreeProvider
implements ITreeContentProvider {
    private static final IPath ROOT = new Path("");
    private final Map<IPath, Collection<Object>> fElements = new HashMap<IPath, Collection<Object>>();

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Object[] getElements(Object inputElement) {
        this.fElements.clear();
        this.registerPath(ROOT);
        this.populateElements(inputElement);
        return this.fElements.get(ROOT).toArray();
    }

    public Object[] getChildren(Object parentElement) {
        Collection<Object> children = this.fElements.get(parentElement);
        if (children != null) {
            return children.toArray();
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        for (IPath path : this.fElements.keySet()) {
            if (!this.fElements.get(path).contains(element)) continue;
            return path;
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.fElements.containsKey(element) && !this.fElements.get(element).isEmpty();
    }

    public void registerElement(IPath path, Object element) {
        path = path.makeRelative();
        this.registerPath(path);
        this.fElements.get(path).add(element);
    }

    public void registerPath(IPath path) {
        if (!this.fElements.containsKey(path = path.makeRelative())) {
            this.fElements.put(path, new HashSet());
            if (!path.isEmpty()) {
                IPath parent = path.removeLastSegments(1);
                this.registerPath(parent);
                this.fElements.get(parent).add(path);
            }
        }
    }

    protected abstract void populateElements(Object var1);
}

