/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.repository.impl;

import java.io.InputStream;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ease.ui.repository.IRawLocation;
import org.eclipse.ease.ui.repository.IRepositoryFactory;
import org.eclipse.ease.ui.repository.IRepositoryPackage;
import org.eclipse.ease.ui.repository.IScript;
import org.eclipse.ease.ui.repository.IScriptLocation;
import org.eclipse.ease.ui.repository.IStorage;
import org.eclipse.ease.ui.repository.impl.ParameterMapImpl;
import org.eclipse.ease.ui.repository.impl.RawLocationImpl;
import org.eclipse.ease.ui.repository.impl.ScriptImpl;
import org.eclipse.ease.ui.repository.impl.ScriptLocationImpl;
import org.eclipse.ease.ui.repository.impl.StorageImpl;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;

public class RepositoryFactoryImpl
extends EFactoryImpl
implements IRepositoryFactory {
    public static IRepositoryFactory init() {
        try {
            IRepositoryFactory theRepositoryFactory = (IRepositoryFactory)EPackage.Registry.INSTANCE.getEFactory("repository");
            if (theRepositoryFactory != null) {
                return theRepositoryFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new RepositoryFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createScript();
            }
            case 1: {
                return this.createRawLocation();
            }
            case 2: {
                return this.createStorage();
            }
            case 3: {
                return this.createScriptLocation();
            }
            case 4: {
                return (EObject)this.createParameterMap();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 5: {
                return this.createPathFromString(eDataType, initialValue);
            }
            case 6: {
                return this.createInputStreamFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 5: {
                return this.convertPathToString(eDataType, instanceValue);
            }
            case 6: {
                return this.convertInputStreamToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    @Override
    public IScript createScript() {
        ScriptImpl script = new ScriptImpl();
        return script;
    }

    @Override
    public IRawLocation createRawLocation() {
        RawLocationImpl rawLocation = new RawLocationImpl();
        return rawLocation;
    }

    @Override
    public IStorage createStorage() {
        StorageImpl storage = new StorageImpl();
        return storage;
    }

    @Override
    public IScriptLocation createScriptLocation() {
        ScriptLocationImpl scriptLocation = new ScriptLocationImpl();
        return scriptLocation;
    }

    public Map.Entry<String, String> createParameterMap() {
        ParameterMapImpl parameterMap = new ParameterMapImpl();
        return parameterMap;
    }

    public IPath createPathFromString(EDataType eDataType, String initialValue) {
        return (IPath)super.createFromString(eDataType, initialValue);
    }

    public String convertPathToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(eDataType, instanceValue);
    }

    public InputStream createInputStreamFromString(EDataType eDataType, String initialValue) {
        return (InputStream)super.createFromString(eDataType, initialValue);
    }

    public String convertInputStreamToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(eDataType, instanceValue);
    }

    @Override
    public IRepositoryPackage getRepositoryPackage() {
        return (IRepositoryPackage)this.getEPackage();
    }

    @Deprecated
    public static IRepositoryPackage getPackage() {
        return IRepositoryPackage.eINSTANCE;
    }
}

