/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.completion;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ease.Logger;
import org.eclipse.ease.modules.ModuleDefinition;
import org.eclipse.ease.modules.ModuleHelper;
import org.eclipse.ease.service.EngineDescription;
import org.eclipse.ease.service.IScriptService;
import org.eclipse.ease.ui.completion.ICompletionProvider;
import org.eclipse.jface.fieldassist.ContentProposal;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.ui.PlatformUI;

public abstract class ModuleCompletionProvider
implements ICompletionProvider {
    private static final String EXTENSION_PROCESSOR_ID = "org.eclipse.ease.ui.completionProcessor";
    private static final String EXTENSION_PROCESSOR = "completionProcessor";
    private static final String PARAMETER_ENGINE_ID = "engineID";
    private static final String PARAMETER_CLASS = "class";
    private static final Pattern LOAD_MODULE_PATTERN = Pattern.compile("loadModule\\([\"'](.*)[\"']\\)");
    private static final Pattern LINE_DATA_PATTERN = Pattern.compile(".*?([^\\p{Alnum}]?)(\\p{Alnum}*)$");
    private final Collection<ModuleDefinition> fLoadedModules = new HashSet<ModuleDefinition>();

    public static ICompletionProvider getCompletionProvider(EngineDescription engineDescription) {
        IConfigurationElement[] config;
        IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_PROCESSOR_ID);
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            if (e.getName().equals(EXTENSION_PROCESSOR) && engineDescription.getID().equals(e.getAttribute(PARAMETER_ENGINE_ID))) {
                try {
                    Object executable = e.createExecutableExtension(PARAMETER_CLASS);
                    if (executable instanceof ICompletionProvider) {
                        return (ICompletionProvider)executable;
                    }
                }
                catch (CoreException e1) {
                    Logger.logError((String)("Invalid completion processor detected for engine " + engineDescription.getID()), (Throwable)e1);
                }
            }
            ++n2;
        }
        return null;
    }

    public ModuleCompletionProvider() {
        IScriptService scriptService = (IScriptService)PlatformUI.getWorkbench().getService(IScriptService.class);
        this.fLoadedModules.add((ModuleDefinition)scriptService.getAvailableModules().get("/System/Environment"));
    }

    public IContentProposal[] getProposals(String contents, int position) {
        ArrayList<ContentProposal> proposals = new ArrayList<ContentProposal>();
        Matcher matcher = this.matchLastToken(contents);
        if (matcher.matches() && !".".equals(matcher.group(1))) {
            for (ModuleDefinition definition : this.fLoadedModules) {
                for (Field field : definition.getFields()) {
                    if (!field.getName().startsWith(matcher.group(2)) || matcher.group(2).length() >= field.getName().length()) continue;
                    proposals.add(new ContentProposal(field.getName().substring(matcher.group(2).length()), field.getName(), null));
                }
                for (Method method : definition.getMethods()) {
                    if (!method.getName().startsWith(matcher.group(2)) || matcher.group(2).length() >= method.getName().length()) continue;
                    proposals.add(new ContentProposal(String.valueOf(method.getName().substring(matcher.group(2).length())) + "()", String.valueOf(method.getName()) + "()", null));
                }
            }
        }
        this.modifyProposals(proposals, contents);
        Collections.sort(proposals, new Comparator<ContentProposal>(){

            @Override
            public int compare(ContentProposal arg0, ContentProposal arg1) {
                return arg0.getLabel().compareTo(arg1.getLabel());
            }
        });
        return proposals.toArray(new IContentProposal[proposals.size()]);
    }

    protected abstract void modifyProposals(Collection<ContentProposal> var1, String var2);

    @Override
    public char[] getActivationChars() {
        return null;
    }

    @Override
    public void addCode(String code) {
        IScriptService scriptService = (IScriptService)PlatformUI.getWorkbench().getService(IScriptService.class);
        Collection<String> modules = this.getModuleNames(code);
        while (!modules.isEmpty()) {
            String candidate = modules.iterator().next();
            modules.remove(candidate);
            String fullName = ModuleHelper.resolveName((String)candidate);
            ModuleDefinition definition = (ModuleDefinition)scriptService.getAvailableModules().get(fullName);
            if (definition == null) continue;
            this.fLoadedModules.add(definition);
            for (String moduleID : definition.getDependencies()) {
                modules.add(scriptService.getModuleDefinition(moduleID).getPath().toString());
            }
        }
    }

    private Collection<String> getModuleNames(String code) {
        HashSet<String> modules = new HashSet<String>();
        Matcher matcher = LOAD_MODULE_PATTERN.matcher(code);
        while (matcher.find()) {
            modules.add(matcher.group(1));
        }
        return modules;
    }

    protected Matcher matchLastToken(String data) {
        return LINE_DATA_PATTERN.matcher(data);
    }
}

