/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.completions.java.provider;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import org.eclipse.ease.ICompletionContext;
import org.eclipse.ease.ui.Activator;
import org.eclipse.ease.ui.completion.IImageResolver;
import org.eclipse.ease.ui.completion.provider.AbstractCompletionProvider;
import org.eclipse.ease.ui.completion.tokenizer.InputTokenizer;
import org.eclipse.ease.ui.completion.tokenizer.TokenList;
import org.eclipse.ease.ui.completions.java.help.handlers.JavaFieldHelpResolver;
import org.eclipse.ease.ui.completions.java.help.handlers.JavaMethodHelpResolver;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.StyledString;

public class JavaMethodCompletionProvider
extends AbstractCompletionProvider {
    public boolean isActive(ICompletionContext context) {
        return super.isActive(context) && this.isJavaClassContext(context);
    }

    protected void prepareProposals(ICompletionContext context) {
        TokenList tokens = this.getRelevantTokens(context);
        boolean isStatic = this.isStaticClassContext(tokens);
        Class<?> clazz = this.getJavaClass(tokens);
        String filter = context.getFilter();
        AccessibleObject[] accessibleObjectArray = clazz.getMethods();
        int n = accessibleObjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = accessibleObjectArray[n2];
            if (isStatic == Modifier.isStatic(method.getModifiers()) && method.getName().startsWith(filter)) {
                this.addMethodProposal(method);
            }
            ++n2;
        }
        accessibleObjectArray = clazz.getFields();
        n = accessibleObjectArray.length;
        n2 = 0;
        while (n2 < n) {
            AccessibleObject field = accessibleObjectArray[n2];
            if (isStatic == Modifier.isStatic(((Field)field).getModifiers()) && ((Field)field).getName().startsWith(filter)) {
                this.addFieldProposal((Field)field);
            }
            ++n2;
        }
    }

    private void addFieldProposal(Field field) {
        JavaFieldHelpResolver helpResolver = new JavaFieldHelpResolver(field);
        StyledString styledString = new StyledString(String.valueOf(field.getName()) + " : " + field.getType().getSimpleName());
        styledString.append(" - " + field.getDeclaringClass().getSimpleName(), StyledString.QUALIFIER_STYLER);
        AbstractCompletionProvider.DescriptorImageResolver imageResolver = Modifier.isStatic(field.getModifiers()) ? new AbstractCompletionProvider.DescriptorImageResolver(Activator.getImageDescriptor((String)"org.eclipse.ease.ui.completions.java", (String)"/icons/eobj16/static_field.png")) : new JDTImageResolver("org.eclipse.jdt.ui.field_public_obj.gif");
        this.addProposal(styledString, String.valueOf(this.getDotPrefix()) + field.getName(), (IImageResolver)imageResolver, 80, helpResolver);
    }

    private void addMethodProposal(Method method) {
        AbstractCompletionProvider.DescriptorImageResolver imageResolver;
        JavaMethodHelpResolver helpResolver = new JavaMethodHelpResolver(method);
        StyledString styledString = new StyledString(String.valueOf(method.getName()) + "(" + this.getMethodSignature(method) + ") : " + this.getMethodReturnType(method));
        styledString.append(" - " + method.getDeclaringClass().getSimpleName(), StyledString.QUALIFIER_STYLER);
        Object object = imageResolver = Modifier.isStatic(method.getModifiers()) ? new AbstractCompletionProvider.DescriptorImageResolver(Activator.getImageDescriptor((String)"org.eclipse.ease.ui.completions.java", (String)"/icons/eobj16/static_function.png")) : new JDTImageResolver("org.eclipse.jdt.ui.methpub_obj.gif");
        if (method.getParameterTypes().length > 0) {
            this.addProposal(styledString, String.valueOf(this.getDotPrefix()) + method.getName() + "(", (IImageResolver)imageResolver, 90, helpResolver);
        } else {
            this.addProposal(styledString, String.valueOf(this.getDotPrefix()) + method.getName() + "()", (IImageResolver)imageResolver, 90, helpResolver);
        }
    }

    private String getDotPrefix() {
        Object lastToken = this.getRelevantTokens(this.getContext()).getLastToken();
        return lastToken instanceof Class || lastToken instanceof Method || "()".equals(lastToken) ? "." : "";
    }

    private boolean isJavaClassContext(ICompletionContext context) {
        TokenList tokens = this.getRelevantTokens(context);
        if (!tokens.isEmpty()) {
            tokens.remove(0);
            tokens.removeIfMatches(0, "()");
            tokens.removeIfMatches(0, ".");
            return tokens.isEmpty() || tokens.size() == 1 && !InputTokenizer.isDelimiter((Object)tokens.get(0));
        }
        return false;
    }

    private TokenList getRelevantTokens(ICompletionContext context) {
        TokenList classTokens = new TokenList(context.getTokens()).getFromLast(Class.class);
        TokenList methodTokens = new TokenList(context.getTokens()).getFromLast(Method.class);
        if (!classTokens.isEmpty() && !methodTokens.isEmpty()) {
            return classTokens.size() < methodTokens.size() ? classTokens : methodTokens;
        }
        if (!classTokens.isEmpty()) {
            return classTokens;
        }
        if (!methodTokens.isEmpty()) {
            return methodTokens;
        }
        return new TokenList();
    }

    private boolean isStaticClassContext(TokenList tokens) {
        if (!tokens.isEmpty() && tokens.get(0) instanceof Class) {
            return tokens.size() == 1 || tokens.size() >= 2 && !"()".equals(tokens.get(1));
        }
        return false;
    }

    private Class<?> getJavaClass(TokenList tokens) {
        if (!tokens.isEmpty()) {
            Object baseElement = tokens.get(0);
            if (baseElement instanceof Class) {
                return (Class)baseElement;
            }
            if (baseElement instanceof Method) {
                return ((Method)baseElement).getReturnType();
            }
        }
        return null;
    }

    private String getMethodReturnType(Method method) {
        Class<?> returnType = method.getReturnType();
        return returnType == null ? "void" : returnType.getSimpleName();
    }

    private String getMethodSignature(Method method) {
        StringBuilder result = new StringBuilder();
        Parameter[] parameterArray = method.getParameters();
        int n = parameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            Parameter parameter = parameterArray[n2];
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append(parameter.getType().getSimpleName());
            result.append(' ').append(parameter.getName());
            ++n2;
        }
        return result.toString();
    }

    public static class JDTImageResolver
    extends AbstractCompletionProvider.DescriptorImageResolver {
        private final String fImageIdentifier;

        public JDTImageResolver(String imageIdentifier) {
            this.fImageIdentifier = imageIdentifier;
        }

        protected ImageDescriptor getDescriptor() {
            return JDTImageResolver.getDescriptor(this.fImageIdentifier);
        }

        public static ImageDescriptor getDescriptor(String imageIdentifier) {
            return JavaUI.getSharedImages().getImageDescriptor(imageIdentifier);
        }
    }
}

