/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.applications;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ease.IScriptEngine;
import org.eclipse.ease.ScriptResult;
import org.eclipse.ease.service.EngineDescription;
import org.eclipse.ease.service.ScriptService;
import org.eclipse.ease.service.ScriptType;
import org.eclipse.ease.tools.ResourceTools;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.osgi.service.datalocation.Location;

public class RunHeadlessScript
implements IApplication {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object start(IApplicationContext context) throws Exception {
        Object object = context.getArguments().get("application.args");
        if (object instanceof String[]) {
            Map<String, Object> parameters = RunHeadlessScript.extractInputParameters((String[])object);
            if (parameters != null) {
                if (parameters.containsKey("workspace")) {
                    Location location = Platform.getInstanceLocation();
                    URL workspaceURL = new File(parameters.get("workspace").toString()).toURL();
                    if (!location.isSet()) {
                        location.release();
                        location.set(workspaceURL, true);
                    } else if (!location.getURL().toString().equals(workspaceURL.toString())) {
                        System.err.println("WARNING: Could not set the workspace as it is already set to \"" + location.getURL() + "\"");
                    }
                }
                if (parameters.containsKey("script")) {
                    EngineDescription engineDescription = null;
                    ScriptService scriptService = ScriptService.getInstance();
                    if (parameters.containsKey("engine")) {
                        engineDescription = scriptService.getEngineByID(parameters.get("engine").toString());
                    } else {
                        ScriptType scriptType = scriptService.getScriptType(parameters.get("script").toString());
                        if (scriptType != null) {
                            engineDescription = scriptService.getEngine(scriptType.getName());
                        }
                    }
                    if (engineDescription != null) {
                        IScriptEngine engine = engineDescription.createEngine();
                        engine.setVariable("argv", ((List)parameters.get("args")).toArray(new String[0]));
                        Object scriptObject = ResourceTools.resolve(parameters.get("script"));
                        if (scriptObject == null) {
                            scriptObject = "include(\"" + parameters.get("script") + "\")";
                        }
                        ScriptResult scriptResult = engine.executeAsync(scriptObject);
                        engine.schedule();
                        ScriptResult scriptResult2 = scriptResult;
                        synchronized (scriptResult2) {
                            if (!scriptResult.isReady()) {
                                scriptResult.wait();
                            }
                        }
                        if (scriptResult.hasException()) {
                            return -1;
                        }
                        Object result = scriptResult.getResult();
                        if (result != null) {
                            try {
                                return Integer.parseInt(result.toString());
                            }
                            catch (Exception exception) {
                                try {
                                    return new Double(Double.parseDouble(result.toString())).intValue();
                                }
                                catch (Exception exception2) {
                                    try {
                                        return Boolean.parseBoolean(result.toString()) ? 0 : -1;
                                    }
                                    catch (Exception exception3) {
                                    }
                                }
                            }
                        } else {
                            return 0;
                        }
                    }
                }
                System.err.println("ERROR: Could not access file \"" + parameters.get("script") + "\"");
            } else {
                RunHeadlessScript.printUsage();
            }
        }
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static Map<String, Object> extractInputParameters(String[] arguments) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("args", new ArrayList());
        int index = 0;
        while (index < arguments.length) {
            if (parameters.containsKey("script")) {
                ((List)parameters.get("args")).add(arguments[index]);
            } else if ("-script".equals(arguments[index])) {
                if (index + 1 >= arguments.length) {
                    System.out.println("ERROR: script name is missing");
                    return null;
                }
                parameters.put("script", arguments[index + 1]);
                ((List)parameters.get("args")).add(arguments[index + 1]);
                ++index;
            } else if ("-workspace".equals(arguments[index])) {
                if (index + 1 >= arguments.length) {
                    System.out.println("ERROR: workspace location is missing");
                    return null;
                }
                parameters.put("workspace", arguments[index + 1]);
                ++index;
            } else if ("-engine".equals(arguments[index])) {
                if (index + 1 >= arguments.length) {
                    System.out.println("ERROR: workspace location is missing");
                    return null;
                }
                parameters.put("engine", arguments[index + 1]);
                ++index;
            } else {
                if ("-help".equals(arguments[index])) {
                    return null;
                }
                System.out.println("ERROR: invalid args (" + arguments[index] + ")");
                return null;
            }
            ++index;
        }
        return parameters;
    }

    private static void printUsage() {
        System.out.println("SYNTAX: [-workspace <workspace location>] [-engine <engineID>]-script <script name> <script parameters>");
        System.out.println("");
        System.out.println("\t\t<script name> is a path like 'file://C/myfolder/myscript.js'");
        System.out.println("\t\t<engineID> provides a dedicated script engine ID. Use org.eclipse.ease.listEngines application.");
        System.out.println("\t\t<workspace location> is a file system path like 'C:\\somefolder\\myworkspace'");
        System.out.println("\t\t\tif you provide a workspace you can use workspace:// identifiers in your scripts");
        System.out.println("\t\t<script parameters> will be passed to the script as String[] in the variable 'argv'");
    }

    public void stop() {
    }
}

