/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.modules.unittest.ui.handler;

import java.util.HashSet;
import java.util.LinkedList;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ease.modules.unittest.ITestSetFilter;
import org.eclipse.ease.modules.unittest.components.TestFile;
import org.eclipse.ease.modules.unittest.components.TestSuite;
import org.eclipse.ease.modules.unittest.ui.handler.RunAllTests;
import org.eclipse.ease.modules.unittest.ui.sourceprovider.TestSuiteSource;
import org.eclipse.ease.modules.unittest.ui.views.UnitTestView;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class RunSelectedTests
extends RunAllTests
implements IHandler {
    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            Object suite;
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().saveAllEditors(true);
            final HashSet<TestFile> testFiles = new HashSet<TestFile>();
            Object[] objectArray = ((IStructuredSelection)selection).toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkbenchPart part;
                Object element = objectArray[n2];
                if (element instanceof TestFile) {
                    testFiles.add((TestFile)element);
                } else if (element instanceof TestSuite) {
                    testFiles.addAll(((TestSuite)element).getChildren());
                } else if (element instanceof IPath && (part = HandlerUtil.getActivePart((ExecutionEvent)event)) instanceof UnitTestView) {
                    IContentProvider contentProvider = ((UnitTestView)part).getFileTreeViewer().getContentProvider();
                    LinkedList<Object> parentElements = new LinkedList<Object>();
                    parentElements.add(element);
                    while (!parentElements.isEmpty()) {
                        Object parent = parentElements.removeFirst();
                        Object[] objectArray2 = ((ITreeContentProvider)contentProvider).getChildren(parent);
                        int n3 = objectArray2.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            Object child = objectArray2[n4];
                            if (child instanceof TestFile) {
                                testFiles.add((TestFile)child);
                            } else {
                                parentElements.add(child);
                            }
                            ++n4;
                        }
                    }
                }
                ++n2;
            }
            TestSuiteSource instance = TestSuiteSource.getActiveInstance();
            if (instance != null && (suite = instance.getCurrentState().get("org.eclipse.ease.modules.unittest.ui.testsuite")) instanceof TestSuite) {
                this.updateSources((TestSuite)suite);
                ((TestSuite)suite).run(new ITestSetFilter(){

                    public boolean matches(TestFile set) {
                        return testFiles.contains(set);
                    }
                });
            }
        }
        return null;
    }
}

