/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.lang.python.jython.debugger;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.ease.ExitException;
import org.eclipse.ease.IExecutionListener;
import org.eclipse.ease.IScriptEngine;
import org.eclipse.ease.Script;
import org.eclipse.ease.debugging.AbstractScriptDebugger;
import org.eclipse.ease.debugging.IEventProcessor;
import org.eclipse.ease.debugging.IScriptDebugFrame;
import org.eclipse.ease.debugging.ScriptDebugFrame;
import org.eclipse.ease.debugging.events.IDebugEvent;
import org.eclipse.ease.debugging.events.TerminateRequest;
import org.eclipse.ease.lang.python.jython.debugger.JythonDebuggerEngine;
import org.python.core.Py;
import org.python.core.PyFrame;
import org.python.core.PyObject;

public class JythonDebugger
extends AbstractScriptDebugger
implements IEventProcessor,
IExecutionListener {
    private static final String PY_CMD_SET_DEBUGGER = "set_debugger";
    private static final String PY_CMD_RUN = "run";
    private PyObject fPythonStub;
    private final Map<String, Script> fScriptRegistry = new HashMap<String, Script>();

    public JythonDebugger(JythonDebuggerEngine engine, boolean showDynamicCode) {
        super((IScriptEngine)engine, showDynamicCode);
    }

    public void setupJythonObjects(PyObject pythonStub) {
        this.fPythonStub = pythonStub;
        this.fPythonStub.invoke(PY_CMD_SET_DEBUGGER, Py.java2py((Object)((Object)this)));
    }

    public void handleEvent(IDebugEvent event) {
        if (event instanceof TerminateRequest) {
            this.resume(8);
        } else {
            super.handleEvent(event);
        }
    }

    private static boolean isUserCode(PyFrame frame) {
        return frame.f_code.co_filename.startsWith("__ref_");
    }

    private List<IScriptDebugFrame> getStacktrace(PyFrame origin) {
        ArrayList<IScriptDebugFrame> trace = new ArrayList<IScriptDebugFrame>();
        PyFrame frame = origin;
        while (frame != null) {
            if (JythonDebugger.isUserCode(frame) && this.isTrackedScript(this.fScriptRegistry.get(frame.f_code.co_filename))) {
                trace.add(new JythonDebugFrame(frame));
            }
            frame = frame.f_back;
        }
        return trace;
    }

    public void traceDispatch(PyFrame frame, String type) {
        Script script;
        if (this.getResumeType() == 8) {
            throw new ExitException((Object)"Debug aborted by user");
        }
        if (JythonDebugger.isUserCode(frame) && this.isTrackedScript(script = this.fScriptRegistry.get(frame.f_code.co_filename))) {
            this.setStacktrace(this.getStacktrace(frame));
            if (frame.f_lineno != 0) {
                this.processLine(script, frame.f_lineno);
            }
        }
    }

    public Object execute(Script script) {
        this.fPythonStub.invoke(PY_CMD_RUN, Py.javas2pys((Object[])new Object[]{script, this.registerScript(script)}));
        return null;
    }

    private String registerScript(Script script) {
        String reference = JythonDebugger.getHash(script, this.fScriptRegistry.keySet());
        this.fScriptRegistry.put(reference, script);
        return reference;
    }

    private static String getHash(Script script, Set<String> existingKeys) {
        StringBuilder buffer = new StringBuilder("__ref_");
        buffer.append(script.isDynamic() ? "dyn" : script.getCommand().toString());
        buffer.append("_");
        int index = 0;
        while (index < 10) {
            buffer.append((char)(97 + new Random().nextInt(26)));
            ++index;
        }
        if (existingKeys.contains(buffer.toString())) {
            return JythonDebugger.getHash(script, existingKeys);
        }
        return buffer.toString();
    }

    public class JythonDebugFrame
    extends ScriptDebugFrame
    implements IScriptDebugFrame {
        public JythonDebugFrame(PyFrame frame) {
            super((Script)JythonDebugger.this.fScriptRegistry.get(frame.f_code.co_filename), frame.f_lineno, 1);
        }

        public String getName() {
            Script script = this.getScript();
            if (script.isDynamic()) {
                String title = this.getScript().getTitle();
                return title != null ? "Dynamic: " + title : "(Dynamic)";
            }
            Object command = this.getScript().getCommand();
            if (command != null) {
                if (command instanceof IFile) {
                    return ((IFile)command).getName();
                }
                if (command instanceof File) {
                    return ((File)command).getName();
                }
                return command.toString();
            }
            return "(unknown source)";
        }

        public Map<String, Object> getVariables() {
            return JythonDebugger.this.getEngine().getVariables();
        }
    }
}

