/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.lang.javascript.ui.completion;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ease.Logger;
import org.eclipse.ease.service.IScriptService;
import org.eclipse.ease.service.ScriptType;
import org.eclipse.ease.ui.completion.CodeCompletionAggregator;
import org.eclipse.ease.ui.completion.ScriptCompletionProposal;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.wst.jsdt.ui.text.java.ContentAssistInvocationContext;
import org.eclipse.wst.jsdt.ui.text.java.IJavaCompletionProposalComputer;

public class JavaScriptEditorCompletionComputer
implements IJavaCompletionProposalComputer {
    private final CodeCompletionAggregator fCompletionAggregator = new CodeCompletionAggregator();

    public JavaScriptEditorCompletionComputer() {
        IScriptService scriptService = (IScriptService)PlatformUI.getWorkbench().getService(IScriptService.class);
        ScriptType scriptType = (ScriptType)scriptService.getAvailableScriptTypes().get("JavaScript");
        this.fCompletionAggregator.setScriptType(scriptType);
        this.fCompletionAggregator.setCodeParser(scriptType.getCodeParser());
    }

    public List<ScriptCompletionProposal> computeCompletionProposals(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        IDocument document;
        if (context != null && (document = context.getDocument()) != null) {
            IEditorInput input;
            IFile resource = null;
            IWorkbenchPart activePart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
            if (activePart instanceof IEditorPart && (input = ((IEditorPart)activePart).getEditorInput()) instanceof FileEditorInput) {
                resource = ((FileEditorInput)input).getFile();
            }
            try {
                String relevantText = document.get(0, context.getInvocationOffset());
                int cursorPosition = context.getInvocationOffset();
                int selectionRange = context.getViewer().getSelectedRange().y;
                return this.fCompletionAggregator.getCompletionProposals((Object)resource, relevantText, cursorPosition, selectionRange, monitor);
            }
            catch (BadLocationException e) {
                Logger.error((String)"org.eclipse.ease.lang.javascript.ui", (String)"Failed to calculate proposals for JavaScript editor", (Throwable)e);
            }
        }
        return Collections.emptyList();
    }

    public List<IContextInformation> computeContextInformation(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        return Collections.emptyList();
    }

    public String getErrorMessage() {
        return null;
    }

    public void sessionEnded() {
    }

    public void sessionStarted() {
    }
}

