/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.debugging;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.ease.debugging.ScriptDebugElement;
import org.eclipse.ease.debugging.ScriptDebugStackFrame;
import org.eclipse.ease.debugging.ScriptDebugVariable;

public class ScriptDebugValue
extends ScriptDebugElement
implements IValue {
    private final ScriptDebugStackFrame fStackFrame;
    private final Object fValue;

    public ScriptDebugValue(ScriptDebugStackFrame stackFrame, Object value) {
        super(stackFrame.getDebugTarget());
        this.fStackFrame = stackFrame;
        this.fValue = value;
    }

    public boolean isTerminated() {
        return this.fStackFrame.isTerminated();
    }

    public boolean isSuspended() {
        return this.fStackFrame.isSuspended();
    }

    public boolean isStepping() {
        return this.fStackFrame.isStepping();
    }

    public String getReferenceTypeName() throws DebugException {
        return this.fValue != null ? this.fValue.getClass().getSimpleName() : "";
    }

    public String getValueString() throws DebugException {
        if (ScriptDebugValue.isSimpleType(this.fValue)) {
            return this.fValue + " (" + this.fValue.getClass().getSimpleName().toLowerCase() + ")";
        }
        return this.fValue != null ? this.fValue.getClass().getSimpleName() : "null";
    }

    public boolean isAllocated() throws DebugException {
        return this.fValue != null;
    }

    public IVariable[] getVariables() throws DebugException {
        ArrayList<ScriptDebugVariable> variables;
        block14: {
            block15: {
                block23: {
                    block22: {
                        block21: {
                            block20: {
                                block19: {
                                    block18: {
                                        block17: {
                                            block16: {
                                                variables = new ArrayList<ScriptDebugVariable>();
                                                if (this.fValue == null || ScriptDebugValue.isSimpleType(this.fValue)) break block14;
                                                if (!this.fValue.getClass().isArray()) break block15;
                                                if (!(this.fValue instanceof Object[])) break block16;
                                                int index = 0;
                                                while (index < ((Object[])this.fValue).length) {
                                                    variables.add(new ScriptDebugVariable(this.fStackFrame, "[" + index + "]", ((Object[])this.fValue)[index]));
                                                    ++index;
                                                }
                                                break block14;
                                            }
                                            if (!(this.fValue instanceof char[])) break block17;
                                            int index = 0;
                                            while (index < ((char[])this.fValue).length) {
                                                variables.add(new ScriptDebugVariable(this.fStackFrame, "[" + index + "]", Character.valueOf(((char[])this.fValue)[index])));
                                                ++index;
                                            }
                                            break block14;
                                        }
                                        if (!(this.fValue instanceof byte[])) break block18;
                                        int index = 0;
                                        while (index < ((byte[])this.fValue).length) {
                                            variables.add(new ScriptDebugVariable(this.fStackFrame, "[" + index + "]", ((byte[])this.fValue)[index]));
                                            ++index;
                                        }
                                        break block14;
                                    }
                                    if (!(this.fValue instanceof boolean[])) break block19;
                                    int index = 0;
                                    while (index < ((boolean[])this.fValue).length) {
                                        variables.add(new ScriptDebugVariable(this.fStackFrame, "[" + index + "]", ((boolean[])this.fValue)[index]));
                                        ++index;
                                    }
                                    break block14;
                                }
                                if (!(this.fValue instanceof short[])) break block20;
                                int index = 0;
                                while (index < ((short[])this.fValue).length) {
                                    variables.add(new ScriptDebugVariable(this.fStackFrame, "[" + index + "]", ((short[])this.fValue)[index]));
                                    ++index;
                                }
                                break block14;
                            }
                            if (!(this.fValue instanceof int[])) break block21;
                            int index = 0;
                            while (index < ((int[])this.fValue).length) {
                                variables.add(new ScriptDebugVariable(this.fStackFrame, "[" + index + "]", ((int[])this.fValue)[index]));
                                ++index;
                            }
                            break block14;
                        }
                        if (!(this.fValue instanceof long[])) break block22;
                        int index = 0;
                        while (index < ((long[])this.fValue).length) {
                            variables.add(new ScriptDebugVariable(this.fStackFrame, "[" + index + "]", ((long[])this.fValue)[index]));
                            ++index;
                        }
                        break block14;
                    }
                    if (!(this.fValue instanceof double[])) break block23;
                    int index = 0;
                    while (index < ((double[])this.fValue).length) {
                        variables.add(new ScriptDebugVariable(this.fStackFrame, "[" + index + "]", ((double[])this.fValue)[index]));
                        ++index;
                    }
                    break block14;
                }
                if (!(this.fValue instanceof float[])) break block14;
                int index = 0;
                while (index < ((float[])this.fValue).length) {
                    variables.add(new ScriptDebugVariable(this.fStackFrame, "[" + index + "]", Float.valueOf(((float[])this.fValue)[index])));
                    ++index;
                }
                break block14;
            }
            Field[] fieldArray = this.fValue.getClass().getDeclaredFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                try {
                    if (!Modifier.isStatic(field.getModifiers())) {
                        if (!field.isAccessible()) {
                            field.setAccessible(true);
                        }
                        variables.add(new ScriptDebugVariable(this.fStackFrame, field.getName(), field.get(this.fValue)));
                    }
                }
                catch (Exception exception) {}
                ++n2;
            }
        }
        return variables.toArray(new IVariable[variables.size()]);
    }

    public boolean hasVariables() throws DebugException {
        return this.getVariables().length > 0;
    }

    public Object getAdapter(Class adapter) {
        if (String.class.equals((Object)adapter)) {
            return this.fValue != null ? this.fValue.toString() : "";
        }
        return super.getAdapter(adapter);
    }

    public Object getValue() {
        return this.fValue;
    }

    private static boolean isSimpleType(Object value) {
        return value instanceof Integer || value instanceof Byte || value instanceof Short || value instanceof Boolean || value instanceof Character || value instanceof Long || value instanceof Double || value instanceof Float;
    }
}

