/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.ease.BreakException;
import org.eclipse.ease.ExitException;
import org.eclipse.ease.FileTrace;
import org.eclipse.ease.IExecutionListener;
import org.eclipse.ease.IScriptEngine;
import org.eclipse.ease.IScriptEngineLaunchExtension;
import org.eclipse.ease.Script;
import org.eclipse.ease.ScriptResult;
import org.eclipse.ease.debug.ITracingConstant;
import org.eclipse.ease.debug.Tracer;
import org.eclipse.ease.service.EngineDescription;
import org.eclipse.ease.service.IScriptService;
import org.eclipse.ui.PlatformUI;
import org.osgi.service.prefs.Preferences;

public abstract class AbstractScriptEngine
extends Job
implements IScriptEngine {
    private final List<Script> fCodePieces = Collections.synchronizedList(new ArrayList());
    private final ListenerList fExecutionListeners = new ListenerList();
    private boolean fTerminateOnIdle = true;
    private PrintStream fOutputStream = null;
    private PrintStream fErrorStream = null;
    private InputStream fInputStream = null;
    private FileTrace fFileTrace = new FileTrace();
    private EngineDescription fDescription;
    private boolean fSetupDone = false;
    private final Map<String, Object> fBufferedVariables = new HashMap<String, Object>();
    private boolean fCloseStreamsOnTerminate;

    public AbstractScriptEngine(String name) {
        super(name);
        this.setSystem(true);
    }

    @Override
    public EngineDescription getDescription() {
        return this.fDescription;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ScriptResult executeAsync(Object content) {
        Script piece = content instanceof Script ? (Script)content : new Script(content);
        this.fCodePieces.add(piece);
        AbstractScriptEngine abstractScriptEngine = this;
        synchronized (abstractScriptEngine) {
            this.notifyAll();
        }
        return piece.getResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ScriptResult executeSync(Object content) throws InterruptedException {
        ScriptResult result;
        if (this.getState() == 0) {
            throw new RuntimeException("Engine is not started yet, cannot run code");
        }
        ScriptResult scriptResult = result = this.executeAsync(content);
        synchronized (scriptResult) {
            while (!result.isReady()) {
                result.wait();
            }
        }
        return result;
    }

    @Override
    public final Object inject(Object content) {
        return this.internalInject(content, false);
    }

    @Override
    public final Object injectUI(Object content) {
        Preferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.ease").node("scripts");
        boolean allowUIAccess = prefs.getBoolean("scriptUIAccess", false);
        if (!allowUIAccess) {
            throw new RuntimeException("Script UI access disabled by user preferences.");
        }
        return this.internalInject(content, true);
    }

    private final Object internalInject(Object content, boolean uiThread) {
        ScriptResult result = content instanceof Script ? this.inject((Script)content, false, uiThread) : this.inject(new Script(content), false, uiThread);
        if (result.hasException()) {
            if (result.getException() instanceof RuntimeException) {
                throw (RuntimeException)result.getException();
            }
            throw new RuntimeException(result.getException().getMessage(), result.getException());
        }
        return result.getResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private ScriptResult inject(Script script, boolean notifyListeners, boolean uiThread) {
        ScriptResult scriptResult = script.getResult();
        synchronized (scriptResult) {
            block23: {
                try {
                    if (ITracingConstant.MODULE_WRAPPER_TRACING) {
                        Tracer.logInfo("Executing (" + script.getTitle() + "):\n" + script.getCode());
                    }
                    this.fFileTrace.push(script.getFile());
                    if (notifyListeners) {
                        this.notifyExecutionListeners(script, 3);
                    } else {
                        this.notifyExecutionListeners(script, 5);
                    }
                    script.setResult(this.execute(script, script.getFile(), this.fFileTrace.peek().getFileName(), uiThread));
                }
                catch (ExitException e) {
                    script.setResult(e.getCondition());
                    if (notifyListeners) {
                        this.notifyExecutionListeners(script, 4);
                    } else {
                        this.notifyExecutionListeners(script, 6);
                    }
                    this.fFileTrace.pop();
                    break block23;
                }
                catch (BreakException e) {
                    script.setResult(e.getCondition());
                    break block23;
                }
                catch (Exception e) {
                    script.setException(e);
                    e.printStackTrace(this.getErrorStream());
                    if (notifyListeners) {
                        this.notifyExecutionListeners(script, 4);
                    } else {
                        this.notifyExecutionListeners(script, 6);
                    }
                    this.fFileTrace.pop();
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                    break block23;
                }
                {
                    finally {
                        if (notifyListeners) {
                            this.notifyExecutionListeners(script, 4);
                        } else {
                            this.notifyExecutionListeners(script, 6);
                        }
                        this.fFileTrace.pop();
                    }
                }
                if (notifyListeners) {
                    this.notifyExecutionListeners(script, 4);
                } else {
                    this.notifyExecutionListeners(script, 6);
                }
                this.fFileTrace.pop();
            }
        }
        return script.getResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus run(IProgressMonitor monitor) {
        if (this.setupEngine()) {
            Object object;
            this.fSetupDone = true;
            for (String name : this.fBufferedVariables.keySet()) {
                this.setVariable(name, this.fBufferedVariables.get(name));
            }
            this.fBufferedVariables.clear();
            this.fFileTrace = new FileTrace();
            this.notifyExecutionListeners(null, 1);
            while (!monitor.isCanceled() && !this.isTerminated()) {
                if (!this.fCodePieces.isEmpty()) {
                    Script piece = this.fCodePieces.remove(0);
                    this.inject(piece, true, false);
                    continue;
                }
                object = this;
                synchronized (object) {
                    if (!this.isTerminated()) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
            object = this.fCodePieces;
            synchronized (object) {
                for (Script script : this.fCodePieces) {
                    script.setException(new ExitException());
                }
            }
            this.fCodePieces.clear();
            this.notifyExecutionListeners(null, 2);
            this.teardownEngine();
        }
        this.closeStreams();
        if (this.isTerminated()) {
            return Status.OK_STATUS;
        }
        return Status.CANCEL_STATUS;
    }

    private void closeStreams() {
        if (this.fCloseStreamsOnTerminate) {
            try {
                if (this.getInputStream() != null && !System.in.equals(this.getInputStream())) {
                    this.getInputStream().close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (this.getOutputStream() != null && !System.out.equals(this.getOutputStream())) {
                    this.getOutputStream().close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.getErrorStream() != null && !System.err.equals(this.getErrorStream())) {
                    this.getErrorStream().close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void setCloseStreamsOnTerminate(boolean closeStreams) {
        this.fCloseStreamsOnTerminate = closeStreams;
    }

    @Override
    public PrintStream getOutputStream() {
        return this.fOutputStream != null ? this.fOutputStream : System.out;
    }

    @Override
    public void setOutputStream(OutputStream outputStream) {
        this.fOutputStream = outputStream instanceof PrintStream ? (PrintStream)outputStream : new PrintStream(outputStream);
    }

    @Override
    public InputStream getInputStream() {
        return this.fInputStream != null ? this.fInputStream : System.in;
    }

    @Override
    public void setInputStream(InputStream inputStream) {
        this.fInputStream = inputStream;
    }

    @Override
    public PrintStream getErrorStream() {
        return this.fErrorStream != null ? this.fErrorStream : System.err;
    }

    @Override
    public void setErrorStream(OutputStream errorStream) {
        this.fErrorStream = errorStream instanceof PrintStream ? (PrintStream)errorStream : new PrintStream(errorStream);
    }

    @Override
    public final void setTerminateOnIdle(boolean terminate) {
        this.fTerminateOnIdle = terminate;
    }

    @Override
    public boolean getTerminateOnIdle() {
        return this.fTerminateOnIdle;
    }

    private boolean isTerminated() {
        return this.fTerminateOnIdle && this.fCodePieces.isEmpty();
    }

    @Override
    public boolean isIdle() {
        return this.fCodePieces.isEmpty();
    }

    @Override
    public void addExecutionListener(IExecutionListener listener) {
        this.fExecutionListeners.add((Object)listener);
    }

    @Override
    public void removeExecutionListener(IExecutionListener listener) {
        this.fExecutionListeners.remove((Object)listener);
    }

    protected void notifyExecutionListeners(Script script, int status) {
        Object[] objectArray = this.fExecutionListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IExecutionListener)listener).notify(this, script, status);
            ++n2;
        }
    }

    @Override
    public void terminate() {
        this.setTerminateOnIdle(true);
        this.fCodePieces.clear();
        this.terminateCurrent();
        this.cancel();
        if (this.getThread() != null) {
            this.getThread().interrupt();
        }
    }

    @Override
    public void reset() {
        for (Script script : this.fCodePieces) {
            script.setException(new ExitException((Object)"Script engine got resetted."));
        }
        this.fCodePieces.clear();
        IScriptService scriptService = (IScriptService)PlatformUI.getWorkbench().getService(IScriptService.class);
        for (IScriptEngineLaunchExtension extension : scriptService.getLaunchExtensions(this.getDescription().getID())) {
            extension.createEngine(this);
        }
    }

    @Override
    public FileTrace getFileTrace() {
        return this.fFileTrace;
    }

    @Override
    public Object getExecutedFile() {
        for (FileTrace.Trace trace : this.getFileTrace()) {
            Object file = trace.getFile();
            if (file == null) continue;
            return file;
        }
        return null;
    }

    public void setEngineDescription(EngineDescription description) {
        this.fDescription = description;
    }

    @Override
    public void setVariable(String name, Object content) {
        if (this.fSetupDone) {
            this.internalSetVariable(name, content);
        } else {
            this.fBufferedVariables.put(name, content);
        }
    }

    @Override
    public Object getVariable(String name) {
        if (this.fSetupDone) {
            return this.internalGetVariable(name);
        }
        throw new RuntimeException("Cannot retrieve variable, engine not initialized");
    }

    @Override
    public boolean hasVariable(String name) {
        if (this.fSetupDone) {
            return this.internalHasVariable(name);
        }
        return this.fBufferedVariables.containsKey(name);
    }

    @Override
    public Object removeVariable(String name) {
        if (this.fSetupDone) {
            return this.internalRemoveVariable(name);
        }
        return this.fBufferedVariables.remove(name);
    }

    @Override
    public Map<String, Object> getVariables() {
        if (this.fSetupDone) {
            return this.internalGetVariables();
        }
        return Collections.unmodifiableMap(this.fBufferedVariables);
    }

    public static final String[] extractArguments(String arguments) {
        ArrayList<String> args = new ArrayList<String>();
        if (arguments != null) {
            int index = 0;
            while (index < arguments.length()) {
                int endIndex = arguments.indexOf(arguments.charAt(index) == '\"' ? 34 : 32, index + 1);
                if (endIndex > index) {
                    args.add(arguments.substring(index + 1, endIndex));
                    index = endIndex + 2;
                    continue;
                }
                args.add(arguments.substring(index + 1));
                index = arguments.length();
            }
        }
        return args.toArray(new String[args.size()]);
    }

    protected abstract Object internalGetVariable(String var1);

    protected abstract Map<String, Object> internalGetVariables();

    protected abstract boolean internalHasVariable(String var1);

    protected abstract void internalSetVariable(String var1, Object var2);

    protected abstract Object internalRemoveVariable(String var1);

    protected abstract boolean setupEngine();

    protected abstract boolean teardownEngine();

    protected abstract Object execute(Script var1, Object var2, String var3, boolean var4) throws Exception;
}

