/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.ui.log;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.diffmerge.api.IComparison;
import org.eclipse.emf.diffmerge.api.IMatch;
import org.eclipse.emf.diffmerge.api.Role;
import org.eclipse.emf.diffmerge.api.diff.IDifference;
import org.eclipse.emf.diffmerge.api.diff.IElementRelativeDifference;
import org.eclipse.emf.diffmerge.api.diff.IReferenceValuePresence;
import org.eclipse.emf.diffmerge.ui.log.AbstractLogEvent;
import org.eclipse.emf.diffmerge.ui.log.DiffMergeLogger;
import org.eclipse.emf.diffmerge.ui.util.DiffMergeLabelProvider;
import org.eclipse.emf.diffmerge.util.structures.FArrayList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergeLogEvent
extends AbstractLogEvent {
    private final EditingDomain _domain;
    private final List<IDifference> _diffs;
    private final boolean _mergeToLeft;

    public MergeLogEvent(EditingDomain domain_p, IDifference diff_p, boolean mergeToLeft_p) {
        this(domain_p, diff_p.getComparison(), Collections.singletonList(diff_p), mergeToLeft_p);
    }

    public MergeLogEvent(EditingDomain domain_p, IComparison comparison_p, Collection<? extends IDifference> diffs_p, boolean mergeToLeft_p) {
        super(comparison_p);
        this._domain = domain_p;
        this._mergeToLeft = mergeToLeft_p;
        this._diffs = new FArrayList(diffs_p, null);
    }

    public List<IDifference> getDifferences() {
        return Collections.unmodifiableList(this._diffs);
    }

    @Override
    public String getRepresentation() {
        StringBuilder builder = new StringBuilder();
        Role destination = this.isToLeft() ? Role.TARGET : Role.REFERENCE;
        String destinationName = this.isToLeft() ? "Left" : "Right";
        for (IDifference difference : this.getDifferences()) {
            IMatch match;
            builder.append(DiffMergeLogger.LINE_SEP);
            if (difference instanceof IElementRelativeDifference && (match = difference instanceof IReferenceValuePresence && !((IReferenceValuePresence)difference).isOrder() && ((IReferenceValuePresence)difference).getFeature() != null && ((IReferenceValuePresence)difference).getFeature().isContainment() ? ((IReferenceValuePresence)difference).getValue() : ((IElementRelativeDifference)difference).getElementMatch()) != null) {
                EObject location = this.getNonNull(match, destination);
                String type = location.eClass().getName();
                String name = DiffMergeLabelProvider.getInstance().getMatchText(match, destination, this._domain);
                String id = this.getID(location);
                builder.append('[');
                builder.append(destinationName);
                builder.append(']');
                builder.append(' ');
                builder.append(type);
                builder.append(' ');
                builder.append('\'');
                builder.append(name);
                builder.append('\'');
                builder.append("  (ID:");
                builder.append(id);
                builder.append(')');
                builder.append(DiffMergeLogger.LINE_SEP);
            }
            String msg = DiffMergeLabelProvider.getInstance().getDifferenceText(difference, destination, this._domain);
            DiffMergeLogger.appendAtLevel(builder, 1, msg);
        }
        return builder.toString();
    }

    public boolean isToLeft() {
        return this._mergeToLeft;
    }
}

