/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.result.internal.preference;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.datatools.help.ContextProviderDelegate;
import org.eclipse.datatools.help.HelpUtil;
import org.eclipse.datatools.sqltools.result.internal.ui.AbstractShiftedListSection;
import org.eclipse.datatools.sqltools.result.internal.ui.Messages;
import org.eclipse.datatools.sqltools.result.internal.ui.PreferenceConstants;
import org.eclipse.datatools.sqltools.result.internal.ui.view.ResultHistoryHelper;
import org.eclipse.datatools.sqltools.result.ui.ResultsViewUIPlugin;
import org.eclipse.help.IContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class ResultHistoryPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private String[] _initVisibleColumns;
    private String[] _initInvisibleColumns;
    private AbstractShiftedListSection _shiftedListSection;
    private Composite _otherComp;
    private Button _autoSaveHistory;
    private Button _autoCleanHistory;
    private ContextProviderDelegate contextProviderDelegate = new ContextProviderDelegate(ResultsViewUIPlugin.getDefault().getBundle().getSymbolicName());

    public IContext getContext(Object target) {
        return this.contextProviderDelegate.getContext(target);
    }

    public int getContextChangeMask() {
        return this.contextProviderDelegate.getContextChangeMask();
    }

    public String getSearchExpression(Object target) {
        return this.contextProviderDelegate.getSearchExpression(target);
    }

    protected Control createContents(Composite parent) {
        this.getShell().setData(HelpUtil.CONTEXT_PROVIDER_KEY, (Object)this);
        HelpUtil.setHelp((Control)parent, (String)HelpUtil.getContextId((String)"preference_page_result_history", (String)ResultsViewUIPlugin.getDefault().getBundle().getSymbolicName()));
        Composite comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        comp.setLayout((Layout)layout);
        this.initShiftedListValues(true);
        this._shiftedListSection = new ColumnsDisplaySection(Messages.ResultHistoryPage_columns_group_name, Messages.ResultHistoryPage_columns_selectedlist_name, Messages.ResultHistoryPage_columns_availablelist_name);
        this._shiftedListSection.createContents(comp);
        this._otherComp = new Composite(comp, 0);
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this._otherComp.setLayout((Layout)layout);
        this._otherComp.setLayoutData((Object)new GridData(768));
        this._autoSaveHistory = new Button(this._otherComp, 32);
        this._autoSaveHistory.setText(Messages.ResultHistoryPage_auto_persist);
        this._autoSaveHistory.setToolTipText(Messages.ResultHistoryPage_tooltip_auto_persist);
        this._autoCleanHistory = new Button(this._otherComp, 32);
        this._autoCleanHistory.setText(Messages.ResultHistoryPage_auto_clean);
        this._autoCleanHistory.setToolTipText(Messages.ResultHistoryPage_tooltip_auto_clean);
        this.initializeValues();
        return comp;
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(ResultsViewUIPlugin.getDefault().getPreferenceStore());
    }

    private void initializeValues() {
        IPreferenceStore store = this.getPreferenceStore();
        this._autoSaveHistory.setSelection(store.getBoolean(PreferenceConstants.RESULT_HISTORY_SAVE_HISTORY));
        this._autoCleanHistory.setSelection(store.getBoolean(PreferenceConstants.RESULT_HISTORY_CLEAN_HISTORY));
    }

    private void initShiftedListValues(boolean usePreference) {
        ResultHistoryHelper.refreshOrderFromPreference(usePreference);
        int len = ResultHistoryHelper.getColumnNumber(usePreference);
        this._initVisibleColumns = new String[len];
        this._initInvisibleColumns = new String[ResultHistoryHelper.COLUMN_NAME.length - len];
        for (Object prefName : ResultHistoryHelper.COLUMN_PREFERENCE_ORDER_MAP.keySet()) {
            int index = (Integer)ResultHistoryHelper.COLUMN_PREFERENCE_ORDER_MAP.get(prefName);
            if (index < 0) continue;
            for (Object columnName : ResultHistoryHelper.COLUMN_NAME_PREFERENCE_MAP.keySet()) {
                if (!ResultHistoryHelper.COLUMN_NAME_PREFERENCE_MAP.get(columnName).equals(prefName)) continue;
                this._initVisibleColumns[index] = (String)columnName;
            }
        }
        List<String> visibleList = Arrays.asList(this._initVisibleColumns);
        ArrayList<String> invisibleList = new ArrayList<String>(Arrays.asList(ResultHistoryHelper.COLUMN_NAME));
        invisibleList.removeAll(visibleList);
        invisibleList.toArray(this._initInvisibleColumns);
    }

    protected void performDefaults() {
        this.initShiftedListValues(false);
        this._shiftedListSection.setInput(this._initVisibleColumns, this._initInvisibleColumns, true);
        IPreferenceStore store = this.getPreferenceStore();
        this._autoSaveHistory.setSelection(store.getDefaultBoolean(PreferenceConstants.RESULT_HISTORY_SAVE_HISTORY));
        this._autoCleanHistory.setSelection(store.getDefaultBoolean(PreferenceConstants.RESULT_HISTORY_CLEAN_HISTORY));
        super.performDefaults();
    }

    public boolean performOk() {
        IPreferenceStore store = this.getPreferenceStore();
        Map columnNameOrderMap = ((ColumnsDisplaySection)this._shiftedListSection).getCloumnsDisplayInfo();
        for (Object columnName : columnNameOrderMap.keySet()) {
            Object preference = ResultHistoryHelper.COLUMN_NAME_PREFERENCE_MAP.get(columnName);
            Object order = columnNameOrderMap.get(columnName);
            store.setValue((String)preference, ((Integer)order).intValue());
        }
        store.setValue(PreferenceConstants.RESULT_HISTORY_ALL_COLUMNS, !store.getBoolean(PreferenceConstants.RESULT_HISTORY_ALL_COLUMNS));
        store.setValue(PreferenceConstants.RESULT_HISTORY_SAVE_HISTORY, this._autoSaveHistory.getSelection());
        store.setValue(PreferenceConstants.RESULT_HISTORY_CLEAN_HISTORY, this._autoCleanHistory.getSelection());
        return super.performOk();
    }

    class ColumnsDisplaySection
    extends AbstractShiftedListSection {
        PaintListener paintListener;

        public ColumnsDisplaySection(String sectionTitle, String leftTitle, String rightTitle) {
            super(sectionTitle, leftTitle, rightTitle);
            this.paintListener = new PaintListener(){

                public void paintControl(PaintEvent e) {
                    if (ColumnsDisplaySection.this._leftList.getItems().length < 1) {
                        ResultHistoryPage.this.setErrorMessage(Messages.ResultHistoryPage_no_column_selected);
                        ResultHistoryPage.this.setValid(false);
                        ResultHistoryPage.this.updateApplyButton();
                    } else {
                        ResultHistoryPage.this.setErrorMessage(null);
                        ResultHistoryPage.this.setValid(true);
                        ResultHistoryPage.this.updateApplyButton();
                    }
                }
            };
        }

        public Control createContents(Composite parent) {
            Control control = super.createContents(parent);
            this._leftList.addPaintListener(this.paintListener);
            this.setInput(ResultHistoryPage.this._initVisibleColumns, ResultHistoryPage.this._initInvisibleColumns, true);
            return control;
        }

        Map getCloumnsDisplayInfo() {
            HashMap<String, Object> result = new HashMap<String, Object>();
            String name = "";
            String[] items = this._leftList.getItems();
            int i = 0;
            while (i < items.length) {
                name = items[i];
                result.put(name, this._leftList.getData(name));
                ++i;
            }
            items = this._rightList.getItems();
            i = 0;
            while (i < items.length) {
                name = items[i];
                result.put(name, this._rightList.getData(name));
                ++i;
            }
            return result;
        }
    }
}

