/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.design;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum TextWrapType implements Enumerator
{
    NONE_LITERAL(0, "None", "None"),
    WORD_LITERAL(1, "Word", "Word");

    public static final String copyright = "Copyright (c) 2005, 2009 Actuate Corporation";
    public static final int NONE = 0;
    public static final int WORD = 1;
    private static final TextWrapType[] VALUES_ARRAY;
    public static final List<TextWrapType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new TextWrapType[]{NONE_LITERAL, WORD_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static TextWrapType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TextWrapType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TextWrapType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TextWrapType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TextWrapType get(int value) {
        switch (value) {
            case 0: {
                return NONE_LITERAL;
            }
            case 1: {
                return WORD_LITERAL;
            }
        }
        return null;
    }

    private TextWrapType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

