/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.data.internal.ui.editor;

import org.eclipse.datatools.connectivity.sqm.core.internal.ui.explorer.popup.AbstractAction;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.datatools.sqltools.data.internal.core.editor.ITableEditorResultFilter;
import org.eclipse.datatools.sqltools.data.internal.core.editor.TableEditorFilterRegistryReader;
import org.eclipse.datatools.sqltools.data.internal.ui.DataUIPlugin;
import org.eclipse.datatools.sqltools.data.internal.ui.editor.Messages;
import org.eclipse.datatools.sqltools.data.internal.ui.editor.TableDataEditorInput;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class EditTableDataAction
extends AbstractAction {
    private static final String TEXT = Messages.getString("TableDataEditMenu");
    protected Table table = null;

    protected void initialize() {
        this.initializeAction(null, null, TEXT, TEXT);
    }

    public void run() {
        ITableEditorResultFilter filterExecutable;
        if (this.table == null) {
            return;
        }
        boolean keepGoing = true;
        TableEditorFilterRegistryReader filterReader = TableEditorFilterRegistryReader.getInstance();
        if (filterReader.isExtenionFound() && filterReader.isMatchingVendor(this.table) && (filterExecutable = filterReader.createTableEditorResultFilterExecutable()).isUseExternalFilterDialog()) {
            filterExecutable.setTable(this.table);
            keepGoing = filterExecutable.open();
            filterReader.setFilterCanceled(!keepGoing);
        }
        if (keepGoing) {
            IWorkbenchPage workbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            try {
                workbenchPage.openEditor((IEditorInput)new TableDataEditorInput(this.table), this.getEditorId());
            }
            catch (PartInitException e) {
                DataUIPlugin.getDefault().writeLog(4, 0, e.getMessage(), e);
            }
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.table = null;
        if (event.getSelection() instanceof IStructuredSelection && ((IStructuredSelection)event.getSelection()).getFirstElement() instanceof Table) {
            this.table = (Table)((IStructuredSelection)event.getSelection()).getFirstElement();
        }
        boolean b = true;
        b &= this.table != null && this.table.getColumns().size() > 0;
        this.setEnabled(b &= DataUIPlugin.isGroupIDOK((EObject)this.table));
    }

    protected String getEditorId() {
        return "org.eclipse.datatools.sqltools.data.internal.ui.editor.tableDataEditor";
    }
}

