/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.plan.treeplan;

import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.datatools.sqltools.plan.AbstractPlanDrawer;
import org.eclipse.datatools.sqltools.plan.IExecutionPlanDocument;
import org.eclipse.datatools.sqltools.plan.internal.PlanViewPlugin;
import org.eclipse.datatools.sqltools.plan.internal.util.Images;
import org.eclipse.datatools.sqltools.plan.treeplan.TreeExecutionPlanDocument;
import org.eclipse.datatools.sqltools.plan.treeplan.TreePlanNodeComponent;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.Panel;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.ScrollPane;
import org.eclipse.draw2d.SimpleLoweredBorder;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.text.FlowPage;
import org.eclipse.draw2d.text.TextFlow;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Canvas;

public class TreePlanDrawer
extends AbstractPlanDrawer {
    private IExecutionPlanDocument _planDoc;
    private static final int WIDTH = 100;
    private static final int HEIGHT = 35;
    private static final int BIG_HEIGHT = 50;
    private static final int HORIZONTAL_SPACE = 15;
    private static final int VERTICAL_SPACE = 25;
    private ArrayList _nodePainted = new ArrayList();
    private HashMap _node2Plan = new HashMap();
    private int _maxNodes = 1;
    private IFigure _last;
    private int _maxWidth;
    private int _maxHeight;
    private String _htmlStart = "<html><body>";
    private String _htmlEnd = "</body></html>";
    private static final String HTML_FILE_NAME = "query_plan.html";
    private String _canvasTip = "";
    private Font _objFont = new Font(null, "Arial", 10, 1);

    public TreePlanDrawer() {
    }

    public TreePlanDrawer(Canvas canvas, Browser browser) {
        super(canvas, browser);
    }

    public void init() {
        this._lws = new LightweightSystem(this._canvas);
        this._canvas.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (TreePlanDrawer.this._objFont != null && !TreePlanDrawer.this._objFont.isDisposed()) {
                    TreePlanDrawer.this._objFont.dispose();
                }
            }
        });
    }

    private Figure createNodeFigure(TreePlanNodeComponent plan, int levelStart, int y, int level) {
        if (this._nodePainted.size() <= level) {
            this._nodePainted.add(new Integer(1));
        } else {
            this._nodePainted.set(level, new Integer((Integer)this._nodePainted.get(level) + 1));
        }
        int x = ((Integer)this._nodePainted.get(level) - 1) * 115 + levelStart;
        CompartmentFigure node1 = new CompartmentFigure(plan.getName(), plan.getLabel1(), plan.isLabel1Highlighted(), plan.getLabel2(), plan.isLabel2Highlighted());
        FlowPage page = new FlowPage();
        page.setBorder((Border)new MarginBorder(5, 5, 5, 5));
        String tooltip = plan.getToolTip();
        page.add((IFigure)new TextFlow(tooltip));
        node1.setToolTip((IFigure)page);
        node1.addMouseMotionListener(new MouseMotionListener(){

            public void mouseDragged(MouseEvent me) {
            }

            public void mouseEntered(MouseEvent me) {
                TreePlanDrawer.this._canvas.setToolTipText("");
            }

            public void mouseExited(MouseEvent me) {
                TreePlanDrawer.this._canvas.setToolTipText(TreePlanDrawer.this._canvasTip);
            }

            public void mouseHover(MouseEvent me) {
            }

            public void mouseMoved(MouseEvent me) {
            }
        });
        this._node2Plan.put(node1, plan);
        node1.setLocation(new Point(x, y));
        if (node1.getChildren().size() == 2) {
            node1.setSize(100, 35);
        } else {
            node1.setSize(100, 50);
        }
        node1.setEnabled(true);
        new Dragger((IFigure)node1);
        return node1;
    }

    private void paintChildNodes(TreeExecutionPlanDocument planDoc, TreePlanNodeComponent parentNode, IFigure parentFigure, IFigure panel, int y, int level) {
        int count = planDoc.getWidth(level + 1);
        int width = count * 100 + (count - 1) * 15;
        int nextHeight = y + 35 + 25;
        this._maxHeight = this._maxHeight >= nextHeight ? this._maxHeight : nextHeight;
        int i = 0;
        while (i < parentNode.getChildrenCount()) {
            TreePlanNodeComponent plan = parentNode.getChild(i);
            Figure node1 = this.createNodeFigure(plan, (this._maxWidth - width) / 2, y, level + 1);
            PolylineConnection conn = new PolylineConnection();
            conn.setSourceAnchor((ConnectionAnchor)new ChopboxAnchor(parentFigure));
            conn.setTargetAnchor((ConnectionAnchor)new ChopboxAnchor((IFigure)node1));
            conn.setTargetDecoration((RotatableDecoration)new PolygonDecoration());
            panel.add((IFigure)node1);
            panel.add((IFigure)conn);
            this.paintChildNodes(planDoc, plan, (IFigure)node1, panel, nextHeight, level + 1);
            ++i;
        }
    }

    private void selectFigure(IFigure f) {
        if (this._node2Plan.get(f) != null && this._last != f) {
            CompartmentFigure figure;
            if (this._last != null) {
                figure = (CompartmentFigure)this._last;
                figure.getNameLabel().setIcon(null);
                figure.getNameLabel().setText(" " + figure.getNameLabel().getText());
                this._last.setBackgroundColor(ColorConstants.menuBackground);
                this._last.setForegroundColor(ColorConstants.black);
            }
            f.setBackgroundColor(ColorConstants.lightBlue);
            figure = (CompartmentFigure)f;
            figure.getNameLabel().setIcon(Images.get("org.eclipse.datatools.sqltools.resultcurrent_operator.gif"));
            figure.getNameLabel().setText(figure.getNameLabel().getText().trim());
            this._last = f;
            String planFileStr = PlanViewPlugin.getDefault().getStateLocation().append(HTML_FILE_NAME).toOSString();
            File planFile = new File(planFileStr);
            String content = String.valueOf(this._htmlStart) + ((TreePlanNodeComponent)this._node2Plan.get(f)).getDetail() + this._htmlEnd;
            if (planFile.exists()) {
                planFile.delete();
            }
            try {
                planFile.createNewFile();
                FileOutputStream fos = new FileOutputStream(planFile);
                fos.write(content.getBytes());
                this._browser.setUrl("file:///" + planFileStr);
            }
            catch (Exception exception) {
                this._browser.setText(content);
            }
        }
    }

    private void draw() {
        this._canvasTip = this._canvas.getToolTipText();
        this._node2Plan.clear();
        TreeExecutionPlanDocument treeModel = (TreeExecutionPlanDocument)this._planDoc;
        this._lws.getRootFigure().erase();
        ScrollPane scroll = new ScrollPane();
        Panel panel = new Panel();
        panel.setBackgroundColor(ColorConstants.white);
        scroll.setContents((IFigure)panel);
        scroll.setBorder((Border)new SimpleLoweredBorder());
        this._lws.setContents((IFigure)scroll);
        this._maxNodes = treeModel.getMaxWidth();
        this._maxWidth = this._maxNodes * 100 + (this._maxNodes + 1) * 15;
        this._maxHeight = 0;
        this._nodePainted = new ArrayList();
        Figure node1 = this.createNodeFigure(treeModel.getRootNode(), (this._maxWidth - 100) / 2, 25, 0);
        this.selectFigure((IFigure)node1);
        panel.add((IFigure)node1);
        this.paintChildNodes(treeModel, treeModel.getRootNode(), (IFigure)node1, (IFigure)panel, 85, 0);
        panel.setSize(new Dimension(this._maxWidth, this._maxHeight - 35 - 25));
        scroll.revalidate();
    }

    public void drawPlan(IExecutionPlanDocument planDoc) {
        this._planDoc = planDoc;
        this.draw();
    }

    class CompartmentFigure
    extends Figure {
        private Label _nameLabel;
        private Label _label1;
        private Label _label2;

        public CompartmentFigure(String name, String label1, boolean isLabel1Highlighted, String label2, boolean isLabel2Highlighted) {
            ToolbarLayout layout = new ToolbarLayout();
            layout.setMinorAlignment(1);
            layout.setStretchMinorAxis(false);
            layout.setSpacing(2);
            this.setBorder((Border)new LineBorder(ColorConstants.black, 1));
            this.setLayoutManager((LayoutManager)layout);
            this.setBackgroundColor(ColorConstants.menuBackground);
            this.setOpaque(true);
            this._nameLabel = new Label(" " + name);
            this.add((IFigure)this._nameLabel);
            if (label1 != null && label1.trim().length() != 0) {
                this._label1 = new Label(" " + label1);
                if (isLabel1Highlighted) {
                    this._label1.setFont(TreePlanDrawer.this._objFont);
                    this._label1.setForegroundColor(ColorConstants.blue);
                }
                this.add((IFigure)this._label1);
            }
            if (label2 != null && label2.trim().length() != 0) {
                this._label2 = new Label(" " + label2);
                if (isLabel2Highlighted) {
                    Font objFont = new Font(null, "Arial", 10, 1);
                    this._label2.setFont(objFont);
                    this._label2.setForegroundColor(ColorConstants.blue);
                }
                this.add((IFigure)this._label2);
            }
        }

        public Label getNameLabel() {
            return this._nameLabel;
        }

        public Label getLabel1() {
            return this._label1;
        }

        public Label getLabel2() {
            return this._label2;
        }
    }

    class Dragger
    extends MouseMotionListener.Stub
    implements MouseListener {
        IFigure _figure;

        public Dragger(IFigure figure) {
            this._figure = figure;
            figure.addMouseMotionListener((MouseMotionListener)this);
            figure.addMouseListener((MouseListener)this);
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseDoubleClicked(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            IFigure f = (IFigure)e.getSource();
            TreePlanDrawer.this.selectFigure(f);
        }

        public void mouseDragged(MouseEvent e) {
        }

        public void dispose() {
            if (this._figure != null) {
                this._figure.removeMouseMotionListener((MouseMotionListener)this);
                this._figure.removeMouseListener((MouseListener)this);
            }
        }
    }
}

