/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.model.elements;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.IBreakpointsListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.breakpoints.provisional.IBreakpointOrganizer;
import org.eclipse.debug.internal.ui.elements.adapters.DefaultBreakpointsViewInput;
import org.eclipse.debug.internal.ui.model.elements.ElementContentProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ModelDelta;
import org.eclipse.debug.internal.ui.viewers.update.BreakpointManagerProxy;
import org.eclipse.debug.internal.ui.views.breakpoints.BreakpointContainer;
import org.eclipse.debug.internal.ui.views.breakpoints.ElementComparator;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.debug.ui.contexts.IDebugContextService;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchWindow;

public class BreakpointManagerContentProvider
extends ElementContentProvider
implements IBreakpointsListener {
    private ISchedulingRule fBreakpointsListenerSchedulingRule = new ISchedulingRule(){

        public boolean isConflicting(ISchedulingRule rule) {
            return rule == this;
        }

        public boolean contains(ISchedulingRule rule) {
            return rule == this;
        }
    };
    private final Map<DefaultBreakpointsViewInput, InputData> fInputToData = Collections.synchronizedMap(new InputDataMap());
    private boolean fIsBreakpointListener = false;
    private final IBreakpointManager fBpManager = DebugPlugin.getDefault().getBreakpointManager();

    protected IBreakpoint[] filterBreakpoints(DefaultBreakpointsViewInput input, IStructuredSelection selectionFilter, IBreakpoint[] breakpoints) {
        if (selectionFilter != null && !selectionFilter.isEmpty()) {
            List<IDebugTarget> targets = this.getDebugTargets(selectionFilter);
            ArrayList<IBreakpoint> retVal = new ArrayList<IBreakpoint>();
            if (targets != null) {
                IBreakpoint[] iBreakpointArray = breakpoints;
                int n = breakpoints.length;
                int n2 = 0;
                while (n2 < n) {
                    IBreakpoint breakpoint = iBreakpointArray[n2];
                    if (this.supportsBreakpoint(targets, breakpoint)) {
                        retVal.add(breakpoint);
                    }
                    ++n2;
                }
            }
            return retVal.toArray(new IBreakpoint[retVal.size()]);
        }
        return breakpoints;
    }

    protected boolean supportsBreakpoint(IStructuredSelection ss, IBreakpoint breakpoint) {
        return this.supportsBreakpoint(this.getDebugTargets(ss), breakpoint);
    }

    protected boolean supportsBreakpoint(List<IDebugTarget> targets, IBreakpoint breakpoint) {
        boolean exist = targets.isEmpty();
        int i = 0;
        while (!exist && i < targets.size()) {
            IDebugTarget target = targets.get(i);
            exist |= target.supportsBreakpoint(breakpoint);
            ++i;
        }
        return exist;
    }

    protected List<IDebugTarget> getDebugTargets(IStructuredSelection ss) {
        ArrayList<IDebugTarget> debugTargets = new ArrayList<IDebugTarget>(2);
        if (ss != null) {
            for (Object next : ss) {
                IDebugTarget target;
                if (next instanceof IDebugElement) {
                    debugTargets.add(((IDebugElement)next).getDebugTarget());
                    continue;
                }
                if (next instanceof ILaunch) {
                    IDebugTarget[] targets = ((ILaunch)next).getDebugTargets();
                    Collections.addAll(debugTargets, targets);
                    continue;
                }
                if (next instanceof IProcess) {
                    target = (IDebugTarget)((IProcess)next).getAdapter(IDebugTarget.class);
                    if (target == null) continue;
                    debugTargets.add(target);
                    continue;
                }
                if (!(next instanceof IAdaptable) || (target = (IDebugTarget)((IAdaptable)next).getAdapter(IDebugTarget.class)) == null) continue;
                debugTargets.add(target);
            }
        }
        return debugTargets;
    }

    protected int getMaxInputsCache() {
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void contextDisposed(IPresentationContext context) {
        ArrayList<InputData> removed = new ArrayList<InputData>(1);
        Map<DefaultBreakpointsViewInput, InputData> map = this.fInputToData;
        synchronized (map) {
            Iterator<Map.Entry<DefaultBreakpointsViewInput, InputData>> itr = this.fInputToData.entrySet().iterator();
            while (itr.hasNext()) {
                Map.Entry<DefaultBreakpointsViewInput, InputData> entry = itr.next();
                IPresentationContext entryContext = entry.getKey().getContext();
                if (!context.equals(entryContext)) continue;
                removed.add(entry.getValue());
                itr.remove();
            }
        }
        for (InputData inputData : removed) {
            inputData.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerModelProxy(DefaultBreakpointsViewInput input, BreakpointManagerProxy proxy) {
        BreakpointManagerContentProvider breakpointManagerContentProvider = this;
        synchronized (breakpointManagerContentProvider) {
            if (!this.fIsBreakpointListener) {
                this.fBpManager.addBreakpointListener((IBreakpointsListener)this);
                this.fIsBreakpointListener = true;
            }
        }
        InputData inputData = this.getInputData(input);
        if (inputData != null) {
            inputData.proxyInstalled(proxy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterModelProxy(DefaultBreakpointsViewInput input, BreakpointManagerProxy proxy) {
        InputData inputData = this.fInputToData.get(input);
        if (inputData != null) {
            inputData.proxyDisposed(proxy);
            if (this.fInputToData.isEmpty()) {
                BreakpointManagerContentProvider breakpointManagerContentProvider = this;
                synchronized (breakpointManagerContentProvider) {
                    if (this.fIsBreakpointListener) {
                        this.fBpManager.removeBreakpointListener((IBreakpointsListener)this);
                        this.fIsBreakpointListener = false;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputData getInputData(DefaultBreakpointsViewInput input) {
        if (Boolean.TRUE.equals(input.getContext().getProperty("PROPERTY_DISPOSED"))) {
            return null;
        }
        InputData data = null;
        Map<DefaultBreakpointsViewInput, InputData> map = this.fInputToData;
        synchronized (map) {
            data = this.fInputToData.get(input);
            if (data == null) {
                data = new InputData(input);
                this.fInputToData.put(input, data);
            }
        }
        return data;
    }

    protected IStructuredSelection getSelectionFilter(Object input, IStructuredSelection debugContext) {
        IPresentationContext presentation;
        if (input instanceof DefaultBreakpointsViewInput && Boolean.TRUE.equals((presentation = ((DefaultBreakpointsViewInput)input).getContext()).getProperty("FilterSelection"))) {
            return debugContext;
        }
        return null;
    }

    @Override
    protected boolean supportsContextId(String id) {
        return id.equals("org.eclipse.debug.ui.BreakpointView");
    }

    @Override
    protected int getChildCount(Object element, IPresentationContext context, IViewerUpdate monitor) throws CoreException {
        DefaultBreakpointsViewInput bpManagerInput;
        InputData inputData;
        Object input = monitor.getViewerInput();
        if (input instanceof DefaultBreakpointsViewInput && (inputData = this.getInputData(bpManagerInput = (DefaultBreakpointsViewInput)input)) != null) {
            return inputData.fContainer.getChildren().length;
        }
        return 0;
    }

    @Override
    protected Object[] getChildren(Object parent, int index, int length, IPresentationContext context, IViewerUpdate monitor) throws CoreException {
        DefaultBreakpointsViewInput bpManagerInput;
        InputData inputData;
        Object input = monitor.getViewerInput();
        if (input instanceof DefaultBreakpointsViewInput && (inputData = this.getInputData(bpManagerInput = (DefaultBreakpointsViewInput)input)) != null) {
            Object[] children = inputData.fContainer.getChildren();
            return this.getElements(children, index, length);
        }
        return EMPTY;
    }

    public void breakpointsAdded(final IBreakpoint[] breakpoints) {
        new Job("Breakpoints View Update Job"){
            {
                super($anonymous0);
                this.setSystem(true);
                this.setRule(BreakpointManagerContentProvider.this.fBreakpointsListenerSchedulingRule);
            }

            protected IStatus run(IProgressMonitor monitor) {
                for (InputData data : BreakpointManagerContentProvider.this.fInputToData.values()) {
                    data.breakpointsAdded(breakpoints);
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    public void breakpointsRemoved(final IBreakpoint[] breakpoints, IMarkerDelta[] deltas) {
        new Job("Breakpoints View Update Job"){
            {
                super($anonymous0);
                this.setSystem(true);
                this.setRule(BreakpointManagerContentProvider.this.fBreakpointsListenerSchedulingRule);
            }

            protected IStatus run(IProgressMonitor monitor) {
                for (InputData data : BreakpointManagerContentProvider.this.fInputToData.values()) {
                    data.breakpointsRemoved(breakpoints);
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    public void breakpointsChanged(final IBreakpoint[] breakpoints, IMarkerDelta[] deltas) {
        new Job("Breakpoints View Update Job"){
            {
                super($anonymous0);
                this.setSystem(true);
                this.setRule(BreakpointManagerContentProvider.this.fBreakpointsListenerSchedulingRule);
            }

            protected IStatus run(IProgressMonitor monitor) {
                for (InputData data : BreakpointManagerContentProvider.this.fInputToData.values()) {
                    data.breakpointsChanged(breakpoints);
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    private void appendModelDelta(BreakpointContainer parent, ModelDelta parentDelta, int flags, IBreakpoint breakpoint) {
        BreakpointContainer[] containers = parent.getContainers();
        if (parent.contains(breakpoint)) {
            if (containers.length != 0) {
                BreakpointContainer[] breakpointContainerArray = containers;
                int n = containers.length;
                int n2 = 0;
                while (n2 < n) {
                    BreakpointContainer container = breakpointContainerArray[n2];
                    ModelDelta nodeDelta = parentDelta.addNode(container, 2048);
                    this.appendModelDelta(container, nodeDelta, flags, breakpoint);
                    ++n2;
                }
            } else {
                parentDelta.addNode(breakpoint, flags);
            }
        }
    }

    private void appendModelDeltaToElement(IModelDelta parentDelta, Object element, int flags) {
        if (element.equals(parentDelta.getElement())) {
            ((ModelDelta)parentDelta).setFlags(parentDelta.getFlags() | flags);
            return;
        }
        IModelDelta[] iModelDeltaArray = parentDelta.getChildDeltas();
        int n = iModelDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IModelDelta childDelta = iModelDeltaArray[n2];
            if (element.equals(childDelta.getElement())) {
                ((ModelDelta)childDelta).setFlags(childDelta.getFlags() | flags);
                return;
            }
            this.appendModelDeltaToElement(childDelta, element, flags);
            ++n2;
        }
    }

    private class InputData {
        private final DefaultBreakpointsViewInput fInput;
        private final List<BreakpointManagerProxy> fProxies = new ArrayList<BreakpointManagerProxy>(1);
        private ElementComparator fComparator;
        private final BreakpointContainer fContainer;
        private IBreakpointOrganizer[] fOrganizers;
        private IStructuredSelection fDebugContext = StructuredSelection.EMPTY;
        private IPropertyChangeListener fOrganizersListener = event -> this.updateContainers();
        private IPropertyChangeListener fPresentationContextListener = this::presentationPropertyChanged;
        private IDebugContextListener fDebugContextListener = this::debugContextChanged;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        InputData(DefaultBreakpointsViewInput input) {
            this.fInput = input;
            this.fComparator = (ElementComparator)input.getContext().getProperty("ElementComparator");
            this.fOrganizers = (IBreakpointOrganizer[])input.getContext().getProperty("BreakpointOrganizers");
            ModelDelta initialDelta = new ModelDelta(this.fInput, 0, 0, -1);
            IBreakpoint[] breakpoints = BreakpointManagerContentProvider.this.filterBreakpoints(this.fInput, BreakpointManagerContentProvider.this.getSelectionFilter(this.fInput, this.getDebugContext()), BreakpointManagerContentProvider.this.fBpManager.getBreakpoints());
            this.fContainer = this.createRootContainer(initialDelta, this.fInput, this.fOrganizers, breakpoints);
            this.registerOrganizersListener(null, this.fOrganizers);
            input.getContext().addPropertyChangeListener(this.fPresentationContextListener);
            IWorkbenchWindow window = this.fInput.getContext().getWindow();
            if (window != null) {
                IDebugContextService debugContextService = DebugUITools.getDebugContextManager().getContextService(window);
                ISelection debugContext = debugContextService.getActiveContext();
                if (debugContext instanceof IStructuredSelection) {
                    InputData inputData = this;
                    synchronized (inputData) {
                        this.fDebugContext = (IStructuredSelection)debugContext;
                    }
                }
                debugContextService.addDebugContextListener(this.fDebugContextListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void dispose() {
            IBreakpointOrganizer[] organizers;
            InputData inputData = this;
            synchronized (inputData) {
                organizers = this.fOrganizers;
                this.fOrganizers = null;
            }
            this.registerOrganizersListener(organizers, null);
            this.fInput.getContext().removePropertyChangeListener(this.fPresentationContextListener);
            IWorkbenchWindow window = this.fInput.getContext().getWindow();
            if (window != null) {
                IDebugContextService debugContextService = DebugUITools.getDebugContextManager().getContextService(window);
                debugContextService.removeDebugContextListener(this.fDebugContextListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void proxyInstalled(BreakpointManagerProxy proxy) {
            ModelDelta rootDelta = null;
            InputData inputData = this;
            synchronized (inputData) {
                this.fProxies.add(proxy);
                rootDelta = new ModelDelta(this.fInput, 0, 0, -1);
                this.buildInstallDelta(rootDelta, this.fContainer);
                if (DebugUIPlugin.DEBUG_BREAKPOINT_DELTAS) {
                    DebugUIPlugin.trace("PROXY INSTALLED (" + proxy + ")\n");
                }
                proxy.postModelChanged(rootDelta, false);
            }
        }

        synchronized void proxyDisposed(BreakpointManagerProxy proxy) {
            this.fProxies.remove(proxy);
            if (DebugUIPlugin.DEBUG_BREAKPOINT_DELTAS) {
                DebugUIPlugin.trace("PROXY DISPOSED (" + proxy + ")\n");
            }
        }

        synchronized BreakpointManagerProxy[] getProxies() {
            return this.fProxies.toArray(new BreakpointManagerProxy[this.fProxies.size()]);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setOrganizers(IBreakpointOrganizer[] organizers) {
            IBreakpointOrganizer[] oldOrganizers = null;
            InputData inputData = this;
            synchronized (inputData) {
                oldOrganizers = this.fOrganizers;
                this.fOrganizers = organizers;
            }
            this.registerOrganizersListener(oldOrganizers, organizers);
            this.updateContainers();
        }

        private void registerOrganizersListener(IBreakpointOrganizer[] oldOrganizers, IBreakpointOrganizer[] newOrganizers) {
            int n;
            int n2;
            IBreakpointOrganizer[] iBreakpointOrganizerArray;
            if (oldOrganizers != null) {
                iBreakpointOrganizerArray = oldOrganizers;
                n2 = oldOrganizers.length;
                n = 0;
                while (n < n2) {
                    IBreakpointOrganizer oldOrganizer = iBreakpointOrganizerArray[n];
                    oldOrganizer.removePropertyChangeListener(this.fOrganizersListener);
                    ++n;
                }
            }
            if (newOrganizers != null) {
                iBreakpointOrganizerArray = newOrganizers;
                n2 = newOrganizers.length;
                n = 0;
                while (n < n2) {
                    IBreakpointOrganizer newOrganizer = iBreakpointOrganizerArray[n];
                    newOrganizer.addPropertyChangeListener(this.fOrganizersListener);
                    ++n;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void updateContainers() {
            IBreakpoint[] breakpoints = BreakpointManagerContentProvider.this.filterBreakpoints(this.fInput, BreakpointManagerContentProvider.this.getSelectionFilter(this.fInput, this.getDebugContext()), BreakpointManagerContentProvider.this.fBpManager.getBreakpoints());
            InputData inputData = this;
            synchronized (inputData) {
                ModelDelta delta = new ModelDelta(this.fInput, 0);
                ModelDelta dummyDelta = new ModelDelta(null, 0);
                BreakpointContainer refContainer = this.createRootContainer(dummyDelta, this.fInput, this.fOrganizers, breakpoints);
                this.deleteRemovedElements(this.fContainer, refContainer, delta);
                BreakpointContainer.copyOrganizers(this.fContainer, refContainer);
                IBreakpoint newBreakpoint = this.insertAddedElements(this.fContainer, refContainer, delta);
                delta.setChildCount(this.fContainer.getChildren().length);
                if (newBreakpoint != null) {
                    BreakpointManagerContentProvider.this.appendModelDeltaToElement(delta, newBreakpoint, 0x200000);
                }
                if (DebugUIPlugin.DEBUG_BREAKPOINT_DELTAS) {
                    DebugUIPlugin.trace("POST BREAKPOINT DELTA (setOrganizers)\n");
                }
                this.postModelChanged(delta, false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void sortContainers() {
            IBreakpoint[] breakpoints = BreakpointManagerContentProvider.this.filterBreakpoints(this.fInput, BreakpointManagerContentProvider.this.getSelectionFilter(this.fInput, this.getDebugContext()), BreakpointManagerContentProvider.this.fBpManager.getBreakpoints());
            InputData inputData = this;
            synchronized (inputData) {
                ModelDelta delta = new ModelDelta(this.fInput, 0);
                ModelDelta dummyDelta = new ModelDelta(null, 0);
                BreakpointContainer refContainer = this.createRootContainer(dummyDelta, this.fInput, this.fOrganizers, breakpoints);
                this.deleteAllElements(this.fContainer, delta);
                BreakpointContainer.copyOrganizers(this.fContainer, refContainer);
                IBreakpoint newBreakpoint = this.insertAddedElements(this.fContainer, refContainer, delta);
                delta.setChildCount(this.fContainer.getChildren().length);
                if (newBreakpoint != null) {
                    BreakpointManagerContentProvider.this.appendModelDeltaToElement(delta, newBreakpoint, 0x200000);
                }
                if (DebugUIPlugin.DEBUG_BREAKPOINT_DELTAS) {
                    DebugUIPlugin.trace("POST BREAKPOINT DELTA (setOrganizers)\n");
                }
                this.postModelChanged(delta, false);
            }
        }

        private synchronized IStructuredSelection getDebugContext() {
            return this.fDebugContext;
        }

        private void presentationPropertyChanged(PropertyChangeEvent event) {
            if ("ElementComparatorSort".equals(event.getProperty())) {
                this.sortContainers();
            } else if ("PROPERTY_DISPOSED".equals(event.getProperty())) {
                BreakpointManagerContentProvider.this.contextDisposed(this.fInput.getContext());
            }
            if ("BreakpointOrganizers".equals(event.getProperty())) {
                IBreakpointOrganizer[] organizers = (IBreakpointOrganizer[])event.getNewValue();
                this.setOrganizers(organizers);
            } else if ("FilterSelection".equals(event.getProperty())) {
                IStructuredSelection selection = null;
                if (Boolean.TRUE.equals(event.getNewValue())) {
                    selection = this.getDebugContext();
                }
                this.setFilterSelection(selection);
            } else if ("TrackSelection".equals(event.getProperty())) {
                IStructuredSelection selection = null;
                if (Boolean.TRUE.equals(event.getNewValue())) {
                    selection = this.getDebugContext();
                }
                this.trackSelection(selection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void debugContextChanged(DebugContextEvent event) {
            Object newContext = event.getContext() instanceof IStructuredSelection ? (IStructuredSelection)event.getContext() : StructuredSelection.EMPTY;
            InputData inputData = this;
            synchronized (inputData) {
                this.fDebugContext = newContext;
            }
            if (Boolean.TRUE.equals(this.fInput.getContext().getProperty("FilterSelection"))) {
                this.setFilterSelection((IStructuredSelection)newContext);
            }
            if (Boolean.TRUE.equals(this.fInput.getContext().getProperty("TrackSelection"))) {
                this.trackSelection((IStructuredSelection)newContext);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setFilterSelection(IStructuredSelection ss) {
            ModelDelta delta = new ModelDelta(this.fInput, 0);
            boolean changed = false;
            IBreakpoint[] allBreakpoints = BreakpointManagerContentProvider.this.fBpManager.getBreakpoints();
            boolean[] supportedBreakpoints = new boolean[allBreakpoints.length];
            int i = 0;
            while (i < allBreakpoints.length) {
                supportedBreakpoints[i] = BreakpointManagerContentProvider.this.supportsBreakpoint(ss, allBreakpoints[i]);
                ++i;
            }
            InputData inputData = this;
            synchronized (inputData) {
                HashSet<IBreakpoint> existingBreakpoints = new HashSet<IBreakpoint>(Arrays.asList(this.fContainer.getBreakpoints()));
                int i2 = 0;
                while (i2 < allBreakpoints.length) {
                    if (!supportedBreakpoints[i2] && existingBreakpoints.contains(allBreakpoints[i2])) {
                        this.fContainer.removeBreakpoint(allBreakpoints[i2], delta);
                        changed = true;
                    }
                    ++i2;
                }
                i2 = 0;
                while (i2 < allBreakpoints.length) {
                    if (supportedBreakpoints[i2] && !existingBreakpoints.contains(allBreakpoints[i2])) {
                        this.fContainer.addBreakpoint(allBreakpoints[i2], delta);
                        changed = true;
                    }
                    ++i2;
                }
                if (changed) {
                    if (DebugUIPlugin.DEBUG_BREAKPOINT_DELTAS) {
                        DebugUIPlugin.trace("POST BREAKPOINT DELTA (setFilterSelection)\n");
                    }
                    this.postModelChanged(delta, false);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void trackSelection(IStructuredSelection selection) {
            if (selection == null || selection.size() != 1) {
                return;
            }
            Iterator iter = selection.iterator();
            Object firstElement = iter.next();
            if (firstElement == null || iter.hasNext()) {
                return;
            }
            IThread thread = null;
            if (firstElement instanceof IStackFrame) {
                thread = ((IStackFrame)firstElement).getThread();
            } else if (firstElement instanceof IThread) {
                thread = (IThread)firstElement;
            } else {
                return;
            }
            IBreakpoint[] breakpoints = thread.getBreakpoints();
            HashSet<IBreakpoint> bpsSet = new HashSet<IBreakpoint>(breakpoints.length * 4 / 3);
            Collections.addAll(bpsSet, breakpoints);
            ModelDelta delta = new ModelDelta(this.fInput, 0);
            InputData inputData = this;
            synchronized (inputData) {
                if (this.buildTrackSelectionDelta(delta, this.fContainer, bpsSet)) {
                    if (DebugUIPlugin.DEBUG_BREAKPOINT_DELTAS) {
                        DebugUIPlugin.trace("POST BREAKPOINT DELTA (trackSelection)\n");
                    }
                    BreakpointManagerProxy[] breakpointManagerProxyArray = this.getProxies();
                    int n = breakpointManagerProxyArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        BreakpointManagerProxy proxy = breakpointManagerProxyArray[n2];
                        proxy.postModelChanged(delta, true);
                        ++n2;
                    }
                }
            }
        }

        private boolean buildTrackSelectionDelta(ModelDelta delta, BreakpointContainer container, Set<IBreakpoint> breakpoints) {
            Object[] children = container.getChildren();
            delta.setChildCount(children.length);
            int i = 0;
            while (i < children.length) {
                ModelDelta childDelta = delta.addNode(children[i], i, 0);
                if (children[i] instanceof BreakpointContainer) {
                    BreakpointContainer childContainer = (BreakpointContainer)children[i];
                    boolean containsBP = false;
                    IBreakpoint[] iBreakpointArray = childContainer.getBreakpoints();
                    int n = iBreakpointArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IBreakpoint containerBP = iBreakpointArray[n2];
                        if (breakpoints.contains(containerBP)) {
                            containsBP = true;
                            break;
                        }
                        ++n2;
                    }
                    if (containsBP && this.buildTrackSelectionDelta(childDelta, childContainer, breakpoints)) {
                        return true;
                    }
                } else if (children[i] instanceof IBreakpoint && breakpoints.contains(children[i])) {
                    childDelta.setFlags(0x300000);
                    return true;
                }
                ++i;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void breakpointsAdded(IBreakpoint[] breakpoints) {
            IBreakpoint[] filteredBreakpoints = BreakpointManagerContentProvider.this.filterBreakpoints(this.fInput, BreakpointManagerContentProvider.this.getSelectionFilter(this.fInput, this.getDebugContext()), breakpoints);
            if (filteredBreakpoints.length > 0) {
                InputData inputData = this;
                synchronized (inputData) {
                    ModelDelta delta = new ModelDelta(this.fInput, 0, 0, -1);
                    IBreakpoint[] iBreakpointArray = filteredBreakpoints;
                    int n = filteredBreakpoints.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IBreakpoint filteredBreakpoint = iBreakpointArray[n2];
                        if (DebugPlugin.getDefault().getBreakpointManager().getBreakpoint(filteredBreakpoint.getMarker()) != null) {
                            this.fContainer.addBreakpoint(filteredBreakpoint, delta);
                        }
                        ++n2;
                    }
                    delta.setChildCount(this.fContainer.getChildren().length);
                    if (filteredBreakpoints.length > 0) {
                        BreakpointManagerContentProvider.this.appendModelDeltaToElement(delta, filteredBreakpoints[0], 0x200000);
                    }
                    if (DebugUIPlugin.DEBUG_BREAKPOINT_DELTAS) {
                        DebugUIPlugin.trace("POST BREAKPOINT DELTA (breakpointsAddedInput)\n");
                    }
                    this.postModelChanged(delta, false);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void breakpointsRemoved(IBreakpoint[] breakpoints) {
            InputData inputData = this;
            synchronized (inputData) {
                boolean removed = false;
                ModelDelta delta = new ModelDelta(this.fInput, 0);
                IBreakpoint[] iBreakpointArray = breakpoints;
                int n = breakpoints.length;
                int n2 = 0;
                while (n2 < n) {
                    IBreakpoint breakpoint = iBreakpointArray[n2];
                    removed = this.fContainer.removeBreakpoint(breakpoint, delta) || removed;
                    ++n2;
                }
                if (removed) {
                    if (DebugUIPlugin.DEBUG_BREAKPOINT_DELTAS) {
                        DebugUIPlugin.trace("POST BREAKPOINT DELTA (breakpointsRemovedInput)\n");
                    }
                    this.postModelChanged(delta, false);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void breakpointsChanged(IBreakpoint[] breakpoints) {
            IBreakpoint[] filteredBreakpoints = BreakpointManagerContentProvider.this.filterBreakpoints(this.fInput, BreakpointManagerContentProvider.this.getSelectionFilter(this.fInput, this.getDebugContext()), breakpoints);
            InputData inputData = this;
            synchronized (inputData) {
                ModelDelta delta = new ModelDelta(this.fInput, 0);
                ArrayList<IBreakpoint> removed = new ArrayList<IBreakpoint>();
                ArrayList<IBreakpoint> added = new ArrayList<IBreakpoint>();
                List<IBreakpoint> filteredAsList = Arrays.asList(filteredBreakpoints);
                IBreakpoint[] iBreakpointArray = breakpoints;
                int n = breakpoints.length;
                int n2 = 0;
                while (n2 < n) {
                    IBreakpoint bp = iBreakpointArray[n2];
                    boolean oldContainedBp = this.fContainer.contains(bp);
                    boolean newContained = filteredAsList.contains(bp);
                    if (oldContainedBp && !newContained) {
                        removed.add(bp);
                    } else if (!oldContainedBp && newContained) {
                        added.add(bp);
                    }
                    ++n2;
                }
                if (!added.isEmpty()) {
                    this.breakpointsAdded(added.toArray(new IBreakpoint[added.size()]));
                }
                if (!removed.isEmpty()) {
                    this.breakpointsRemoved(removed.toArray(new IBreakpoint[removed.size()]));
                }
                iBreakpointArray = filteredBreakpoints;
                n = filteredBreakpoints.length;
                n2 = 0;
                while (n2 < n) {
                    IBreakpoint filteredBreakpoint = iBreakpointArray[n2];
                    BreakpointManagerContentProvider.this.appendModelDelta(this.fContainer, delta, 3072, filteredBreakpoint);
                    ++n2;
                }
                if (DebugUIPlugin.DEBUG_BREAKPOINT_DELTAS) {
                    DebugUIPlugin.trace("POST BREAKPOINT DELTA (breakpointsChanged)\n");
                }
                this.postModelChanged(delta, false);
            }
        }

        private void buildInstallDelta(ModelDelta delta, BreakpointContainer container) {
            Object[] children = container.getChildren();
            delta.setChildCount(children.length);
            int i = 0;
            while (i < children.length) {
                ModelDelta childDelta = delta.addNode(children[i], i, 0);
                if (children[i] instanceof BreakpointContainer) {
                    childDelta.setFlags(0x400000);
                    this.buildInstallDelta(childDelta, (BreakpointContainer)children[i]);
                } else if (children[i] instanceof IBreakpoint) {
                    childDelta.setFlags(0x400000);
                }
                ++i;
            }
        }

        private IBreakpoint insertAddedElements(BreakpointContainer container, BreakpointContainer refContainer, ModelDelta containerDelta) {
            IBreakpoint newBreakpoint = null;
            Object[] children = container.getChildren();
            Object[] objectArray = refContainer.getChildren();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object refChildElement = objectArray[n2];
                Object element = this.getElement(children, refChildElement);
                if (element == null) {
                    if (refChildElement instanceof BreakpointContainer) {
                        BreakpointContainer.addChildContainer(container, (BreakpointContainer)refChildElement, containerDelta);
                    } else if (refChildElement instanceof IBreakpoint) {
                        BreakpointContainer.addBreakpoint(container, (IBreakpoint)refChildElement, containerDelta);
                        if (newBreakpoint == null) {
                            newBreakpoint = (IBreakpoint)refChildElement;
                        }
                    }
                } else if (element instanceof BreakpointContainer) {
                    ModelDelta childDelta = containerDelta.addNode(element, container.getChildIndex(element), 0x400000, -1);
                    BreakpointContainer.copyOrganizers((BreakpointContainer)element, (BreakpointContainer)refChildElement);
                    newBreakpoint = this.insertAddedElements((BreakpointContainer)element, (BreakpointContainer)refChildElement, childDelta);
                    childDelta.setChildCount(((BreakpointContainer)element).getChildren().length);
                }
                ++n2;
            }
            return newBreakpoint;
        }

        private void deleteRemovedElements(BreakpointContainer container, BreakpointContainer refContainer, ModelDelta containerDelta) {
            Object[] refChildren = refContainer.getChildren();
            Object[] objectArray = container.getChildren();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object childElement = objectArray[n2];
                Object element = this.getElement(refChildren, childElement);
                if (element == null) {
                    if (childElement instanceof BreakpointContainer) {
                        BreakpointContainer.removeAll((BreakpointContainer)childElement, containerDelta);
                    } else {
                        BreakpointContainer.removeBreakpoint(container, (IBreakpoint)childElement, containerDelta);
                    }
                } else if (element instanceof BreakpointContainer) {
                    ModelDelta childDelta = containerDelta.addNode(childElement, 2048);
                    this.deleteRemovedElements((BreakpointContainer)childElement, (BreakpointContainer)element, childDelta);
                }
                ++n2;
            }
        }

        private void deleteAllElements(BreakpointContainer container, ModelDelta containerDelta) {
            Object[] objectArray = container.getChildren();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object childElement = objectArray[n2];
                if (childElement instanceof BreakpointContainer) {
                    BreakpointContainer.removeAll((BreakpointContainer)childElement, containerDelta);
                } else {
                    BreakpointContainer.removeBreakpoint(container, (IBreakpoint)childElement, containerDelta);
                }
                ++n2;
            }
        }

        private Object getElement(Object[] collection, Object element) {
            Object[] objectArray = collection;
            int n = collection.length;
            int n2 = 0;
            while (n2 < n) {
                Object element2 = objectArray[n2];
                if (element2 instanceof BreakpointContainer && element instanceof BreakpointContainer ? element2.equals(element) : element2.equals(element)) {
                    return element2;
                }
                ++n2;
            }
            return null;
        }

        private BreakpointContainer createRootContainer(ModelDelta rootDelta, DefaultBreakpointsViewInput input, IBreakpointOrganizer[] organizers, IBreakpoint[] breakpoints) {
            BreakpointContainer container = new BreakpointContainer(organizers, this.fComparator);
            container.initDefaultContainers(rootDelta);
            IBreakpoint[] iBreakpointArray = breakpoints;
            int n = breakpoints.length;
            int n2 = 0;
            while (n2 < n) {
                IBreakpoint breakpoint = iBreakpointArray[n2];
                container.addBreakpoint(breakpoint, rootDelta);
                ++n2;
            }
            return container;
        }

        private synchronized void postModelChanged(IModelDelta delta, boolean select) {
            int i = 0;
            while (this.fProxies != null && i < this.fProxies.size()) {
                this.fProxies.get(i).postModelChanged(delta, select);
                ++i;
            }
        }
    }

    private class InputDataMap<K, V>
    extends LinkedHashMap<K, V> {
        private static final long serialVersionUID = 1L;

        public InputDataMap() {
            super(1, 0.75f, true);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> arg0) {
            InputData data = (InputData)arg0.getValue();
            if (this.size() > BreakpointManagerContentProvider.this.getMaxInputsCache() && data.fProxies.isEmpty()) {
                data.dispose();
                return true;
            }
            return false;
        }
    }
}

