/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.CreationReference;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.MethodReference;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.SuperMethodReference;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.TypeMethodReference;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.WhileStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.TargetSourceRangeComputer;
import org.eclipse.jdt.core.manipulation.ICleanUpFixCore;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.VarDefinitionsUsesVisitor;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFixCore;
import org.eclipse.jdt.internal.corext.fix.FixMessages;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.text.edits.TextEditGroup;

public class DoWhileRatherThanWhileFixCore
extends CompilationUnitRewriteOperationsFixCore {
    public static ICleanUpFixCore createCleanUp(CompilationUnit compilationUnit) {
        ArrayList<CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation> operations = new ArrayList<CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation>();
        DoWhileRatherThanWhileFinder finder = new DoWhileRatherThanWhileFinder(operations);
        compilationUnit.accept((ASTVisitor)finder);
        if (operations.isEmpty()) {
            return null;
        }
        CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[] ops = operations.toArray(new CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[0]);
        return new DoWhileRatherThanWhileFixCore(FixMessages.DoWhileRatherThanWhileFix_description, compilationUnit, ops);
    }

    public static ICleanUpFixCore createCleanUp(CompilationUnit compilationUnit, WhileStatement whileStatement) {
        ArrayList<CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation> operations = new ArrayList<CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation>();
        DoWhileRatherThanWhileFinder finder = new DoWhileRatherThanWhileFinder(operations);
        whileStatement.accept((ASTVisitor)finder);
        if (operations.isEmpty()) {
            return null;
        }
        CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[] ops = operations.toArray(new CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[0]);
        return new DoWhileRatherThanWhileFixCore(FixMessages.DoWhileRatherThanWhileFix_description, compilationUnit, ops);
    }

    protected DoWhileRatherThanWhileFixCore(String name, CompilationUnit compilationUnit, CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[] fixRewriteOperations) {
        super(name, compilationUnit, fixRewriteOperations);
    }

    public static final class DoWhileRatherThanWhileFinder
    extends ASTVisitor {
        private List<CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation> fResult;

        public DoWhileRatherThanWhileFinder(List<CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation> ops) {
            this.fResult = ops;
        }

        public boolean visit(WhileStatement visited) {
            if (ASTNodes.isPassiveWithoutFallingThrough((ASTNode)visited.getExpression()) && Boolean.TRUE.equals(this.peremptoryValue((ASTNode)visited, visited.getExpression()))) {
                this.fResult.add(new DoWhileRatherThanWhileOperation(visited));
                return false;
            }
            return true;
        }

        private Object peremptoryValue(ASTNode visited, Expression condition) {
            Object constantCondition = condition.resolveConstantExpressionValue();
            if (constantCondition != null) {
                return constantCondition;
            }
            Long integerLiteral = ASTNodes.getIntegerLiteral(condition);
            if (integerLiteral != null) {
                return integerLiteral;
            }
            SimpleName variable = ASTNodes.as(condition, SimpleName.class);
            if (variable != null && variable.resolveBinding() != null && variable.resolveBinding().getKind() == 3) {
                List<ASTNode> precedingStatements = this.getPrecedingCode(visited);
                Collections.reverse(precedingStatements);
                for (ASTNode precedingStatement : precedingStatements) {
                    SimpleName write;
                    if (this.isConditionalCode(precedingStatement)) {
                        return null;
                    }
                    VarDefinitionsUsesVisitor visitor = new VarDefinitionsUsesVisitor((IVariableBinding)variable.resolveBinding(), precedingStatement, true);
                    if (visitor.getWrites().size() > 1) {
                        return null;
                    }
                    for (SimpleName astNode : visitor.getReads()) {
                        ASTNode parent = astNode.getParent();
                        while (parent instanceof ParenthesizedExpression) {
                            parent = astNode.getParent();
                        }
                        if ((!(parent instanceof PrefixExpression) || !ASTNodes.hasOperator((PrefixExpression)parent, PrefixExpression.Operator.INCREMENT, PrefixExpression.Operator.DECREMENT)) && (!(parent instanceof PostfixExpression) || !ASTNodes.hasOperator((PostfixExpression)parent, PostfixExpression.Operator.INCREMENT, PostfixExpression.Operator.DECREMENT))) continue;
                        return null;
                    }
                    if (visitor.getWrites().isEmpty()) continue;
                    SimpleName parent = write = visitor.getWrites().get(0);
                    while (parent != precedingStatement) {
                        if (this.isConditionalCode((ASTNode)parent)) {
                            return null;
                        }
                        parent = parent.getParent();
                    }
                    switch (write.getParent().getNodeType()) {
                        case 7: {
                            Assignment assignment = (Assignment)write.getParent();
                            if (!ASTNodes.hasOperator(assignment, Assignment.Operator.ASSIGN, new Assignment.Operator[0])) break;
                            return this.peremptoryValue(precedingStatement, assignment.getRightHandSide());
                        }
                        case 59: {
                            VariableDeclarationFragment fragment = (VariableDeclarationFragment)write.getParent();
                            if (fragment.getInitializer() == null) break;
                            return this.peremptoryValue(precedingStatement, fragment.getInitializer());
                        }
                        case 44: {
                            SingleVariableDeclaration singleVariableDeclaration = (SingleVariableDeclaration)write.getParent();
                            if (singleVariableDeclaration.getInitializer() == null) break;
                            return this.peremptoryValue(precedingStatement, singleVariableDeclaration.getInitializer());
                        }
                    }
                    return null;
                }
                return null;
            }
            InfixExpression infixExpression = ASTNodes.as(condition, InfixExpression.class);
            if (infixExpression != null) {
                if (!infixExpression.hasExtendedOperands() && ASTNodes.hasOperator(infixExpression, InfixExpression.Operator.EQUALS, InfixExpression.Operator.NOT_EQUALS, InfixExpression.Operator.GREATER, InfixExpression.Operator.GREATER_EQUALS, InfixExpression.Operator.LESS, InfixExpression.Operator.LESS_EQUALS)) {
                    Object leftOperand = this.peremptoryValue(visited, infixExpression.getLeftOperand());
                    Object rightOperand = this.peremptoryValue(visited, infixExpression.getRightOperand());
                    if (leftOperand instanceof Number && rightOperand instanceof Number) {
                        Number leftNumber = (Number)leftOperand;
                        Number rightNumber = (Number)rightOperand;
                        if (ASTNodes.hasOperator(infixExpression, InfixExpression.Operator.EQUALS, new InfixExpression.Operator[0])) {
                            if (leftNumber.longValue() == rightNumber.longValue()) {
                                return true;
                            }
                            return false;
                        }
                        if (ASTNodes.hasOperator(infixExpression, InfixExpression.Operator.NOT_EQUALS, new InfixExpression.Operator[0])) {
                            if (leftNumber.longValue() != rightNumber.longValue()) {
                                return true;
                            }
                            return false;
                        }
                        if (ASTNodes.hasOperator(infixExpression, InfixExpression.Operator.GREATER, new InfixExpression.Operator[0])) {
                            if (leftNumber.longValue() > rightNumber.longValue()) {
                                return true;
                            }
                            return false;
                        }
                        if (ASTNodes.hasOperator(infixExpression, InfixExpression.Operator.GREATER_EQUALS, new InfixExpression.Operator[0])) {
                            if (leftNumber.longValue() >= rightNumber.longValue()) {
                                return true;
                            }
                            return false;
                        }
                        if (ASTNodes.hasOperator(infixExpression, InfixExpression.Operator.LESS, new InfixExpression.Operator[0])) {
                            if (leftNumber.longValue() < rightNumber.longValue()) {
                                return true;
                            }
                            return false;
                        }
                        if (ASTNodes.hasOperator(infixExpression, InfixExpression.Operator.LESS_EQUALS, new InfixExpression.Operator[0])) {
                            if (leftNumber.longValue() <= rightNumber.longValue()) {
                                return true;
                            }
                            return false;
                        }
                    }
                    return null;
                }
                if (ASTNodes.hasOperator(infixExpression, InfixExpression.Operator.CONDITIONAL_AND, InfixExpression.Operator.AND)) {
                    for (Expression operand : ASTNodes.allOperands(infixExpression)) {
                        Object hasAlwaysValue = this.peremptoryValue(visited, operand);
                        if (Boolean.TRUE.equals(hasAlwaysValue)) continue;
                        return hasAlwaysValue;
                    }
                    return Boolean.TRUE;
                }
                if (ASTNodes.hasOperator(infixExpression, InfixExpression.Operator.CONDITIONAL_OR, InfixExpression.Operator.OR)) {
                    for (Expression operand : ASTNodes.allOperands(infixExpression)) {
                        Object hasAlwaysValue = this.peremptoryValue(visited, operand);
                        if (Boolean.FALSE.equals(hasAlwaysValue)) continue;
                        return hasAlwaysValue;
                    }
                    return Boolean.FALSE;
                }
            }
            return Boolean.FALSE;
        }

        private boolean isConditionalCode(ASTNode expression) {
            return expression == null || expression instanceof IfStatement || expression instanceof ConditionalExpression || expression instanceof EnhancedForStatement || expression instanceof SwitchStatement || expression instanceof WhileStatement || expression instanceof ForStatement || expression instanceof DoStatement || expression instanceof AbstractTypeDeclaration || expression instanceof LambdaExpression || expression instanceof MethodReference || expression instanceof SuperMethodReference || expression instanceof CreationReference || expression instanceof TypeMethodReference || expression instanceof SuperMethodReference;
        }

        private List<ASTNode> getPrecedingCode(ASTNode node) {
            Statement statement = null;
            statement = node instanceof Statement ? (Statement)node : ASTNodes.getTypedAncestor(node, Statement.class);
            if (statement == null) {
                return new ArrayList<ASTNode>();
            }
            ArrayList<Statement> precedingStatements = new ArrayList<Statement>(ASTNodes.getPreviousSiblings(statement));
            ASTNode parent = statement.getParent();
            if (parent instanceof Block) {
                precedingStatements.addAll(0, this.getPrecedingCode(parent));
                return precedingStatements;
            }
            if (parent instanceof IfStatement) {
                precedingStatements.add(0, (Statement)((IfStatement)parent).getExpression());
                precedingStatements.addAll(0, this.getPrecedingCode(parent));
            }
            if (parent instanceof CatchClause) {
                TryStatement tryStatement = (TryStatement)parent.getParent();
                precedingStatements.addAll(0, ASTNodes.asList((Statement)tryStatement.getBody()));
                if (statement.getParent().getLocationInParent() != TryStatement.RESOURCES_PROPERTY) {
                    precedingStatements.addAll(0, tryStatement.resources());
                }
                precedingStatements.addAll(0, this.getPrecedingCode((ASTNode)tryStatement));
            }
            if (parent instanceof TryStatement) {
                if (statement.getLocationInParent() == TryStatement.FINALLY_PROPERTY) {
                    return precedingStatements;
                }
                if (statement.getLocationInParent() != TryStatement.RESOURCES2_PROPERTY) {
                    precedingStatements.addAll(0, ((TryStatement)parent).resources());
                }
                precedingStatements.addAll(0, this.getPrecedingCode(parent));
            }
            return precedingStatements;
        }
    }

    public static class DoWhileRatherThanWhileOperation
    extends CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation {
        private final WhileStatement visited;

        public DoWhileRatherThanWhileOperation(WhileStatement visited) {
            this.visited = visited;
        }

        @Override
        public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModelCore linkedModel) throws CoreException {
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            AST ast = cuRewrite.getRoot().getAST();
            TextEditGroup group = this.createTextEditGroup(MultiFixMessages.DoWhileRatherThanWhileCleanUp_description, cuRewrite);
            rewrite.setTargetSourceRangeComputer(new TargetSourceRangeComputer(){

                public TargetSourceRangeComputer.SourceRange computeSourceRange(ASTNode nodeWithComment) {
                    if (Boolean.TRUE.equals(nodeWithComment.getProperty("untouchComment"))) {
                        return new TargetSourceRangeComputer.SourceRange(nodeWithComment.getStartPosition(), nodeWithComment.getLength());
                    }
                    return super.computeSourceRange(nodeWithComment);
                }
            });
            DoStatement newDoStatement = ast.newDoStatement();
            newDoStatement.setExpression(ASTNodes.createMoveTarget(rewrite, ASTNodes.getUnparenthesedExpression(this.visited.getExpression())));
            newDoStatement.setBody(ASTNodes.createMoveTarget(rewrite, this.visited.getBody()));
            ASTNodes.replaceButKeepComment(rewrite, (ASTNode)this.visited, (ASTNode)newDoStatement, group);
        }
    }
}

