/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.launching;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IModuleDescription;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.debug.core.IJavaMethodBreakpoint;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.internal.launching.JRERuntimeClasspathEntryResolver;
import org.eclipse.jdt.internal.launching.JavaSourceLookupDirector;
import org.eclipse.jdt.internal.launching.LaunchingMessages;
import org.eclipse.jdt.internal.launching.LaunchingPlugin;
import org.eclipse.jdt.internal.launching.sourcelookup.advanced.AdvancedSourceLookupSupport;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.IVMRunner;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.LibraryLocation;
import org.eclipse.osgi.util.NLS;

public abstract class AbstractJavaLaunchConfigurationDelegate
extends LaunchConfigurationDelegate
implements IDebugEventSetListener {
    private boolean allowAdvancedSourcelookup;
    private IProject[] fOrderedProjects;

    protected ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    protected void abort(String message, Throwable exception, int code) throws CoreException {
        throw new CoreException((IStatus)new Status(4, LaunchingPlugin.getUniqueIdentifier(), code, message, exception));
    }

    public IVMInstall getVMInstall(ILaunchConfiguration configuration) throws CoreException {
        return JavaRuntime.computeVMInstall(configuration);
    }

    public String getVMInstallName(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_INSTALL_NAME, null);
    }

    public IVMInstallType getVMInstallType(ILaunchConfiguration configuration) throws CoreException {
        IVMInstallType type;
        String id = this.getVMInstallTypeId(configuration);
        if (id != null && (type = JavaRuntime.getVMInstallType(id)) != null) {
            return type;
        }
        return null;
    }

    public String getVMInstallTypeId(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_INSTALL_TYPE, null);
    }

    public IVMInstall verifyVMInstall(ILaunchConfiguration configuration) throws CoreException {
        File location;
        IVMInstall vm = this.getVMInstall(configuration);
        if (vm == null) {
            this.abort(LaunchingMessages.AbstractJavaLaunchConfigurationDelegate_The_specified_JRE_installation_does_not_exist_4, null, 105);
        }
        if ((location = vm.getInstallLocation()) == null) {
            this.abort(NLS.bind((String)LaunchingMessages.AbstractJavaLaunchConfigurationDelegate_JRE_home_directory_not_specified_for__0__5, (Object[])new String[]{vm.getName()}), null, 105);
        }
        if (!location.exists()) {
            this.abort(NLS.bind((String)LaunchingMessages.AbstractJavaLaunchConfigurationDelegate_JRE_home_directory_for__0__does_not_exist___1__6, (Object[])new String[]{vm.getName(), location.getAbsolutePath()}), null, 105);
        }
        return vm;
    }

    public String getVMConnectorId(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_CONNECTOR, null);
    }

    public String[] getBootpath(ILaunchConfiguration configuration) throws CoreException {
        if (JavaRuntime.isModularConfiguration(configuration)) {
            return null;
        }
        String[][] paths = this.getBootpathExt(configuration);
        String[] pre = paths[0];
        String[] main = paths[1];
        String[] app = paths[2];
        if (pre == null && main == null && app == null) {
            return null;
        }
        IRuntimeClasspathEntry[] entries = JavaRuntime.computeUnresolvedRuntimeClasspath(configuration);
        entries = JavaRuntime.resolveRuntimeClasspath(entries, configuration);
        ArrayList<String> bootEntries = new ArrayList<String>(entries.length);
        boolean empty = true;
        boolean allStandard = true;
        int i = 0;
        while (i < entries.length) {
            String location;
            if (entries[i].getClasspathProperty() != 3 && (location = entries[i].getLocation()) != null) {
                empty = false;
                bootEntries.add(location);
                allStandard = allStandard && entries[i].getClasspathProperty() == 1;
            }
            ++i;
        }
        if (empty) {
            return new String[0];
        }
        if (allStandard) {
            return null;
        }
        return bootEntries.toArray(new String[bootEntries.size()]);
    }

    public String[][] getBootpathExt(ILaunchConfiguration configuration) throws CoreException {
        String[][] bootpathInfo = new String[3][];
        IRuntimeClasspathEntry[] entries = JavaRuntime.computeUnresolvedRuntimeClasspath(configuration);
        ArrayList<IRuntimeClasspathEntry> bootEntriesPrepend = new ArrayList<IRuntimeClasspathEntry>();
        int index = 0;
        IRuntimeClasspathEntry jreEntry = null;
        while (jreEntry == null && index < entries.length) {
            IRuntimeClasspathEntry entry;
            if (JavaRuntime.isVMInstallReference(entry = entries[index++])) {
                jreEntry = entry;
                continue;
            }
            if (entry.getClasspathProperty() != 2) continue;
            bootEntriesPrepend.add(entry);
        }
        IRuntimeClasspathEntry[] bootEntriesPrep = JavaRuntime.resolveRuntimeClasspath(bootEntriesPrepend.toArray(new IRuntimeClasspathEntry[bootEntriesPrepend.size()]), configuration);
        String[] entriesPrep = null;
        if (bootEntriesPrep.length > 0) {
            entriesPrep = new String[bootEntriesPrep.length];
            int i = 0;
            while (i < bootEntriesPrep.length) {
                entriesPrep[i] = bootEntriesPrep[i].getLocation();
                ++i;
            }
        }
        if (jreEntry != null) {
            IVMInstall install;
            LibraryLocation[] libraryLocations;
            ArrayList<IRuntimeClasspathEntry> bootEntriesAppend = new ArrayList<IRuntimeClasspathEntry>();
            while (index < entries.length) {
                IRuntimeClasspathEntry entry = entries[index];
                if (entry.getClasspathProperty() == 2) {
                    bootEntriesAppend.add(entry);
                }
                ++index;
            }
            bootpathInfo[0] = entriesPrep;
            IRuntimeClasspathEntry[] bootEntriesApp = JavaRuntime.resolveRuntimeClasspath(bootEntriesAppend.toArray(new IRuntimeClasspathEntry[bootEntriesAppend.size()]), configuration);
            if (bootEntriesApp.length > 0) {
                bootpathInfo[2] = new String[bootEntriesApp.length];
                int i = 0;
                while (i < bootEntriesApp.length) {
                    bootpathInfo[2][i] = bootEntriesApp[i].getLocation();
                    ++i;
                }
            }
            if ((libraryLocations = (install = this.getVMInstall(configuration)).getLibraryLocations()) != null && !JRERuntimeClasspathEntryResolver.isSameArchives(libraryLocations, install.getVMInstallType().getDefaultLibraryLocations(install.getInstallLocation()))) {
                IRuntimeClasspathEntry[] bootEntries = null;
                if (jreEntry.getType() == 4) {
                    IRuntimeClasspathEntry bootEntry = JavaRuntime.newRuntimeContainerClasspathEntry(jreEntry.getPath(), 2, this.getJavaProject(configuration));
                    bootEntries = JavaRuntime.resolveRuntimeClasspathEntry(bootEntry, configuration);
                } else {
                    bootEntries = JavaRuntime.resolveRuntimeClasspathEntry(jreEntry, configuration);
                }
                String[] bootpath = new String[bootEntriesPrep.length + bootEntries.length + bootEntriesApp.length];
                if (bootEntriesPrep.length > 0) {
                    System.arraycopy(bootpathInfo[0], 0, bootpath, 0, bootEntriesPrep.length);
                }
                int dest = bootEntriesPrep.length;
                int i = 0;
                while (i < bootEntries.length) {
                    bootpath[dest] = bootEntries[i].getLocation();
                    ++dest;
                    ++i;
                }
                if (bootEntriesApp.length > 0) {
                    System.arraycopy(bootpathInfo[2], 0, bootpath, dest, bootEntriesApp.length);
                }
                bootpathInfo[0] = null;
                bootpathInfo[1] = bootpath;
                bootpathInfo[2] = null;
            }
        } else {
            bootpathInfo[1] = entriesPrep == null ? new String[0] : entriesPrep;
        }
        return bootpathInfo;
    }

    @Deprecated
    public String[] getClasspath(ILaunchConfiguration configuration) throws CoreException {
        IRuntimeClasspathEntry[] entries = JavaRuntime.computeUnresolvedRuntimeClasspath(configuration);
        entries = JavaRuntime.resolveRuntimeClasspath(entries, configuration);
        ArrayList<String> userEntries = new ArrayList<String>(entries.length);
        HashSet<String> set = new HashSet<String>(entries.length);
        IRuntimeClasspathEntry[] iRuntimeClasspathEntryArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            String location;
            IRuntimeClasspathEntry entry = iRuntimeClasspathEntryArray[n2];
            if (!(entry.getClasspathProperty() != 3 && entry.getClasspathProperty() != 5 || (location = entry.getLocation()) == null || set.contains(location))) {
                userEntries.add(location);
                set.add(location);
            }
            ++n2;
        }
        return userEntries.toArray(new String[userEntries.size()]);
    }

    public String[][] getClasspathAndModulepath(ILaunchConfiguration config) throws CoreException {
        IRuntimeClasspathEntry[] entries = JavaRuntime.computeUnresolvedRuntimeClasspath(config);
        entries = JavaRuntime.resolveRuntimeClasspath(entries, config);
        String[][] path = new String[2][entries.length];
        ArrayList<String> classpathEntries = new ArrayList<String>(entries.length);
        ArrayList<String> modulepathEntries = new ArrayList<String>(entries.length);
        HashSet<String> classpathSet = new HashSet<String>(entries.length);
        HashSet<String> modulepathSet = new HashSet<String>(entries.length);
        IRuntimeClasspathEntry[] iRuntimeClasspathEntryArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            IRuntimeClasspathEntry entry = iRuntimeClasspathEntryArray[n2];
            String location = entry.getLocation();
            if (location != null) {
                switch (entry.getClasspathProperty()) {
                    case 3: {
                        if (classpathSet.contains(location)) break;
                        classpathEntries.add(location);
                        classpathSet.add(location);
                        break;
                    }
                    case 5: {
                        if (classpathSet.contains(location)) break;
                        classpathEntries.add(location);
                        classpathSet.add(location);
                        break;
                    }
                    case 4: {
                        if (modulepathSet.contains(location)) break;
                        modulepathEntries.add(location);
                        modulepathSet.add(location);
                        break;
                    }
                }
            }
            ++n2;
        }
        path[0] = classpathEntries.toArray(new String[classpathEntries.size()]);
        path[1] = modulepathEntries.toArray(new String[modulepathEntries.size()]);
        return path;
    }

    public IJavaProject getJavaProject(ILaunchConfiguration configuration) throws CoreException {
        IProject project;
        IJavaProject javaProject;
        String projectName = this.getJavaProjectName(configuration);
        if (projectName != null && (projectName = projectName.trim()).length() > 0 && (javaProject = JavaCore.create((IProject)(project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName)))) != null && javaProject.exists()) {
            return javaProject;
        }
        return null;
    }

    public String getJavaProjectName(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, null);
    }

    public String getMainTypeName(ILaunchConfiguration configuration) throws CoreException {
        String mainType = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, null);
        if (mainType == null) {
            return null;
        }
        return VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(mainType);
    }

    public String getProgramArguments(ILaunchConfiguration configuration) throws CoreException {
        String arguments = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, "");
        return VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(arguments);
    }

    public String getVMArguments(ILaunchConfiguration configuration) throws CoreException {
        String[] javaLibraryPath;
        String arguments = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, "");
        String args = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(arguments);
        int libraryPath = args.indexOf("-Djava.library.path");
        if (libraryPath < 0 && (javaLibraryPath = this.getJavaLibraryPath(configuration)) != null && javaLibraryPath.length > 0) {
            StringBuilder path = new StringBuilder(args);
            path.append(" -Djava.library.path=");
            path.append("\"");
            int i = 0;
            while (i < javaLibraryPath.length) {
                if (i > 0) {
                    path.append(File.pathSeparatorChar);
                }
                path.append(javaLibraryPath[i]);
                ++i;
            }
            path.append("\"");
            args = path.toString();
        }
        return args;
    }

    public String getVMArguments(ILaunchConfiguration configuration, String mode) throws CoreException {
        if (!this.isAdvancedSourcelup(mode)) {
            return "";
        }
        if (!this.isJavaagentOptionSupported(configuration)) {
            return "";
        }
        return AdvancedSourceLookupSupport.getJavaagentString();
    }

    private boolean isJavaagentOptionSupported(ILaunchConfiguration configuration) {
        try {
            IVMInstall vm = JavaRuntime.computeVMInstall(configuration);
            if (JavaRuntime.compareJavaVersions(vm, "1.4") > 0) {
                return true;
            }
        }
        catch (CoreException e) {
            LaunchingPlugin.log(e);
        }
        return false;
    }

    private boolean isAdvancedSourcelup(String mode) {
        return this.allowAdvancedSourcelookup && "debug".equals(mode) && AdvancedSourceLookupSupport.isAdvancedSourcelookupEnabled();
    }

    public Map<String, Object> getVMSpecificAttributesMap(ILaunchConfiguration configuration) throws CoreException {
        Map map = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_INSTALL_TYPE_SPECIFIC_ATTRS_MAP, null);
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        if (map != null) {
            attributes.putAll(map);
        }
        String[][] paths = this.getBootpathExt(configuration);
        String[] pre = paths[0];
        String[] boot = paths[1];
        String[] app = paths[2];
        if (pre != null) {
            attributes.put(IJavaLaunchConfigurationConstants.ATTR_BOOTPATH_PREPEND, pre);
        }
        if (app != null) {
            attributes.put(IJavaLaunchConfigurationConstants.ATTR_BOOTPATH_APPEND, app);
        }
        if (boot != null) {
            attributes.put(IJavaLaunchConfigurationConstants.ATTR_BOOTPATH, boot);
        }
        return attributes;
    }

    public File getWorkingDirectory(ILaunchConfiguration configuration) throws CoreException {
        return this.verifyWorkingDirectory(configuration);
    }

    public IPath getWorkingDirectoryPath(ILaunchConfiguration configuration) throws CoreException {
        String path = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_WORKING_DIRECTORY, null);
        if (path != null) {
            path = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(path);
            return new Path(path);
        }
        return null;
    }

    public IJavaProject verifyJavaProject(ILaunchConfiguration configuration) throws CoreException {
        IJavaProject project;
        String name = this.getJavaProjectName(configuration);
        if (name == null) {
            this.abort(LaunchingMessages.AbstractJavaLaunchConfigurationDelegate_Java_project_not_specified_9, null, 100);
        }
        if ((project = this.getJavaProject(configuration)) == null) {
            this.abort(LaunchingMessages.AbstractJavaLaunchConfigurationDelegate_Project_does_not_exist_or_is_not_a_Java_project_10, null, 107);
        }
        return project;
    }

    public String verifyMainTypeName(ILaunchConfiguration configuration) throws CoreException {
        String name = this.getMainTypeName(configuration);
        if (name == null) {
            this.abort(LaunchingMessages.AbstractJavaLaunchConfigurationDelegate_Main_type_not_specified_11, null, 101);
        }
        return name;
    }

    public File verifyWorkingDirectory(ILaunchConfiguration configuration) throws CoreException {
        IPath path = this.getWorkingDirectoryPath(configuration);
        if (path == null) {
            File dir = this.getDefaultWorkingDirectory(configuration);
            if (dir != null) {
                if (!dir.isDirectory()) {
                    this.abort(NLS.bind((String)LaunchingMessages.AbstractJavaLaunchConfigurationDelegate_Working_directory_does_not_exist___0__12, (Object[])new String[]{dir.toString()}), null, 108);
                }
                return dir;
            }
        } else if (path.isAbsolute()) {
            File dir = new File(path.toOSString());
            if (dir.isDirectory()) {
                return dir;
            }
            IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
            if (res instanceof IContainer && res.exists()) {
                return res.getLocation().toFile();
            }
            this.abort(NLS.bind((String)LaunchingMessages.AbstractJavaLaunchConfigurationDelegate_Working_directory_does_not_exist___0__12, (Object[])new String[]{path.toString()}), null, 108);
        } else {
            IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
            if (res instanceof IContainer && res.exists()) {
                return res.getLocation().toFile();
            }
            this.abort(NLS.bind((String)LaunchingMessages.AbstractJavaLaunchConfigurationDelegate_Working_directory_does_not_exist___0__12, (Object[])new String[]{path.toString()}), null, 108);
        }
        return null;
    }

    public boolean isAllowTerminate(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_ALLOW_TERMINATE, false);
    }

    public boolean isStopInMain(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_STOP_IN_MAIN, false);
    }

    protected void setDefaultSourceLocator(ILaunch launch, ILaunchConfiguration configuration) throws CoreException {
        if (launch.getSourceLocator() == null) {
            JavaSourceLookupDirector sourceLocator = new JavaSourceLookupDirector();
            sourceLocator.setSourcePathComputer(this.getLaunchManager().getSourcePathComputer("org.eclipse.jdt.launching.sourceLookup.javaSourcePathComputer"));
            sourceLocator.initializeDefaults(configuration);
            launch.setSourceLocator((ISourceLocator)sourceLocator);
        }
    }

    protected void prepareStopInMain(ILaunchConfiguration configuration) throws CoreException {
        if (this.isStopInMain(configuration)) {
            DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
        }
    }

    public void handleDebugEvents(DebugEvent[] events) {
        int i = 0;
        while (i < events.length) {
            ILaunchConfiguration configuration;
            IJavaDebugTarget target;
            ILaunch launch;
            DebugEvent event = events[i];
            if (event.getKind() == 4 && event.getSource() instanceof IJavaDebugTarget && (launch = (target = (IJavaDebugTarget)event.getSource()).getLaunch()) != null && (configuration = launch.getLaunchConfiguration()) != null) {
                try {
                    String mainType;
                    if (this.isStopInMain(configuration) && (mainType = this.getMainTypeName(configuration)) != null) {
                        HashMap<String, String> map = new HashMap<String, String>();
                        map.put(IJavaLaunchConfigurationConstants.ATTR_STOP_IN_MAIN, IJavaLaunchConfigurationConstants.ATTR_STOP_IN_MAIN);
                        IJavaMethodBreakpoint bp = JDIDebugModel.createMethodBreakpoint((IResource)ResourcesPlugin.getWorkspace().getRoot(), (String)mainType, (String)"main", (String)"([Ljava/lang/String;)V", (boolean)true, (boolean)false, (boolean)false, (int)-1, (int)-1, (int)-1, (int)1, (boolean)false, map);
                        bp.setPersisted(false);
                        target.breakpointAdded((IBreakpoint)bp);
                        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
                    }
                }
                catch (CoreException e) {
                    LaunchingPlugin.log(e);
                }
            }
            ++i;
        }
    }

    protected IProject[] getBuildOrder(ILaunchConfiguration configuration, String mode) throws CoreException {
        return this.fOrderedProjects;
    }

    protected IProject[] getProjectsForProblemSearch(ILaunchConfiguration configuration, String mode) throws CoreException {
        return this.fOrderedProjects;
    }

    protected boolean isLaunchProblem(IMarker problemMarker) throws CoreException {
        return super.isLaunchProblem(problemMarker) && problemMarker.getType().equals("org.eclipse.jdt.core.problem");
    }

    public boolean preLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        if (monitor != null) {
            monitor.subTask(LaunchingMessages.AbstractJavaLaunchConfigurationDelegate_20);
        }
        this.fOrderedProjects = null;
        IJavaProject javaProject = JavaRuntime.getJavaProject(configuration);
        if (javaProject != null) {
            this.fOrderedProjects = this.computeReferencedBuildOrder(new IProject[]{javaProject.getProject()});
        }
        return super.preLaunchCheck(configuration, mode, monitor);
    }

    protected IBreakpoint[] getBreakpoints(ILaunchConfiguration configuration) {
        IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        if (!breakpointManager.isEnabled()) {
            return null;
        }
        return breakpointManager.getBreakpoints(JDIDebugModel.getPluginIdentifier());
    }

    public IVMRunner getVMRunner(ILaunchConfiguration configuration, String mode) throws CoreException {
        IVMInstall vm = this.verifyVMInstall(configuration);
        IVMRunner runner = vm.getVMRunner(mode);
        if (runner == null) {
            this.abort(NLS.bind((String)LaunchingMessages.JavaLocalApplicationLaunchConfigurationDelegate_0, (Object[])new String[]{vm.getName(), mode}), null, 106);
        }
        return runner;
    }

    public String[] getEnvironment(ILaunchConfiguration configuration) throws CoreException {
        return DebugPlugin.getDefault().getLaunchManager().getEnvironment(configuration);
    }

    public String[] getJavaLibraryPath(ILaunchConfiguration configuration) throws CoreException {
        String[] paths;
        IJavaProject project = this.getJavaProject(configuration);
        if (project != null && (paths = JavaRuntime.computeJavaLibraryPath(project, true)).length > 0) {
            return paths;
        }
        return null;
    }

    protected File getDefaultWorkingDirectory(ILaunchConfiguration configuration) throws CoreException {
        IProject p;
        IJavaProject jp = this.getJavaProject(configuration);
        if (jp != null && (p = jp.getProject()).getLocation() != null) {
            return p.getLocation().toFile();
        }
        return null;
    }

    public ILaunch getLaunch(ILaunchConfiguration configuration, String mode) throws CoreException {
        if (!this.isAdvancedSourcelup(mode)) {
            return null;
        }
        return AdvancedSourceLookupSupport.createAdvancedLaunch(configuration, mode);
    }

    protected final void allowAdvancedSourcelookup() {
        this.allowAdvancedSourcelookup = true;
    }

    public String getModuleCLIOptions(ILaunchConfiguration configuration) throws CoreException {
        IJavaProject project;
        String moduleCLIOptions = JavaRuntime.getModuleCLIOptions(configuration);
        IRuntimeClasspathEntry[] entries = JavaRuntime.computeUnresolvedRuntimeClasspath(configuration);
        entries = JavaRuntime.resolveRuntimeClasspath(entries, configuration);
        LinkedHashMap<String, String> moduleToLocations = new LinkedHashMap<String, String>();
        IRuntimeClasspathEntry[] iRuntimeClasspathEntryArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            IRuntimeClasspathEntry entry = iRuntimeClasspathEntryArray[n2];
            String location = entry.getLocation();
            if (location != null) {
                if (entry.getClasspathProperty() == 6) {
                    IModuleDescription moduleDescription;
                    IJavaProject javaProject = entry.getJavaProject();
                    IModuleDescription iModuleDescription = moduleDescription = javaProject == null ? null : javaProject.getModuleDescription();
                    if (moduleDescription != null) {
                        String moduleName = moduleDescription.getElementName();
                        this.addPatchModuleLocations(moduleToLocations, moduleName, location);
                    }
                } else {
                    IClasspathAttribute[] iClasspathAttributeArray = entry.getClasspathEntry().getExtraAttributes();
                    int n3 = iClasspathAttributeArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IClasspathAttribute attribute = iClasspathAttributeArray[n4];
                        if ("patch-module".equals(attribute.getName())) {
                            String patchModules = attribute.getValue();
                            String[] stringArray = patchModules.split("::");
                            int n5 = stringArray.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                String patchModule = stringArray[n6];
                                int equalsIdx = patchModule.indexOf(61);
                                if (equalsIdx != -1) {
                                    if (equalsIdx < patchModule.length() - 1) {
                                        String locations = AbstractJavaLaunchConfigurationDelegate.toAbsolutePathsString(patchModule.substring(equalsIdx + 1));
                                        String moduleName = patchModule.substring(0, equalsIdx);
                                        this.addPatchModuleLocations(moduleToLocations, moduleName, locations);
                                    }
                                } else {
                                    IJavaProject javaProject = JavaRuntime.getJavaProject(configuration);
                                    this.addPatchModuleLocations(moduleToLocations, patchModule, AbstractJavaLaunchConfigurationDelegate.toAbsolutePathsString(javaProject.getOutputLocation().toString()));
                                    IClasspathEntry[] iClasspathEntryArray = javaProject.getRawClasspath();
                                    int n7 = iClasspathEntryArray.length;
                                    int n8 = 0;
                                    while (n8 < n7) {
                                        IClasspathEntry cpEntry = iClasspathEntryArray[n8];
                                        if (cpEntry.getOutputLocation() != null) {
                                            this.addPatchModuleLocations(moduleToLocations, patchModule, AbstractJavaLaunchConfigurationDelegate.toAbsolutePathsString(cpEntry.getOutputLocation().toString()));
                                        }
                                        ++n8;
                                    }
                                }
                                ++n6;
                            }
                            break;
                        }
                        ++n4;
                    }
                }
            }
            ++n2;
        }
        String addModules = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_SPECIAL_ADD_MODULES, "");
        if (moduleToLocations.isEmpty() && addModules.isEmpty()) {
            return moduleCLIOptions;
        }
        ArrayList<String> list = new ArrayList<String>();
        Collections.addAll(list, DebugPlugin.parseArguments((String)moduleCLIOptions));
        for (Map.Entry entry : moduleToLocations.entrySet()) {
            list.add("--patch-module");
            list.add(String.valueOf((String)entry.getKey()) + '=' + (String)entry.getValue());
        }
        boolean bl = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_EXCLUDE_TEST_CODE, false);
        if (!bl && (project = this.getJavaProject(configuration)) != null) {
            for (String moduleName : project.determineModulesOfProjectsWithNonEmptyClasspath()) {
                list.add("--add-reads");
                list.add(String.valueOf(moduleName) + '=' + "ALL-UNNAMED");
            }
        }
        if (!addModules.isEmpty()) {
            list.add("--add-modules");
            list.add(addModules);
        }
        return DebugPlugin.renderArguments((String[])list.toArray(new String[list.size()]), null);
    }

    private void addPatchModuleLocations(Map<String, String> moduleToLocations, String moduleName, String locations) {
        String existing = moduleToLocations.get(moduleName);
        if (existing == null) {
            moduleToLocations.put(moduleName, locations);
        } else {
            moduleToLocations.put(moduleName, String.valueOf(existing) + File.pathSeparator + locations);
        }
    }

    private static String toAbsolutePathsString(String fPaths) {
        String[] paths = fPaths.split(File.pathSeparator);
        CharSequence[] absPaths = new String[paths.length];
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        int i = 0;
        while (i < paths.length) {
            IResource resource = root.findMember((IPath)new Path(paths[i]));
            try {
                absPaths[i] = AbstractJavaLaunchConfigurationDelegate.toAbsolutePath(resource, root);
            }
            catch (CoreException e) {
                LaunchingPlugin.log(e);
            }
            if (absPaths[i] == null) {
                absPaths[i] = paths[i];
            }
            ++i;
        }
        String allPaths = String.join((CharSequence)File.pathSeparator, absPaths);
        return allPaths;
    }

    private static String toAbsolutePath(IResource resource, IWorkspaceRoot root) throws CoreException {
        IJavaElement element = JavaCore.create((IResource)resource);
        if (element != null && element.exists()) {
            if (element instanceof IJavaProject) {
                HashSet<String> paths = new HashSet<String>();
                IJavaProject project = (IJavaProject)element;
                paths.add(AbstractJavaLaunchConfigurationDelegate.absPath(root, project.getOutputLocation()));
                IClasspathEntry[] iClasspathEntryArray = project.getResolvedClasspath(true);
                int n = iClasspathEntryArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IClasspathEntry entry = iClasspathEntryArray[n2];
                    if (entry.getEntryKind() == 3 && entry.getOutputLocation() != null) {
                        paths.add(AbstractJavaLaunchConfigurationDelegate.absPath(root, entry.getOutputLocation()));
                    }
                    ++n2;
                }
                return String.join((CharSequence)File.pathSeparator, paths);
            }
            if (element instanceof IPackageFragmentRoot) {
                IPackageFragmentRoot packageRoot = (IPackageFragmentRoot)element;
                IClasspathEntry entry = packageRoot.getJavaProject().getClasspathEntryFor(resource.getFullPath());
                return AbstractJavaLaunchConfigurationDelegate.absPath(root, entry.getOutputLocation());
            }
        }
        if (resource != null) {
            return resource.getLocation().toString();
        }
        return null;
    }

    private static String absPath(IWorkspaceRoot root, IPath path) {
        return root.findMember(path).getLocation().toString();
    }

    protected boolean supportsModule() {
        return true;
    }

    protected boolean supportsPreviewFeatures(ILaunchConfiguration configuration) {
        try {
            String id;
            IJavaProject javaProject = this.getJavaProject(configuration);
            if (javaProject != null && "enabled".equals(id = javaProject.getOption("org.eclipse.jdt.core.compiler.problem.enablePreviewFeatures", true))) {
                return true;
            }
        }
        catch (CoreException coreException) {}
        return false;
    }
}

