/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.wizard.template;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.xtext.ui.wizard.template.ContainerTemplateVariable;
import org.eclipse.xtext.ui.wizard.template.ParameterComposite;
import org.eclipse.xtext.ui.wizard.template.TemplateVariable;

public class StringSelectionTemplateVariable
extends TemplateVariable {
    private String[] possibleValues;
    private String value;
    private Combo combo;

    public StringSelectionTemplateVariable(String label, String[] possibleValues, String description, ContainerTemplateVariable container) {
        super(label, description, container);
        this.possibleValues = possibleValues;
        this.value = possibleValues[0];
    }

    public String[] getPossibleValues() {
        return this.possibleValues;
    }

    @Override
    public void createWidget(final ParameterComposite parameterComposite, Composite parent) {
        this.combo = new Combo(parent, 8);
        this.combo.setItems(this.getPossibleValues());
        this.combo.setText(this.getValue());
        this.combo.setToolTipText(this.getDescription());
        this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StringSelectionTemplateVariable.this.setValue(StringSelectionTemplateVariable.this.combo.getText());
                parameterComposite.update();
            }
        });
    }

    @Override
    public void refresh() {
        if (this.combo.isEnabled() != this.isEnabled()) {
            this.combo.setEnabled(this.isEnabled());
        }
        if (!this.combo.getText().equals(this.getValue())) {
            this.combo.setText(this.getValue());
        }
    }

    @Override
    public Control getWidget() {
        return this.combo;
    }

    public String toString() {
        return this.value;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }
}

