/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.behavior.component.utilities;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.comma.actions.actions.CommandEvent;
import org.eclipse.comma.actions.actions.EVENT_KIND;
import org.eclipse.comma.actions.actions.EventPattern;
import org.eclipse.comma.actions.actions.InterfaceEventInstance;
import org.eclipse.comma.actions.actions.ParameterizedEvent;
import org.eclipse.comma.behavior.behavior.Clause;
import org.eclipse.comma.behavior.behavior.Port;
import org.eclipse.comma.behavior.behavior.State;
import org.eclipse.comma.behavior.behavior.StateMachine;
import org.eclipse.comma.behavior.behavior.Transition;
import org.eclipse.comma.behavior.component.component.AnyEvent;
import org.eclipse.comma.behavior.component.component.CommandReply;
import org.eclipse.comma.behavior.component.component.Component;
import org.eclipse.comma.behavior.component.component.ComponentPackage;
import org.eclipse.comma.behavior.component.component.ConstraintState;
import org.eclipse.comma.behavior.component.component.NotificationEvent;
import org.eclipse.comma.behavior.component.component.PortAwareEvent;
import org.eclipse.comma.behavior.component.component.SignalEvent;
import org.eclipse.comma.behavior.component.component.StateBasedFunctionalConstraint;
import org.eclipse.comma.behavior.interfaces.interfaceDefinition.Interface;
import org.eclipse.comma.behavior.utilities.StateMachineUtilities;
import org.eclipse.comma.expressions.expression.Expression;
import org.eclipse.comma.signature.interfaceSignature.InterfaceEvent;
import org.eclipse.comma.signature.interfaceSignature.Signature;
import org.eclipse.comma.types.utilities.CommaUtilities;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class ComponentUtilities {
    public static List<Signature> getAllUsedSignatures(Component c) {
        List _xblockexpression = null;
        HashSet<Signature> result = new HashSet<Signature>();
        EList _ports = c.getPorts();
        for (Port p : _ports) {
            result.add(p.getInterface());
        }
        _xblockexpression = IterableExtensions.toList(result);
        return _xblockexpression;
    }

    public static List<State> getInterfaceStatesForPort(Port p, IScopeProvider scopeProvider) {
        String signatureName;
        Signature _interface = null;
        if (p != null) {
            _interface = p.getInterface();
        }
        Signature signature = _interface;
        String _name = null;
        if (signature != null) {
            _name = signature.getName();
        }
        if ((signatureName = _name) == null) {
            return new ArrayList<State>();
        }
        List<Interface> cInterfaces = ComponentUtilities.getAllInterfaces((EObject)p, scopeProvider);
        Functions.Function1<Interface, Boolean> _function = new Functions.Function1<Interface, Boolean>(){

            public Boolean apply(Interface it) {
                String _name = it.getName();
                return Objects.equal((Object)_name, (Object)signatureName);
            }
        };
        Interface interface_ = (Interface)IterableExtensions.findFirst(cInterfaces, (Functions.Function1)_function);
        Functions.Function1<StateMachine, EList<State>> _function_1 = new Functions.Function1<StateMachine, EList<State>>(){

            public EList<State> apply(StateMachine it) {
                return it.getStates();
            }
        };
        return IterableExtensions.toList((Iterable)Iterables.concat((Iterable)ListExtensions.map((List)interface_.getMachines(), (Functions.Function1)_function_1)));
    }

    public static List<Interface> getAllInterfaces(EObject context, IScopeProvider scopeProvider) {
        List _xblockexpression = null;
        Iterable cInterfaces = scopeProvider.getScope(context, ComponentPackage.Literals.DUMMY__INTERFACE).getAllElements();
        _xblockexpression = CommaUtilities.resolveProxy((EObject)context, (Iterable)cInterfaces);
        return _xblockexpression;
    }

    public static List<Component> getAllComponents(EObject context, IScopeProvider scopeProvider) {
        List _xblockexpression = null;
        Iterable cComponents = scopeProvider.getScope(context, ComponentPackage.Literals.COMPONENT_MODEL__COMPONENT).getAllElements();
        _xblockexpression = CommaUtilities.resolveProxy((EObject)context, (Iterable)cComponents);
        return _xblockexpression;
    }

    protected static EVENT_KIND _getKind(AnyEvent ev) {
        return ev.getKind();
    }

    protected static EVENT_KIND _getKind(org.eclipse.comma.behavior.component.component.CommandEvent ev) {
        return EVENT_KIND.CALL;
    }

    protected static EVENT_KIND _getKind(SignalEvent ev) {
        return EVENT_KIND.SIGNAL;
    }

    protected static EVENT_KIND _getKind(NotificationEvent ev) {
        return EVENT_KIND.NOTIFICATION;
    }

    protected static EVENT_KIND _getKind(CommandReply ev) {
        return null;
    }

    public static boolean signatureProvidedByManyPorts(final Signature s, EObject o) {
        boolean _xblockexpression = false;
        Component parent = (Component)EcoreUtil2.getContainerOfType((EObject)o, Component.class);
        Functions.Function1<Port, Boolean> _function = new Functions.Function1<Port, Boolean>(){

            public Boolean apply(Port p) {
                Signature _interface = p.getInterface();
                return Objects.equal((Object)_interface, (Object)s);
            }
        };
        int _size = IterableExtensions.size((Iterable)IterableExtensions.filter((Iterable)parent.getPorts(), (Functions.Function1)_function));
        _xblockexpression = _size > 1;
        return _xblockexpression;
    }

    public static Port determinePort(EventPattern ev) {
        return ((PortAwareEvent)ev).getPort();
    }

    public static boolean isSubsumedBy(EventPattern ev1, EventPattern ev2) {
        Port _determinePort_1;
        boolean _notEquals;
        Port _determinePort = ComponentUtilities.determinePort(ev1);
        boolean bl = _notEquals = !Objects.equal((Object)_determinePort, (Object)(_determinePort_1 = ComponentUtilities.determinePort(ev2)));
        if (_notEquals) {
            return false;
        }
        if (ev2 instanceof AnyEvent) {
            return Objects.equal((Object)((AnyEvent)ev2).getKind(), (Object)EVENT_KIND.EVENT) || Objects.equal((Object)ComponentUtilities.getKind((EObject)ev1), (Object)((AnyEvent)ev2).getKind());
        }
        if (ev1 instanceof AnyEvent) {
            return false;
        }
        if (ev2 instanceof CommandReply) {
            if (ev1 instanceof CommandReply) {
                boolean _tripleEquals;
                boolean _or = false;
                CommandEvent _command = ((CommandReply)ev2).getCommand();
                boolean bl2 = _tripleEquals = _command == null;
                if (_tripleEquals) {
                    _or = true;
                } else {
                    boolean _equals;
                    InterfaceEvent _event = ((CommandReply)ev2).getCommand().getEvent();
                    CommandEvent _command_1 = ((CommandReply)ev1).getCommand();
                    InterfaceEvent _event_1 = null;
                    if (_command_1 != null) {
                        _event_1 = _command_1.getEvent();
                    }
                    _or = _equals = Objects.equal((Object)_event, (Object)_event_1);
                }
                return _or;
            }
            return false;
        }
        if (ev1 instanceof InterfaceEventInstance) {
            InterfaceEvent _event_2 = ((InterfaceEventInstance)ev1).getEvent();
            InterfaceEvent _event_3 = ((InterfaceEventInstance)ev2).getEvent();
            return Objects.equal((Object)_event_2, (Object)_event_3);
        }
        return false;
    }

    public static List<Expression> getParameters(EventPattern e) {
        ArrayList<Expression> _xifexpression = null;
        if (e instanceof ParameterizedEvent) {
            return ((ParameterizedEvent)e).getParameters();
        }
        _xifexpression = new ArrayList<Expression>();
        return _xifexpression;
    }

    public static ConstraintState getInitialState(StateBasedFunctionalConstraint fc) {
        boolean _not;
        Functions.Function1<State, Boolean> _function = new Functions.Function1<State, Boolean>(){

            public Boolean apply(State it) {
                return it.isInitial();
            }
        };
        Iterable initialStates = IterableExtensions.filter(fc.getStates(), (Functions.Function1)_function);
        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)initialStates);
        boolean bl = _not = !_isEmpty;
        if (_not) {
            State _get = ((State[])Conversions.unwrapArray((Object)initialStates, State.class))[0];
            return (ConstraintState)_get;
        }
        return null;
    }

    public static List<Clause> getInterfaceClausesForPort(Port p, IScopeProvider scopeProvider) {
        Signature sig;
        Signature _interface = null;
        if (p != null) {
            _interface = p.getInterface();
        }
        if ((sig = _interface) == null) {
            return null;
        }
        List<Interface> cInterfaces = ComponentUtilities.getAllInterfaces((EObject)p, scopeProvider);
        Functions.Function1<Interface, Boolean> _function = new Functions.Function1<Interface, Boolean>(){

            public Boolean apply(Interface it) {
                String _name = it.getName();
                String _name_1 = sig.getName();
                return Objects.equal((Object)_name, (Object)_name_1);
            }
        };
        Interface interface_ = (Interface)IterableExtensions.findFirst(cInterfaces, (Functions.Function1)_function);
        ArrayList<Clause> listOfClauses = new ArrayList<Clause>();
        EList _machines = interface_.getMachines();
        for (StateMachine machine : _machines) {
            EList _states = machine.getStates();
            for (State state : _states) {
                List _transitionsForState = StateMachineUtilities.transitionsForState((StateMachine)machine, (State)state);
                for (Transition transition : _transitionsForState) {
                    EList _clauses = transition.getClauses();
                    for (Clause clause : _clauses) {
                        listOfClauses.add(clause);
                    }
                }
            }
        }
        return listOfClauses;
    }

    public static EVENT_KIND getKind(EObject ev) {
        if (ev instanceof org.eclipse.comma.behavior.component.component.CommandEvent) {
            return ComponentUtilities._getKind((org.eclipse.comma.behavior.component.component.CommandEvent)ev);
        }
        if (ev instanceof NotificationEvent) {
            return ComponentUtilities._getKind((NotificationEvent)ev);
        }
        if (ev instanceof SignalEvent) {
            return ComponentUtilities._getKind((SignalEvent)ev);
        }
        if (ev instanceof AnyEvent) {
            return ComponentUtilities._getKind((AnyEvent)ev);
        }
        if (ev instanceof CommandReply) {
            return ComponentUtilities._getKind((CommandReply)ev);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(ev).toString());
    }
}

