/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.ds.internal.annotations;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.BuildContext;
import org.eclipse.jdt.core.compiler.CompilationParticipant;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTRequestor;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.build.IBuildModel;
import org.eclipse.pde.core.build.IBuildModelFactory;
import org.eclipse.pde.ds.internal.annotations.Activator;
import org.eclipse.pde.ds.internal.annotations.AnnotationProcessor;
import org.eclipse.pde.ds.internal.annotations.DSAnnotationVersion;
import org.eclipse.pde.ds.internal.annotations.Debug;
import org.eclipse.pde.ds.internal.annotations.Messages;
import org.eclipse.pde.ds.internal.annotations.ProjectContext;
import org.eclipse.pde.ds.internal.annotations.ProjectState;
import org.eclipse.pde.ds.internal.annotations.ValidationErrorLevel;
import org.eclipse.pde.internal.core.WorkspaceModelManager;
import org.eclipse.pde.internal.core.ibundle.IBundleModel;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginModelBase;
import org.eclipse.pde.internal.core.natures.PDE;
import org.eclipse.pde.internal.core.project.PDEProject;
import org.eclipse.pde.internal.ui.util.ModelModification;
import org.eclipse.pde.internal.ui.util.PDEModelUtility;
import org.eclipse.pde.internal.ui.util.TextUtil;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;

public class DSAnnotationCompilationParticipant
extends CompilationParticipant {
    private static final String DS_MANIFEST_KEY = "Service-Component";
    private static final String AP_MANIFEST_KEY = "Bundle-ActivationPolicy";
    static final String COMPONENT_ANNOTATION = "org.osgi.service.component.annotations.Component";
    static final String ANNOTATIONS_PACKAGE = "org.osgi.service.component.annotations.Component".substring(0, "org.osgi.service.component.annotations.Component".lastIndexOf(46));
    private static final IPath COMPONENT_ANNOTATION_PATH = new Path("org.osgi.service.component.annotations.Component".replace('.', '/'));
    private static final Pattern ACCESS_RULE_PATTERN = Pattern.compile("(\\*\\*)|\\*|\\?");
    private static final QualifiedName PROP_STATE = new QualifiedName("org.eclipse.pde.ds.annotations", "state");
    private static final String STATE_FILENAME = "state.dat";
    static final String BUILDPATH_PROBLEM_MARKER = "org.eclipse.pde.ds.annotations.buildpath_problem";
    private static final Debug debug = Debug.getDebug("ds-annotation-builder");
    private final Map<IJavaProject, ProjectContext> processingContext = Collections.synchronizedMap(new HashMap());

    public boolean isAnnotationProcessor() {
        return true;
    }

    public boolean isActive(IJavaProject project) {
        IPreferencesService prefs = Platform.getPreferencesService();
        boolean enabled = prefs.getBoolean("org.eclipse.pde.ds.annotations", "enabled", false, new IScopeContext[]{new ProjectScope(project.getProject()), InstanceScope.INSTANCE, DefaultScope.INSTANCE});
        if (!enabled) {
            return false;
        }
        IProject iproject = project.getProject();
        if (!iproject.isOpen() || !PDE.hasPluginNature((IProject)iproject)) {
            return false;
        }
        if (WorkspaceModelManager.isBinaryProject((IProject)project.getProject())) {
            return false;
        }
        boolean autoClasspath = prefs.getBoolean("org.eclipse.pde.ds.annotations", "classpath", true, new IScopeContext[]{new ProjectScope(project.getProject()), InstanceScope.INSTANCE, DefaultScope.INSTANCE});
        if (autoClasspath) {
            return true;
        }
        try {
            IType annotationType = project.findType(COMPONENT_ANNOTATION);
            return annotationType != null && annotationType.isAnnotation();
        }
        catch (JavaModelException e) {
            Activator.log(e);
            return false;
        }
    }

    public int aboutToBuild(IJavaProject project) {
        String missingUnbindMethodLevelStr;
        ValidationErrorLevel missingUnbindMethodLevel;
        String errorLevelStr;
        ValidationErrorLevel errorLevel;
        String specVersionStr;
        DSAnnotationVersion specVersion;
        if (debug.isDebugging()) {
            debug.trace(String.format("About to build project: %s", project.getElementName()));
        }
        int result = 1;
        int[] retval = new int[1];
        ProjectState state = DSAnnotationCompilationParticipant.getState(project, retval);
        result = retval[0];
        this.processingContext.put(project, new ProjectContext(state));
        if (state.getFormatVersion() != 1) {
            state.setFormatVersion(1);
            result = 2;
        }
        IPreferencesService prefs = Platform.getPreferencesService();
        String path = prefs.getString("org.eclipse.pde.ds.annotations", "path", "OSGI-INF", new IScopeContext[]{new ProjectScope(project.getProject()), InstanceScope.INSTANCE, DefaultScope.INSTANCE});
        if (!path.equals(state.getPath())) {
            state.setPath(path);
            result = 2;
        }
        if ((specVersion = this.getEnumValue(specVersionStr = prefs.getString("org.eclipse.pde.ds.annotations", "dsVersion", DSAnnotationVersion.V1_3.name(), new IScopeContext[]{new ProjectScope(project.getProject()), InstanceScope.INSTANCE, DefaultScope.INSTANCE}), DSAnnotationVersion.class, DSAnnotationVersion.V1_3)) != state.getSpecVersion()) {
            state.setSpecVersion(specVersion);
            result = 2;
        }
        if ((errorLevel = this.getEnumValue(errorLevelStr = prefs.getString("org.eclipse.pde.ds.annotations", "validationErrorLevel", ValidationErrorLevel.error.name(), new IScopeContext[]{new ProjectScope(project.getProject()), InstanceScope.INSTANCE, DefaultScope.INSTANCE}), ValidationErrorLevel.class, ValidationErrorLevel.error)) != state.getErrorLevel()) {
            state.setErrorLevel(errorLevel);
            result = 2;
        }
        if ((missingUnbindMethodLevel = this.getEnumValue(missingUnbindMethodLevelStr = prefs.getString("org.eclipse.pde.ds.annotations", "validationErrorLevel.missingImplicitUnbindMethod", errorLevelStr, new IScopeContext[]{new ProjectScope(project.getProject()), InstanceScope.INSTANCE, DefaultScope.INSTANCE}), ValidationErrorLevel.class, errorLevel)) != state.getMissingUnbindMethodLevel()) {
            state.setMissingUnbindMethodLevel(missingUnbindMethodLevel);
            result = 2;
        }
        Activator.getDefault().listenForClasspathPreferenceChanges(project);
        return result;
    }

    private <E extends Enum<E>> E getEnumValue(String property, Class<E> enumType, E defaultValue) {
        try {
            return Enum.valueOf(enumType, property);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return defaultValue;
        }
    }

    public static ProjectState getState(IJavaProject project) {
        return DSAnnotationCompilationParticipant.getState(project, null);
    }

    private static ProjectState getState(IJavaProject project, int[] result) {
        ProjectState state = null;
        try {
            Object value = project.getProject().getSessionProperty(PROP_STATE);
            if (value instanceof SoftReference) {
                SoftReference ref = (SoftReference)value;
                state = (ProjectState)ref.get();
            }
        }
        catch (CoreException e) {
            Activator.log(e);
        }
        if (state == null) {
            try {
                state = DSAnnotationCompilationParticipant.loadState(project.getProject());
            }
            catch (IOException e) {
                Activator.log((IStatus)new Status(4, "org.eclipse.pde.ds.annotations", "Error loading project state.", (Throwable)e));
            }
            if (state == null) {
                state = new ProjectState();
                if (result != null && result.length > 0) {
                    result[0] = 2;
                }
            }
            try {
                project.getProject().setSessionProperty(PROP_STATE, new SoftReference<ProjectState>(state));
            }
            catch (CoreException e) {
                Activator.log(e);
            }
        }
        return state;
    }

    private static ProjectState loadState(IProject project) throws IOException {
        File stateFile = DSAnnotationCompilationParticipant.getStateFile(project);
        if (!stateFile.canRead()) {
            if (debug.isDebugging()) {
                debug.trace(String.format("Missing or invalid project state file: %s", stateFile));
            }
            return null;
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (ObjectInputStream in = new ObjectInputStream(new FileInputStream(stateFile));){
                ProjectState state = (ProjectState)in.readObject();
                if (debug.isDebugging()) {
                    debug.trace(String.format("Loaded state for project: %s", project.getName()));
                    for (String cuKey : state.getCompilationUnits()) {
                        debug.trace(String.format("%s -> %s", cuKey, state.getModelFiles(cuKey)));
                    }
                }
                return state;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (ClassNotFoundException e) {
            IOException ex = new IOException("Unable to deserialize project state.");
            ex.initCause(e);
            throw ex;
        }
    }

    public void buildFinished(IJavaProject project) {
        ProjectContext projectContext = this.processingContext.remove(project);
        if (projectContext != null) {
            HashSet<String> retained;
            HashSet<String> abandoned;
            ProjectState state;
            block32: {
                Collection<String> dsKeys2;
                state = projectContext.getState();
                abandoned = new HashSet<String>(projectContext.getAbandoned());
                for (String cuKey : projectContext.getUnprocessed()) {
                    boolean exists = false;
                    try {
                        IResource file;
                        IJavaElement cu = project.findElement((IPath)new Path(cuKey));
                        if (cu != null && cu.getElementType() == 5 && (file = cu.getResource()) != null && file.exists() && file.getProject().equals((Object)project.getProject())) {
                            exists = true;
                        }
                    }
                    catch (JavaModelException e) {
                        Activator.log(e);
                    }
                    if (exists) continue;
                    if (debug.isDebugging()) {
                        debug.trace(String.format("Mapped CU %s no longer exists.", cuKey));
                    }
                    if ((dsKeys2 = state.removeMappings(cuKey)) == null) continue;
                    abandoned.addAll(dsKeys2);
                }
                retained = new HashSet<String>();
                for (String cuKey : state.getCompilationUnits()) {
                    dsKeys2 = state.getModelFiles(cuKey);
                    if (dsKeys2 == null) continue;
                    retained.addAll(dsKeys2);
                }
                try {
                    IMarker[] cpMarkers = project.getProject().findMarkers(BUILDPATH_PROBLEM_MARKER, false, 0);
                    if (retained.isEmpty()) {
                        IMarker[] iMarkerArray = cpMarkers;
                        int file = cpMarkers.length;
                        int dsKeys2 = 0;
                        while (dsKeys2 < file) {
                            IMarker marker = iMarkerArray[dsKeys2];
                            marker.delete();
                            ++dsKeys2;
                        }
                        break block32;
                    }
                    abandoned.removeAll(retained);
                    boolean markerNeeded = false;
                    IPackageFragmentRoot[] roots = project.getPackageFragmentRoots();
                    int i = roots.length - 1;
                    block11: while (i >= 0) {
                        IPackageFragmentRoot root = roots[i];
                        IPackageFragment fragment = root.getPackageFragment(ANNOTATIONS_PACKAGE);
                        if (fragment.exists()) {
                            IAccessRule[] accessRules;
                            IClasspathEntry entry = root.getResolvedClasspathEntry();
                            boolean packageAccessible = true;
                            IAccessRule[] iAccessRuleArray = accessRules = entry.getAccessRules();
                            int n = accessRules.length;
                            int n2 = 0;
                            while (n2 < n) {
                                IAccessRule accessRule = iAccessRuleArray[n2];
                                if (this.matches(COMPONENT_ANNOTATION_PATH, accessRule.getPattern())) {
                                    if (accessRule.getKind() != 1) break;
                                    packageAccessible = false;
                                    break;
                                }
                                ++n2;
                            }
                            if (packageAccessible) {
                                IClasspathAttribute[] attrs;
                                IClasspathAttribute[] iClasspathAttributeArray = attrs = entry.getExtraAttributes();
                                int n3 = attrs.length;
                                n = 0;
                                while (n < n3) {
                                    IClasspathAttribute attr = iClasspathAttributeArray[n];
                                    if ("org.eclipse.pde.ds.annotations.cp".equals(attr.getName()) && Boolean.parseBoolean(attr.getValue())) {
                                        markerNeeded = true;
                                        break block11;
                                    }
                                    ++n;
                                }
                                break;
                            }
                        }
                        --i;
                    }
                    if (markerNeeded) {
                        if (cpMarkers.length == 0) {
                            project.getProject().createMarker(BUILDPATH_PROBLEM_MARKER, Map.of("severity", 1, "priority", 2, "message", Messages.DSAnnotationCompilationParticipant_buildpathProblemMarker_message, "location", Messages.DSAnnotationCompilationParticipant_buildpathProblemMarker_location));
                        }
                    } else {
                        IMarker[] iMarkerArray = cpMarkers;
                        int fragment = cpMarkers.length;
                        int root = 0;
                        while (root < fragment) {
                            IMarker marker = iMarkerArray[root];
                            marker.delete();
                            ++root;
                        }
                    }
                }
                catch (CoreException e) {
                    Activator.log(e);
                }
            }
            if (projectContext.isChanged()) {
                try {
                    this.saveState(project.getProject(), state);
                }
                catch (IOException e) {
                    Activator.log(Status.error((String)"Error saving file mappings.", (Throwable)e));
                }
            }
            ArrayList<IStatus> deleteStatuses = new ArrayList<IStatus>(2);
            for (String dsKey : abandoned) {
                IFile file;
                IPath path = Path.fromPortableString((String)dsKey);
                if (debug.isDebugging()) {
                    debug.trace(String.format("Deleting %s", path));
                }
                if (!(file = PDEProject.getBundleRelativeFile((IProject)project.getProject(), (IPath)path)).exists()) continue;
                try {
                    file.delete(true, null);
                }
                catch (CoreException e) {
                    deleteStatuses.add(e.getStatus());
                }
            }
            if (!deleteStatuses.isEmpty()) {
                Activator.log((IStatus)new MultiStatus("org.eclipse.pde.ds.annotations", 0, deleteStatuses.toArray(new IStatus[deleteStatuses.size()]), "Error deleting generated files.", null));
            }
            if (!retained.isEmpty() || !abandoned.isEmpty()) {
                this.updateProject(project.getProject(), retained, abandoned);
            }
        }
        if (debug.isDebugging()) {
            debug.trace(String.format("Build finished for project: %s", project.getElementName()));
        }
    }

    private boolean matches(IPath path, IPath pattern) {
        if (pattern.hasTrailingSeparator()) {
            pattern = pattern.append("**");
        }
        StringBuilder buf = new StringBuilder();
        Matcher m = ACCESS_RULE_PATTERN.matcher(pattern.toString().replace(".", "\\."));
        while (m.find()) {
            if ("**".equals(m.group())) {
                m.appendReplacement(buf, ".*");
                continue;
            }
            if ("?".equals(m.group())) {
                m.appendReplacement(buf, "[^/]");
                continue;
            }
            m.appendReplacement(buf, "[^/]*");
        }
        return Pattern.matches(m.appendTail(buf).toString(), path.toString());
    }

    private void saveState(IProject project, ProjectState state) throws IOException {
        File stateFile = DSAnnotationCompilationParticipant.getStateFile(project);
        if (debug.isDebugging()) {
            debug.trace(String.format("Saving state for project: %s", project.getName()));
            for (String cuKey : state.getCompilationUnits()) {
                debug.trace(String.format("%s -> %s", cuKey, state.getModelFiles(cuKey)));
            }
        }
        Throwable throwable = null;
        Iterator<String> iterator = null;
        try (ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(stateFile));){
            out.writeObject(state);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void updateProject(final IProject project, final Collection<String> retained, final Collection<String> abandoned) {
        PDEModelUtility.modifyModel((ModelModification)new ModelModification(project){

            protected void modifyModel(IBaseModel model, IProgressMonitor monitor) throws CoreException {
                if (model instanceof IBundlePluginModelBase) {
                    DSAnnotationCompilationParticipant.this.updateManifest((IBundlePluginModelBase)model, retained, abandoned, project);
                }
            }
        }, null);
        PDEModelUtility.modifyModel((ModelModification)new ModelModification(PDEProject.getBuildProperties((IProject)project)){

            protected void modifyModel(IBaseModel model, IProgressMonitor monitor) throws CoreException {
                if (model instanceof IBuildModel) {
                    DSAnnotationCompilationParticipant.this.updateBuildProperties((IBuildModel)model, retained, abandoned);
                }
            }
        }, null);
    }

    private void updateManifest(IBundlePluginModelBase model, Collection<String> retained, Collection<String> abandoned, IProject project) {
        IPath path;
        IBundleModel bundleModel = model.getBundleModel();
        LinkedHashSet<IPath> entries = new LinkedHashSet<IPath>();
        this.collectManifestEntries(bundleModel, entries);
        boolean changed = false;
        for (String dsKey : abandoned) {
            path = Path.fromPortableString((String)dsKey);
            changed |= entries.remove(path);
        }
        for (String dsKey : retained) {
            path = Path.fromPortableString((String)dsKey);
            if (this.isManifestEntryIncluded(entries, path)) continue;
            changed |= entries.add(path);
        }
        if (!changed) {
            return;
        }
        String value = entries.stream().map(IPath::toString).sorted().collect(Collectors.joining("," + TextUtil.getDefaultLineDelimiter() + " "));
        if (debug.isDebugging()) {
            debug.trace(String.format("Setting manifest header in %s to %s: %s", model.getUnderlyingResource().getFullPath(), DS_MANIFEST_KEY, value));
        }
        bundleModel.getBundle().setHeader(DS_MANIFEST_KEY, value);
        boolean generateBAPL = Platform.getPreferencesService().getBoolean("org.eclipse.pde.ds.annotations", "generateBundleActivationPolicyLazy", true, new IScopeContext[]{new ProjectScope(project.getProject()), InstanceScope.INSTANCE});
        if (generateBAPL) {
            if (debug.isDebugging()) {
                debug.trace(String.format("Setting manifest header in %s to %s: %s", model.getUnderlyingResource().getFullPath(), AP_MANIFEST_KEY, "lazy"));
            }
            bundleModel.getBundle().setHeader(AP_MANIFEST_KEY, "lazy");
        }
    }

    private void collectManifestEntries(IBundleModel bundleModel, Collection<IPath> entries) {
        String[] elements;
        String header = bundleModel.getBundle().getHeader(DS_MANIFEST_KEY);
        if (header == null) {
            return;
        }
        String[] stringArray = elements = header.split("\\s*,\\s*");
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            if (element.length() != 0) {
                entries.add((IPath)new Path(element));
            }
            ++n2;
        }
    }

    private boolean isManifestEntryIncluded(Collection<IPath> entries, IPath path) {
        for (IPath entry : entries) {
            Filter filter;
            if (entry.equals((Object)path)) {
                return true;
            }
            if (!entry.removeLastSegments(1).equals((Object)path.removeLastSegments(1))) continue;
            try {
                filter = FrameworkUtil.createFilter((String)("(filename=" + this.sanitizeFilterValue(entry.lastSegment()) + ")"));
            }
            catch (InvalidSyntaxException invalidSyntaxException) {
                continue;
            }
            if (!filter.matches(Collections.singletonMap("filename", path.lastSegment()))) continue;
            return true;
        }
        return false;
    }

    private String sanitizeFilterValue(String value) {
        return value.replace("\\", "\\\\").replace("(", "\\(").replace(")", "\\)");
    }

    private void updateBuildProperties(IBuildModel model, Collection<String> retained, Collection<String> abandoned) throws CoreException {
        IBuildEntry includes = model.getBuild().getEntry("bin.includes");
        if (includes != null) {
            for (String dsKey : abandoned) {
                String path = Path.fromPortableString((String)dsKey).toString();
                if (!includes.contains(path)) continue;
                includes.removeToken(path);
            }
        }
        if (!retained.isEmpty()) {
            if (includes == null) {
                IBuildModelFactory factory = model.getFactory();
                includes = factory.createEntry("bin.includes");
                model.getBuild().add(includes);
            }
            LinkedHashSet<IPath> entries = new LinkedHashSet<IPath>();
            this.collectBuildEntries(includes, entries);
            Iterator iterator = retained.stream().sorted().iterator();
            while (iterator.hasNext()) {
                String dsKey = (String)iterator.next();
                IPath path = Path.fromPortableString((String)dsKey);
                if (this.isBuildEntryIncluded(entries, path)) continue;
                includes.addToken(path.toString());
            }
        }
    }

    private void collectBuildEntries(IBuildEntry includes, Collection<IPath> entries) {
        if (includes == null) {
            return;
        }
        String[] stringArray = includes.getTokens();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String include = stringArray[n2];
            if ((include = include.trim()).length() != 0) {
                entries.add((IPath)new Path(include));
            }
            ++n2;
        }
    }

    private boolean isBuildEntryIncluded(Collection<IPath> entries, IPath path) {
        for (IPath entry : entries) {
            if (entry.equals((Object)path)) {
                return true;
            }
            if (!entry.hasTrailingSeparator() || !entry.isPrefixOf(path)) continue;
            return true;
        }
        return false;
    }

    public void processAnnotations(BuildContext[] files) {
        HashMap<IJavaProject, HashMap<ICompilationUnit, BuildContext>> filesByProject = new HashMap<IJavaProject, HashMap<ICompilationUnit, BuildContext>>();
        BuildContext[] buildContextArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            ICompilationUnit cu;
            BuildContext file = buildContextArray[n2];
            if (debug.isDebugging()) {
                debug.trace(String.format("Creating compilation unit from file %s.", file.getFile().getFullPath()));
            }
            if ((cu = JavaCore.createCompilationUnitFrom((IFile)file.getFile())) == null) {
                if (debug.isDebugging()) {
                    debug.trace(String.format("Unable to create compilation unit from file %s.", file.getFile().getFullPath()));
                }
            } else if (this.canSkipFile(cu)) {
                this.markAsAbandoned(cu);
            } else {
                HashMap<ICompilationUnit, BuildContext> map = (HashMap<ICompilationUnit, BuildContext>)filesByProject.get(cu.getJavaProject());
                if (map == null) {
                    map = new HashMap<ICompilationUnit, BuildContext>();
                    filesByProject.put(cu.getJavaProject(), map);
                }
                map.put(cu, file);
            }
            ++n2;
        }
        for (Map.Entry entry : filesByProject.entrySet()) {
            if (debug.isDebugging()) {
                debug.trace(String.format("Processing compilation units in project %s.", ((IJavaProject)entry.getKey()).getElementName()));
            }
            this.processAnnotations((IJavaProject)entry.getKey(), (Map)entry.getValue());
        }
    }

    public boolean canSkipFile(ICompilationUnit cu) {
        IType primaryType = cu.findPrimaryType();
        if (primaryType == null) {
            return false;
        }
        try {
            return !this.containsComponent(primaryType);
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }

    private boolean containsComponent(IType type) throws JavaModelException {
        boolean hasComponentAnnotation;
        IAnnotation annotationWithImport = type.getAnnotation("Component");
        IAnnotation fullyQualifiedAnnotation = type.getAnnotation(COMPONENT_ANNOTATION);
        boolean bl = hasComponentAnnotation = annotationWithImport.exists() || fullyQualifiedAnnotation.exists();
        if (hasComponentAnnotation) {
            return true;
        }
        IJavaElement[] iJavaElementArray = type.getChildren();
        int n = iJavaElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElement child = iJavaElementArray[n2];
            if (child instanceof IType && this.containsComponent((IType)child)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void markAsAbandoned(ICompilationUnit cu) {
        ProjectContext projectContext = this.processingContext.get(cu.getJavaProject());
        String cuKey = AnnotationProcessor.getCompilationUnitKey(cu);
        projectContext.getUnprocessed().remove(cuKey);
        ProjectState state = projectContext.getState();
        Collection<String> oldDSKeys = state.updateMappings(cuKey, new HashMap<String, String>());
        if (oldDSKeys != null) {
            projectContext.getAbandoned().addAll(oldDSKeys);
        }
    }

    private void processAnnotations(IJavaProject javaProject, Map<ICompilationUnit, BuildContext> fileMap) {
        ASTParser parser = ASTParser.newParser((int)4);
        parser.setResolveBindings(true);
        parser.setBindingsRecovery(true);
        parser.setProject(javaProject);
        parser.setKind(8);
        ProjectContext projectContext = this.processingContext.get(javaProject);
        ProjectState state = projectContext.getState();
        parser.setIgnoreMethodBodies(state.getErrorLevel() == ValidationErrorLevel.ignore);
        ICompilationUnit[] cuArr = fileMap.keySet().toArray(new ICompilationUnit[fileMap.size()]);
        parser.createASTs(cuArr, new String[0], (ASTRequestor)new AnnotationProcessor(projectContext, fileMap), null);
    }

    public static boolean isManaged(IProject project) {
        block3: {
            try {
                if (project.getSessionProperty(PROP_STATE) == null) break block3;
                return true;
            }
            catch (CoreException coreException) {
                return false;
            }
        }
        File stateFile = DSAnnotationCompilationParticipant.getStateFile(project);
        return stateFile.canRead();
    }

    private static File getStateFile(IProject project) {
        File workDir = project.getWorkingLocation("org.eclipse.pde.ds.annotations").toFile();
        File stateFile = new File(workDir, STATE_FILENAME);
        return stateFile;
    }
}

